/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vcard4j.parser;

import java.util.Iterator;

public class EscapableStringTokenizer
implements Iterator {
    private static final char[][][] translationTable = new char[][][]{new char[][]{{'\\', '\\'}, {'\\'}}, new char[][]{{'\\', ';'}, {';'}}, new char[][]{{'\\', ','}, {','}}, new char[][]{{'\\', 'n'}, {'\n'}}, new char[][]{{'\\', 'N'}, {'\n'}}, new char[][]{{'=', '0', 'A'}, {'\n'}}};
    private boolean unescape;
    private char delimiter;
    private char[] array;
    private int index = 0;
    private int count = -1;

    public EscapableStringTokenizer(String str, char delimiter) {
        this(str, delimiter, false);
    }

    public EscapableStringTokenizer(String str, char delimiter, boolean unescape) {
        this.array = str.toCharArray();
        this.delimiter = delimiter;
        this.unescape = unescape;
    }

    @Override
    public boolean hasNext() {
        if (this.array == null) {
            return false;
        }
        if (this.count >= 0) {
            return true;
        }
        this.count = 0;
        while (this.index + this.count < this.array.length) {
            if (this.array[this.index + this.count] == '\\') {
                ++this.count;
            } else if (this.array[this.index + this.count] == this.delimiter) {
                return true;
            }
            ++this.count;
        }
        return true;
    }

    public Object next() {
        return this.nextToken();
    }

    public String nextToken() {
        String result;
        if (!this.hasNext()) {
            return null;
        }
        if (this.unescape) {
            StringBuffer sb = new StringBuffer(this.count * 2);
            for (int i = 0; i < this.count; ++i) {
                boolean translate = false;
                for (int j = 0; j < translationTable.length; ++j) {
                    translate = true;
                    for (int k = 0; i + k < this.count && k < translationTable[j][0].length; ++k) {
                        if (translationTable[j][0][k] == this.array[this.index + i + k]) continue;
                        translate = false;
                        break;
                    }
                    if (!translate) continue;
                    sb.append(translationTable[j][1][0]);
                    i += translationTable[j][0].length - 1;
                    break;
                }
                if (translate) continue;
                sb.append(this.array[this.index + i]);
            }
            result = sb.toString();
        } else {
            result = new String(this.array, this.index, this.count);
        }
        this.index += this.count + 1;
        this.count = -1;
        if (this.index >= this.array.length) {
            this.array = null;
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() not supported");
    }

    public static String unescape(String str) {
        EscapableStringTokenizer st = new EscapableStringTokenizer(str, '\u0000', true);
        return st.nextToken();
    }

    public static String escape(String str) {
        int length = str.length();
        StringBuffer sb = new StringBuffer(length * 2);
        for (int i = 0; i < length; ++i) {
            boolean translated = false;
            for (int j = 0; j < translationTable.length; ++j) {
                if (translationTable[j][1][0] != str.charAt(i)) continue;
                for (int k = 0; k < translationTable[j][0].length; ++k) {
                    sb.append(translationTable[j][0][k]);
                }
                translated = true;
                break;
            }
            if (translated) continue;
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }
}

