/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vcard4j.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.sf.vcard4j.search.Query;
import net.sf.vcard4j.util.XpathUtil;
import org.w3c.dom.Node;

public class SimpleQuery
implements Query {
    private String pattern = "";
    private boolean matching = true;
    private Set types = new HashSet();
    private boolean complement = false;
    private List resultingTypes = new ArrayList();
    private List resultingVcards = new ArrayList();

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String p) {
        if (p == null) {
            p = "";
        }
        this.pattern = p;
    }

    public void addType(String type) {
        this.types.add(type.toUpperCase());
    }

    public void removeType(String type) {
        this.types.remove(type);
    }

    public Set getTypes() {
        return this.types;
    }

    public boolean getMatching() {
        return this.matching;
    }

    public void setMatching(boolean v) {
        this.matching = v;
    }

    public boolean getComplementaryTypes() {
        return this.complement;
    }

    public void setComplementaryTypes(boolean v) {
        this.complement = v;
    }

    @Override
    public boolean search(Node root) {
        this.resultingTypes.clear();
        this.resultingVcards.clear();
        String typeQuery = "";
        if (this.complement) {
            typeQuery = typeQuery + "not(";
        }
        Iterator i = this.types.iterator();
        while (i.hasNext()) {
            typeQuery = typeQuery + "@name='" + i.next() + "'";
            if (!i.hasNext()) continue;
            typeQuery = typeQuery + " or ";
        }
        if (this.complement) {
            typeQuery = typeQuery + ")";
        }
        Iterator vcardIterator = XpathUtil.getNodeIterator(root, "//vcard");
        while (vcardIterator.hasNext()) {
            Node vcard = (Node)vcardIterator.next();
            Iterator typeIterator = XpathUtil.getNodeIterator(root, "type[" + typeQuery + "]");
            boolean match = false;
            while (typeIterator.hasNext()) {
                Node type = (Node)typeIterator.next();
                Iterator valueIterator = XpathUtil.getValueIterator(type, "value//text/text()");
                while (valueIterator.hasNext()) {
                    String value = (String)valueIterator.next();
                    if (!Pattern.matches(this.pattern, value)) continue;
                    this.matching = true;
                    this.resultingTypes.add(type);
                }
            }
            if (match != this.matching) continue;
            this.resultingVcards.add(vcard);
        }
        return this.resultingVcards.size() > 0;
    }

    @Override
    public Set getMatchingVCards() {
        return new HashSet(this.resultingVcards);
    }

    @Override
    public Set getMatchingTypes() {
        return new HashSet(this.resultingTypes);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.complement) {
            sb.append("! ");
        }
        Iterator i = this.types.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(" | ");
        }
        if (this.matching) {
            sb.append(" == \"");
        } else {
            sb.append(" != \"");
        }
        for (int i2 = 0; i2 < this.pattern.length(); ++i2) {
            char c = this.pattern.charAt(i2);
            if (c == '\"' || c == '\\') {
                sb.append('\\');
            }
            sb.append(c);
        }
        sb.append("\"");
        return sb.toString();
    }
}

