/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vcard4j.util;

import java.util.Stack;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DomWriter {
    protected Document document = null;
    protected Stack path = new Stack();

    public DomWriter() {
        this.document = new DocumentImpl();
    }

    public DomWriter(Node root) {
        this.document = root.getOwnerDocument();
        this.path.push(root);
    }

    public DomWriter(Document document) {
        this.document = document;
        Element root = document.getDocumentElement();
        if (root != null) {
            this.path.push(root);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public Element addElement(String name) {
        Element child = this.document.createElement(name);
        if (this.path.empty()) {
            this.document.appendChild(child);
        } else {
            ((Node)this.path.peek()).appendChild(child);
        }
        this.path.push(child);
        return child;
    }

    public Element closeElement() {
        return (Element)this.path.pop();
    }

    public Element getElement() {
        return (Element)this.path.peek();
    }

    public void setAttribute(String name, String value) {
        Element element = (Element)this.path.peek();
        element.setAttribute(name, value);
    }

    public void setText(String text) {
        Text child = this.document.createTextNode(text);
        Element parent = (Element)this.path.peek();
        parent.appendChild(child);
        this.path.push(child);
    }
}

