/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.commons.vocabulary;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import org.orioai.commons.vocabulary.TermValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Term
implements Serializable {
    private static final long serialVersionUID = -2963892185868862305L;
    private static Logger log = LoggerFactory.getLogger(Term.class);
    private String id;
    private List<TermValue> values;
    private List<String> simpleValues;
    private List<TermValue> allHierarchyValues = null;
    private HashMap<String, String> labels = new HashMap();
    private HashMap<String, String> descriptions = new HashMap();
    private Term parent;
    private List<Term> children;
    private int level = 0;
    private boolean hidden = false;

    public Term() {
        this.values = new ArrayList<TermValue>();
        this.children = new ArrayList<Term>();
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getId() {
        return this.id;
    }

    public HashMap<String, String> getLabels() {
        return this.labels;
    }

    public HashMap<String, String> getDescriptions() {
        return this.descriptions;
    }

    public String getLabel(String language, String defaultLanguage) {
        String userLabel = this.labels.get(language);
        if (userLabel == null) {
            String defaultLabel = this.labels.get(defaultLanguage);
            return defaultLabel;
        }
        return userLabel;
    }

    public String getDescription(Locale userLocale, Locale defaultLocale) {
        String userLabel = this.descriptions.get(userLocale.getLanguage());
        if (userLabel == null) {
            String defaultLabel = this.descriptions.get(defaultLocale.getLanguage());
            return defaultLabel;
        }
        return userLabel;
    }

    public List<TermValue> getValues() {
        return this.values;
    }

    public int getValuesSize() {
        return this.values.size();
    }

    public List<TermValue> getAllHierarchyValues() {
        if (this.allHierarchyValues == null) {
            this.allHierarchyValues = new ArrayList<TermValue>();
            this.getAllHierarchyValues(this.allHierarchyValues, this);
        }
        return this.allHierarchyValues;
    }

    public List<String> getSimpleValues() {
        if (this.simpleValues == null) {
            this.simpleValues = new ArrayList<String>();
            for (TermValue value : this.getValues()) {
                this.simpleValues.add(value.getValue());
            }
        }
        return this.simpleValues;
    }

    private void getAllHierarchyValues(List<TermValue> pivotIds, Term term) {
        int i;
        List<TermValue> currentIds = term.getValues();
        for (i = 0; i < currentIds.size(); ++i) {
            pivotIds.add(currentIds.get(i));
        }
        for (i = 0; i < term.getChildren().size(); ++i) {
            Term child = term.getChildren().get(i);
            this.getAllHierarchyValues(pivotIds, child);
        }
    }

    public Term getParent() {
        return this.parent;
    }

    public List<Term> getChildren() {
        return this.children;
    }

    public Hashtable<String, Term> getChild() {
        Hashtable<String, Term> child = new Hashtable<String, Term>(this.getChildrenSize());
        for (int i = 0; i < this.getChildrenSize(); ++i) {
            Term c = this.getChildren().get(i);
            child.put(c.getId(), c);
        }
        return child;
    }

    public int getChildrenSize() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLabels(HashMap<String, String> labels) {
        this.labels = labels;
    }

    public void setDescriptions(HashMap<String, String> descriptions) {
        this.descriptions = descriptions;
    }

    public void setValue(TermValue value) {
        this.values.add(value);
        value.setTerm(this);
    }

    public void setTerm(Term term) {
        term.setParent(this);
        this.children.add(term);
    }

    public void setParent(Term parent) {
        this.parent = parent;
    }

    public void setChildren(List<Term> children) {
        this.children = children;
    }

    public boolean equals(Object arg0) {
        Term cat = (Term)arg0;
        return cat.getId().equals(this.getId());
    }

    public static Term searchTerm(Term rootTerm, String id) {
        String rootTermId = rootTerm.getId();
        if (rootTermId != null && rootTermId.equals(id)) {
            return rootTerm;
        }
        List<Term> children = rootTerm.getChildren();
        if (children == null || children.size() == 0) {
            return null;
        }
        for (int i = 0; i < children.size(); ++i) {
            Term foundCat = Term.searchTerm(children.get(i), id);
            if (foundCat == null) continue;
            return foundCat;
        }
        log.debug("searchTerm :: term not found, return null");
        return null;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public String toString() {
        return "id=" + this.id + ", labels=" + this.labels + ", descriptions=" + this.descriptions + ", values=" + this.values + ", children=" + this.children;
    }

    public Term clone() {
        Term clone = this.cloneWithoutFamily();
        int childrenSize = this.children.size();
        clone.children = new ArrayList<Term>(childrenSize);
        for (int i = 0; i < childrenSize; ++i) {
            Term cloneChild = this.children.get(i).clone();
            cloneChild.setParent(clone);
            clone.children.add(cloneChild);
        }
        clone.setParent(this.getParent());
        return clone;
    }

    public Term cloneWithoutFamily() {
        Term clone = new Term();
        clone.id = this.id;
        clone.labels = (HashMap)this.labels.clone();
        clone.descriptions = (HashMap)this.descriptions.clone();
        clone.values = this.values;
        for (TermValue val : clone.values) {
            val.setTerm(clone);
        }
        clone.level = this.level;
        return clone;
    }
}

