/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.commons.vocabulary.service.remote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.orioai.commons.vocabulary.service.remote.RemoteVocabularyTermCaption;
import org.orioai.commons.vocabulary.service.remote.RemoteVocabularyTermLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteVocabularyTerm {
    private static Logger log = LoggerFactory.getLogger(RemoteVocabularyTerm.class);
    private String classificationId;
    private List<String> values;
    private List<String> valuesFromIdentifier;
    private List<String> allHierarchyValues;
    private RemoteVocabularyTermCaption caption = new RemoteVocabularyTermCaption();
    private RemoteVocabularyTermCaption description = new RemoteVocabularyTermCaption();
    private RemoteVocabularyTerm parent;
    private List<RemoteVocabularyTerm> children;
    private boolean validIndex = true;

    public RemoteVocabularyTerm() {
        this.values = new ArrayList<String>();
        this.valuesFromIdentifier = new ArrayList<String>();
        this.children = new ArrayList<RemoteVocabularyTerm>();
        this.allHierarchyValues = null;
    }

    public RemoteVocabularyTerm(Hashtable<String, RemoteVocabularyTermLabel> labels, Hashtable<String, RemoteVocabularyTermLabel> descriptions, List<RemoteVocabularyTerm> children) {
        this.caption.setLabels(labels);
        this.description.setLabels(descriptions);
        this.children = children;
    }

    public String getId() {
        return this.classificationId;
    }

    public boolean isValidIndex() {
        return this.validIndex;
    }

    public void setValidIndex(boolean validIndex) {
        this.validIndex = validIndex;
    }

    public void setCaption(RemoteVocabularyTermCaption caption) {
        this.caption = caption;
    }

    public String getLabel(String language, String defaultLanguage) {
        return this.caption.getLabel(language, defaultLanguage);
    }

    public HashMap<String, String> getLabels(List<String> allLanguages, String defaultLanguage) {
        HashMap<String, String> labels = new HashMap<String, String>();
        for (String language : allLanguages) {
            String vocabularyTermLabel = this.caption.getLabel(language, defaultLanguage);
            labels.put(language, vocabularyTermLabel);
        }
        return labels;
    }

    public void setDescription(RemoteVocabularyTermCaption description) {
        this.description = description;
    }

    public String getDescription(String language, String defaultLanguage) {
        return this.description.getLabel(language, defaultLanguage);
    }

    public HashMap<String, String> getDescriptions(List<String> allLanguages, String defaultLanguage) {
        HashMap<String, String> labels = new HashMap<String, String>();
        for (String language : allLanguages) {
            String vocabularyTermLabel = this.description.getLabel(language, defaultLanguage);
            labels.put(language, vocabularyTermLabel);
        }
        return labels;
    }

    public List<String> getValues() {
        if (this.isValidIndex()) {
            if (this.values.size() != 0) {
                return this.values;
            }
            return this.valuesFromIdentifier;
        }
        return new ArrayList<String>();
    }

    public List<String> getAllHierarchyValues() {
        if (this.allHierarchyValues == null) {
            this.allHierarchyValues = new ArrayList<String>();
            this.getAllHierarchyValues(this.allHierarchyValues, this);
        }
        return this.allHierarchyValues;
    }

    private void getAllHierarchyValues(List<String> pivotIds, RemoteVocabularyTerm term) {
        int i;
        List<String> currentIds = term.getValues();
        for (i = 0; i < currentIds.size(); ++i) {
            pivotIds.add(currentIds.get(i));
        }
        for (i = 0; i < term.getChildren().size(); ++i) {
            RemoteVocabularyTerm child = term.getChildren().get(i);
            this.getAllHierarchyValues(pivotIds, child);
        }
    }

    public RemoteVocabularyTerm getParent() {
        return this.parent;
    }

    public List<RemoteVocabularyTerm> getChildren() {
        return this.children;
    }

    public int getChildrenSize() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public void setClassificationId(String classificationId) {
        this.classificationId = classificationId;
    }

    public void setValue(String value) {
        this.values.add(value);
    }

    public void setValueFromIdentifier(String value) {
        this.valuesFromIdentifier.add(value);
    }

    public void setTerm(RemoteVocabularyTerm term) {
        term.setParent(this);
        this.children.add(term);
    }

    public void setParent(RemoteVocabularyTerm parent) {
        this.parent = parent;
    }

    public void setChildren(List<RemoteVocabularyTerm> children) {
        this.children = children;
    }

    public boolean equals(Object arg0) {
        RemoteVocabularyTerm cat = (RemoteVocabularyTerm)arg0;
        return cat.getId().equals(this.getId());
    }

    public static RemoteVocabularyTerm searchTerm(RemoteVocabularyTerm rootTerm, String id) {
        String classificationId = rootTerm.getId();
        if (classificationId != null && classificationId.equals(id)) {
            return rootTerm;
        }
        List<RemoteVocabularyTerm> children = rootTerm.getChildren();
        if (children == null || children.size() == 0) {
            return null;
        }
        for (int i = 0; i < children.size(); ++i) {
            RemoteVocabularyTerm foundCat = RemoteVocabularyTerm.searchTerm(children.get(i), id);
            if (foundCat == null) continue;
            return foundCat;
        }
        log.debug("searchTerm :: term not found, return null");
        return null;
    }

    private String xmlValue(RemoteVocabularyTerm term, String language, String defaultLanguage) {
        try {
            int i;
            String s = "";
            String id = term.classificationId;
            if (id != null) {
                id = id.replaceAll("&", "&amp;");
                id = id.replaceAll("\"", "&#148;");
            }
            s = s + "<term id=\"" + id + "\">\n";
            String label = term.getLabel(language, defaultLanguage);
            s = s + "<label><![CDATA[" + label + "]]></label>\n";
            String description = term.getDescription(language, defaultLanguage);
            s = s + "<description><![CDATA[" + description + "]]></description>\n";
            for (i = 0; term.values != null && i < term.values.size(); ++i) {
                s = s + "<value><![CDATA[" + term.values.get(i) + "]]></value>";
                if (i == term.values.size() - 1) continue;
                s = s + "\n";
            }
            for (i = 0; term.children != null && i < term.children.size(); ++i) {
                s = s + this.xmlValue(term.children.get(i), language, defaultLanguage);
            }
            s = s + "</term>\n";
            return s;
        }
        catch (Exception e) {
            log.error("xmlValue :: " + e, (Throwable)e);
            return null;
        }
    }

    public String xmlValue(String language, String defaultLanguage) {
        return this.xmlValue(this, language, defaultLanguage);
    }
}

