/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.ws.indexing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.orioai.ws.indexing.IndexRecordFormat;
import org.orioai.ws.indexing.IndexRecordUrl;
import org.orioai.ws.indexing.cxfAdapters.StringIndexRecordFormatMapAdapter;
import org.orioai.ws.indexing.cxfAdapters.StringObjectListMapAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class IndexRecord {
    private String id;
    private Float score;
    private String recordSet;
    private boolean internalRecord = false;
    @XmlJavaTypeAdapter(value=StringIndexRecordFormatMapAdapter.class)
    @XmlElement(name="formats")
    private HashMap<String, IndexRecordFormat> formats = new HashMap();
    @XmlJavaTypeAdapter(value=StringObjectListMapAdapter.class)
    @XmlElement(name="attributesValues")
    private HashMap<String, ArrayList<Object>> attributesValues = new HashMap();
    @XmlJavaTypeAdapter(value=StringObjectListMapAdapter.class)
    @XmlElement(name="hlAttributesValues")
    private HashMap<String, ArrayList<Object>> hlAttributesValues = new HashMap();

    public IndexRecord() {
    }

    public IndexRecord(String id, String recordSet) {
        this.id = id;
        this.recordSet = recordSet;
    }

    public IndexRecord(String id, IndexRecordFormat formatIndexRecord, String recordSet) {
        this.id = id;
        this.recordSet = recordSet;
        this.addFormat(formatIndexRecord);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Float getScore() {
        return this.score;
    }

    public void setScore(Float score) {
        this.score = score;
    }

    public String getRecordSet() {
        return this.recordSet;
    }

    public void setRecordSet(String recordSet) {
        this.recordSet = recordSet;
    }

    public final void addFormat(IndexRecordFormat indexRecordFormat) {
        this.formats.put(indexRecordFormat.getNamespace(), indexRecordFormat);
    }

    public void setFormats(HashMap<String, IndexRecordFormat> formats) {
        this.formats = formats;
    }

    public IndexRecordFormat getFormat(String namespace) {
        IndexRecordFormat irf = this.formats.get(namespace);
        if (irf == null) {
            throw new IllegalArgumentException("Can't find format with name space: '" + namespace + "'");
        }
        return irf;
    }

    public Collection<IndexRecordFormat> getFormats() {
        return this.formats.values();
    }

    public IndexRecordFormat getUniqueFormat() {
        if (this.formats.size() != 1) {
            return null;
        }
        return this.formats.entrySet().iterator().next().getValue();
    }

    public void removeFormat(String namespace) {
        IndexRecordFormat irf = this.formats.get(namespace);
        if (irf == null) {
            throw new IllegalArgumentException("Can't remove format with namespace '" + namespace + "'");
        }
        this.formats.remove(namespace);
    }

    public List<String> getNamespaces() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<IndexRecordFormat> it = this.formats.values().iterator();
        while (it.hasNext()) {
            list.add(it.next().getNamespace());
        }
        return list;
    }

    public HashMap<String, ArrayList<Object>> getAttributesValues() {
        return this.attributesValues;
    }

    public String getAttributeValue(String attributeName) {
        ArrayList<Object> values = this.attributesValues.get(attributeName);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (String)values.get(0);
    }

    public void setAttributesValues(HashMap<String, ArrayList<Object>> attributesValues) {
        this.attributesValues = attributesValues;
    }

    public HashMap<String, ArrayList<Object>> getHlAttributesValues() {
        return this.hlAttributesValues;
    }

    public void setHlAttributesValues(HashMap<String, ArrayList<Object>> hlAttributesValues) {
        this.hlAttributesValues = hlAttributesValues;
    }

    public boolean isInternalRecord() {
        return this.internalRecord;
    }

    public void setInternalRecord(boolean internalRecord) {
        this.internalRecord = internalRecord;
    }

    public boolean isOnlyDeadLinks() {
        for (IndexRecordFormat irf : this.formats.values()) {
            ArrayList<IndexRecordUrl> urlList = irf.getIndexRecordUrls();
            for (IndexRecordUrl url : urlList) {
                if (url.isValid() != null && !url.isValid().booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        String s = "";
        Iterator<String> it = this.getAttributesValues().keySet().iterator();
        s = s + "Record id : " + this.getId() + "\n";
        while (it.hasNext()) {
            String key = it.next();
            s = s + "\t" + key + " : " + this.getAttributesValues().get(key) + "\n";
        }
        return s;
    }
}

