/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.ws.indexing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.orioai.ws.indexing.IndexRecordFormatLang;
import org.orioai.ws.indexing.IndexRecordUrl;
import org.orioai.ws.indexing.cxfAdapters.StringIndexRecordFormatLangMapAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class IndexRecordFormat {
    private String namespace;
    private String repository;
    private String datestamp;
    private String recordComingFrom;
    private String xmlContent;
    private String originalNamespace;
    private String originalXmlContent;
    @XmlJavaTypeAdapter(value=StringIndexRecordFormatLangMapAdapter.class)
    @XmlElement(name="recordFormatLangs")
    private HashMap<String, IndexRecordFormatLang> recordFormatLangs = new HashMap();
    @XmlElement(name="indexRecordUrls")
    private ArrayList<IndexRecordUrl> indexRecordUrls = new ArrayList();

    public IndexRecordFormat() {
    }

    public IndexRecordFormat(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getDatestamp() {
        return this.datestamp;
    }

    public void setDatestamp(String datestamp) {
        this.datestamp = datestamp;
    }

    public String getRecordComingFrom() {
        return this.recordComingFrom;
    }

    public void setRecordComingFrom(String recordComingFrom) {
        this.recordComingFrom = recordComingFrom;
    }

    public String getXmlContent() {
        return this.xmlContent;
    }

    public void setXmlContent(String xmlContent) {
        this.xmlContent = xmlContent;
    }

    public String getOriginalNamespace() {
        return this.originalNamespace;
    }

    public void setOriginalNamespace(String originalNamespace) {
        this.originalNamespace = originalNamespace;
    }

    public String getOriginalXmlContent() {
        return this.originalXmlContent;
    }

    public void setOriginalXmlContent(String originalXmlContent) {
        this.originalXmlContent = originalXmlContent;
    }

    public HashSet<IndexRecordFormatLang> getRecordFormatLangs() {
        return new HashSet<IndexRecordFormatLang>(this.recordFormatLangs.values());
    }

    public IndexRecordFormatLang getRecordFormatLang(String lang) {
        return this.recordFormatLangs.get(lang);
    }

    public void addRecordFormatLang(IndexRecordFormatLang recordFormatLang) {
        this.recordFormatLangs.put(recordFormatLang.getLang(), recordFormatLang);
    }

    public void removeRecordFormatLang(String lang) {
        this.recordFormatLangs.remove(lang);
    }

    public ArrayList<IndexRecordUrl> getIndexRecordUrls() {
        return this.indexRecordUrls;
    }

    public void setIndexRecordUrls(ArrayList<IndexRecordUrl> indexRecordUrls) {
        this.indexRecordUrls = indexRecordUrls;
    }

    public void addIndexRecordUrl(IndexRecordUrl iUrl) {
        this.indexRecordUrls.add(iUrl);
    }

    public IndexRecordUrl getIndexRecordUrl(String url) {
        for (IndexRecordUrl iUrl : this.indexRecordUrls) {
            if (!iUrl.getAddress().equals(url)) continue;
            return iUrl;
        }
        return null;
    }
}

