/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.ws.vocabulary;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.orioai.ws.vocabulary.IVocabularyService;

public class MockVocabularyService
implements IVocabularyService {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Map<String, String> vocabMap = null;
    private List<String> vocabIds;

    public void init() {
        if (this.vocabMap != null) {
            this.vocabIds = new ArrayList<String>();
            for (Map.Entry<String, String> entry : this.vocabMap.entrySet()) {
                this.vocabIds.add(entry.getKey());
                if (entry.getValue() != null) {
                    String content = this.getFileAsString(entry.getValue().trim());
                    entry.setValue(content);
                    continue;
                }
                this.logger.error((Object)("no value for entry key : " + entry.getKey()));
            }
        }
    }

    private String getFileAsString(String filePath) {
        String content = null;
        try {
            FileInputStream fis = new FileInputStream(filePath);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
            char[] buffer = new char[2048];
            StringBuffer sb = new StringBuffer();
            int size = -1;
            while ((size = isr.read(buffer)) != -1) {
                sb.append(buffer, 0, size);
                content = sb.toString();
            }
            isr.close();
            fis.close();
        }
        catch (Exception e) {
            this.logger.error((Object)("cant read mock vocabulary :" + filePath), (Throwable)e);
        }
        return content;
    }

    @Override
    public List<String> getVocabularies(List<String> vocabularyIds) {
        return null;
    }

    @Override
    public List<String> getVocabulariesId() {
        return this.vocabIds;
    }

    @Override
    public String getVocabulary(String vocabularyId) {
        return this.vocabMap.get(vocabularyId);
    }

    public void setVocabMap(Map<String, String> vocabMap) {
        this.vocabMap = vocabMap;
    }

    @Override
    public String xquery(String vocId) {
        return "<ori-xquery-result xmlns:vdex=\"http://www.imsglobal.org/xsd/imsvdex_v1p0\"><vdex:langstring value=\"vocId\">" + vocId + "</vdex:langstring>" + "</ori-xquery-result>";
    }

    @Override
    public String xquery(String vocId, String queryName) {
        return "<ori-xquery-result xmlns:vdex=\"http://www.imsglobal.org/xsd/imsvdex_v1p0\"><vdex:langstring value=\"vocId\">" + vocId + "</vdex:langstring>" + "<vdex:langstring value=\"queryName\">" + queryName + "</vdex:langstring>" + "</ori-xquery-result>";
    }

    @Override
    public String xquery(String vocId, Map<String, String> params) {
        return "<ori-xquery-result xmlns:vdex=\"http://www.imsglobal.org/xsd/imsvdex_v1p0\"><vdex:langstring value=\"vocId\">" + vocId + "</vdex:langstring>" + "<vdex:langstring value=\"params\">params</vdex:langstring>" + "</ori-xquery-result>";
    }

    @Override
    public String xquery(String vocId, String queryName, Map<String, String> params) {
        return "<ori-xquery-result xmlns:vdex=\"http://www.imsglobal.org/xsd/imsvdex_v1p0\"><vdex:langstring value=\"vocId\">" + vocId + "</vdex:langstring>" + "<vdex:langstring value=\"queryName\">" + queryName + "</vdex:langstring>" + "<vdex:langstring value=\"params\">params</vdex:langstring>" + "</ori-xquery-result>";
    }

    @Override
    public String pxquery(String vocId, String payload) {
        return this.xquery(vocId);
    }

    @Override
    public String pxquery(String vocId, String queryName, String payload) {
        return this.xquery(vocId, queryName);
    }
}

