/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vcard4j.application.birthday;

import java.io.FileInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import net.sf.vcard4j.parser.DomParser;
import net.sf.vcard4j.util.XpathUtil;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BirthdayReminder
extends TimerTask {
    private int daysAhead = 3;
    private String smtpHost = null;
    private String from = null;
    private String to = null;
    private String subject = "Birthday reminder";
    private Document addressBook = null;
    private String addressBookUrl = null;
    private Timer timer = null;
    private int hour = 1;
    private int minute = 0;

    public static void main(String[] args) {
        BirthdayReminder reminder = new BirthdayReminder(args[0], args[1], args[2], args[3]);
        Node[] vcards = reminder.checkBirthday();
        System.err.println(vcards.length);
        for (int i = 0; i < vcards.length; ++i) {
            reminder.sendMail(vcards[i]);
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public BirthdayReminder(String addressBookUrl, String from, String to, String smtpHost) {
        this.addressBookUrl = addressBookUrl;
        this.loadAddressBook();
        this.to = to;
        this.from = from;
        this.smtpHost = smtpHost;
    }

    public void loadAddressBook() {
        try {
            DomParser parser = new DomParser();
            this.addressBook = new DocumentImpl();
            try {
                URL url = new URL(this.addressBookUrl);
                parser.parse(url.openStream(), (Node)this.addressBook);
            }
            catch (Exception e) {
                parser.parse(new FileInputStream(this.addressBookUrl), (Node)this.addressBook);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Node[] checkBirthday() {
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).add(6, this.daysAhead);
        String pattern = "-";
        if (calendar.get(2) + 1 < 10) {
            pattern = pattern + "0";
        }
        pattern = pattern + (calendar.get(2) + 1);
        pattern = pattern + "-";
        if (calendar.get(5) < 10) {
            pattern = pattern + "0";
        }
        pattern = pattern + calendar.get(5);
        return XpathUtil.getNodeArray(this.addressBook, "addressBook/vcard[contains(type[@name='BDAY']/value/text/text(),'" + pattern + "')]");
    }

    @Override
    public void run() {
        this.loadAddressBook();
        Node[] vcards = this.checkBirthday();
        for (int i = 0; i < vcards.length; ++i) {
            this.sendMail(vcards[i]);
        }
        this.schedule();
    }

    public void sendMail(Node vcard) {
        try {
            Properties props = System.getProperties();
            if (this.smtpHost != null) {
                props.put("mail.smtp.host", this.smtpHost);
            }
            Session session = Session.getDefaultInstance((Properties)props, null);
            MimeMessage message = new MimeMessage(session);
            if (this.from != null) {
                message.setFrom((Address)new InternetAddress(this.from));
            } else {
                message.setFrom();
            }
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.to, (boolean)false));
            message.setSubject(this.getMailSubject(vcard));
            message.setText(this.getMailBody(vcard));
            message.setHeader("X-Mailer", "VCard4J");
            message.setSentDate(new Date());
            Transport.send((Message)message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getMailSubject(Node vcard) {
        String name = null;
        name = XpathUtil.getValue(vcard, "type[@name='NICKNAME']/value/listItem/text/text()");
        if (name == null) {
            name = XpathUtil.getValue(vcard, "type[@name='N']/value/structuredItem[2]/listItem/text/text()");
            name = name == null ? "" : name + " ";
            name = name + XpathUtil.getValue(vcard, "type[@name='N']/value/structuredItem[1]/listItem/text/text()");
        }
        return this.subject + ": " + name;
    }

    protected String getMailBody(Node vcard) {
        StringWriter writer = new StringWriter();
        try {
            OutputFormat format = new OutputFormat();
            format.setOmitDocumentType(true);
            format.setOmitXMLDeclaration(true);
            format.setMethod("xml");
            format.setIndenting(true);
            format.setPreserveSpace(false);
            format.setLineWidth(0);
            XMLSerializer serializer = new XMLSerializer((Writer)writer, format);
            serializer.serialize((Element)vcard);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println(writer.getBuffer().toString());
        return writer.getBuffer().toString();
    }

    public void schedule() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(11, this.hour);
        calendar.set(12, this.minute);
        ((Calendar)calendar).add(6, 1);
        if (this.timer == null) {
            this.timer = new Timer();
        }
        this.timer.schedule((TimerTask)this, calendar.getTime());
    }
}

