/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vcard4j.application.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.vcard4j.parser.DomParser;
import net.sf.vcard4j.util.DomUtil;
import net.sf.vcard4j.util.XpathUtil;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VCardServlet
extends HttpServlet {
    public static final String ADDRESS_BOOK_URL = "vcard4j.addresses";
    public static final String ADDRESS_BOOK_URL_DEFAULT = "http://localhost:8180/data/addresses.vcf";
    private String addressBookLocation = null;
    private DomParser parser = new DomParser();
    private Document addressBook = null;
    private long lastModified = -1L;

    public void init(ServletConfig config) throws ServletException {
        this.addressBookLocation = config.getInitParameter(ADDRESS_BOOK_URL);
        if (this.addressBookLocation == null) {
            this.addressBookLocation = config.getServletContext().getInitParameter(ADDRESS_BOOK_URL);
        }
        if (this.addressBookLocation == null) {
            this.addressBookLocation = ADDRESS_BOOK_URL_DEFAULT;
        }
    }

    public Document getAddressBook() throws IOException {
        URLConnection connection = new URL(this.addressBookLocation).openConnection();
        connection.connect();
        long date = connection.getLastModified();
        if (this.lastModified >= date) {
            return this.addressBook;
        }
        this.addressBook = new DocumentImpl();
        InputStream in = connection.getInputStream();
        this.parser.parse(in, (Node)this.addressBook);
        in.close();
        return this.addressBook;
    }

    public Iterator getAddresses(Iterator fn) throws IOException {
        if (fn == null) {
            ArrayList<Element> result = new ArrayList<Element>();
            result.add(this.getAddressBook().getDocumentElement());
            return result.iterator();
        }
        String xpath = "address-book/vcard[";
        while (fn.hasNext()) {
            xpath = "type[@name='FN' and value/text()='" + fn.next() + "']";
            if (!fn.hasNext()) continue;
            xpath = xpath + " or ";
        }
        xpath = xpath + "]";
        return XpathUtil.getNodeIterator(this.getAddressBook(), xpath);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        PrintWriter out = null;
        try {
            out = resp.getWriter();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        resp.setContentType("text/xml");
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<?xml-stylesheet type=\"text/xsl\" href=\"xsl/vcard4j-2-xhtml.xsl\"?>");
        try {
            DomUtil.println((Node)this.getAddressBook(), out);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        out.flush();
    }
}

