/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vcard4j.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import net.sf.vcard4j.compiler.TypeCompiler;
import net.sf.vcard4j.util.XpathUtil;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class GenericTypeCompiler
implements TypeCompiler {
    protected Document configuration = null;
    public String packageName = "net.sf.vcard4j.java.type";
    public String sourcePath = "src" + File.separator + "java";

    public static void main(String[] args) {
        try {
            String file = args.length > 0 ? args[0] : System.getProperty("user.dir") + "/cfg/vcard4j-cfg.xml";
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(new FileInputStream(file)));
            Document configuration = parser.getDocument();
            GenericTypeCompiler compiler = new GenericTypeCompiler(configuration);
            compiler.compile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public GenericTypeCompiler() {
    }

    public GenericTypeCompiler(Document configuration) {
        this.configuration = configuration;
    }

    public void compile(String name, OutputStream out) {
        this.compile(name, new PrintWriter(out));
    }

    public void compile(String name, PrintWriter out) {
        Element type = (Element)XpathUtil.getNode(this.configuration, "/vcard4jConfiguration/type[@name='" + name + "']");
        this.compile(type, out);
    }

    public void compile() throws IOException {
        String path = this.sourcePath + File.separator + this.packageName.replace('.', File.separatorChar) + File.separator;
        Iterator it = XpathUtil.getNodeIterator(this.configuration, "/vcard4jConfiguration/type");
        while (it.hasNext()) {
            Element type = (Element)it.next();
            File file = new File(path + this.getJavaName(XpathUtil.getValue(type, "@name")) + ".java");
            if (!file.exists()) {
                System.out.println("Generating: " + file.toString());
                PrintWriter out = new PrintWriter(new FileWriter(file, false));
                this.compile(type, out);
                continue;
            }
            System.out.println("Skipping (file exists): " + file.toString());
        }
    }

    protected String getJavaName(String typeName) {
        return typeName.replaceAll("[^a-zA-Z0-9]", "_");
    }

    public void compile(Element type, PrintWriter out) {
        TypeCompiler compiler;
        String format = XpathUtil.getValue(type, "@format");
        if (format == null) {
            format = "single";
        }
        String compilerName = this.getClass().getPackage().getName() + "." + format.substring(0, 1).toUpperCase() + format.substring(1) + "TypeCompiler";
        try {
            compiler = (TypeCompiler)Class.forName(compilerName).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        compiler.print(type, out);
    }

    public void printParameters(Element type, PrintWriter out) {
        int i;
        String parameterName;
        Node parameter;
        out.println("  public class Parameters extends net.sf.vcard4j.java.Parameters {");
        out.println("    public Parameters(Element type) {");
        out.println("      super(type);");
        out.println();
        Iterator itP = XpathUtil.getNodeIterator(type, "parameter");
        while (itP.hasNext()) {
            parameter = (Node)itP.next();
            parameterName = XpathUtil.getValue(parameter, "@name");
            Node[] values = XpathUtil.getNodeArray(parameter, "value");
            String pv = parameterName.toUpperCase().replaceAll("[^A-Z-0-9]", "_");
            out.print("      PARAMETER_VALUES.put(\"" + pv + "\", new String[] { ");
            for (i = 0; i < values.length; ++i) {
                out.print("\"" + XpathUtil.getValue(values[i], "@name").toUpperCase() + "\"");
                if (i != values.length - 1) {
                    out.print(", ");
                    continue;
                }
                out.println(" });");
            }
        }
        out.println("    }");
        itP = XpathUtil.getNodeIterator(type, "parameter");
        while (itP.hasNext()) {
            parameter = (Node)itP.next();
            parameterName = XpathUtil.getValue(parameter, "@name");
            String parameterDescription = XpathUtil.getValue(parameter, "description/text()");
            Node[] values = XpathUtil.getNodeArray(parameter, "value");
            out.println();
            for (i = 0; i < values.length; ++i) {
                String valueName = XpathUtil.getValue(values[i], "@name");
                String valueDescription = XpathUtil.getValue(values[i], "description/text()");
                if (valueDescription != null) {
                    out.println("    /** " + valueDescription.trim() + " */");
                }
                String valueField = parameterName + "_" + valueName;
                valueField = valueField.toUpperCase().replaceAll("[^A-Z-0-9]", "_");
                out.println("    public static final int " + valueField + " = " + i + ";");
            }
            out.println();
            if (parameterDescription != null) {
                out.println("    /** " + parameterDescription.trim() + " */");
            }
            out.println("    public void add" + parameterName + "(int value) {");
            out.println("      super.add(\"" + parameterName + "\", value);");
            out.println("    }");
            out.println();
            if (parameterDescription != null) {
                out.println("    /** " + parameterDescription.trim() + " */");
            }
            out.println("    public void remove" + parameterName + "(int value) {");
            out.println("      super.remove(\"" + parameterName + "\", value);");
            out.println("    }");
            out.println();
            if (parameterDescription != null) {
                out.println("    /** " + parameterDescription.trim() + " */");
            }
            out.println("    public boolean contains" + parameterName + "(int value) {");
            out.println("      return super.contains(\"" + parameterName + "\", value);");
            out.println("    }");
            out.println();
            if (parameterDescription != null) {
                out.println("    /** " + parameterDescription.trim() + " */");
            }
            out.println("    public java.util.Iterator iterator" + parameterName + "() {");
            out.println("      return super.iterator(\"" + parameterName + "\");");
            out.println("    }");
            out.println();
            if (parameterDescription != null) {
                out.println("    /** " + parameterDescription.trim() + " */");
            }
            out.println("    public void clear" + parameterName + "() {");
            out.println("      super.clear(\"" + parameterName + "\");");
            out.println("    }");
        }
        out.println("  }");
        out.println();
        out.println("  private Parameters parameters;");
        out.println("  public net.sf.vcard4j.java.Parameters getParameters() {");
        out.println("    if (parameters == null)");
        out.println("      parameters = new Parameters(getElement());");
        out.println("    return parameters;");
        out.println("  }");
    }

    @Override
    public void print(Element type, PrintWriter out) {
        throw new UnsupportedOperationException("Requires a specialized class");
    }
}

