/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vcard4j.compiler;

import java.io.PrintWriter;
import net.sf.vcard4j.compiler.GenericTypeCompiler;
import net.sf.vcard4j.util.XpathUtil;
import org.w3c.dom.Element;

public class ListTypeCompiler
extends GenericTypeCompiler {
    @Override
    public void print(Element type, PrintWriter out) {
        String typeName = this.getJavaName(XpathUtil.getValue(type, "@name"));
        String typeDescription = XpathUtil.getValue(type, "description/text()");
        String valueName = XpathUtil.getValue(type, "value/@name");
        String valueDescription = XpathUtil.getValue(type, "value/description/text()");
        String valueType = XpathUtil.getValue(type, "value/implementation/@className");
        valueName = valueName == null ? "" : valueName.substring(0, 1).toUpperCase() + valueName.substring(1);
        if (valueType == null) {
            valueType = "java.lang.String";
        }
        if (valueDescription != null) {
            valueDescription = valueDescription.trim();
        }
        out.println("package " + this.packageName + ";");
        out.println();
        out.println("import org.w3c.dom.*;");
        out.println("import net.sf.vcard4j.java.*;");
        out.println("import java.lang.reflect.*;");
        out.println();
        out.println("/**");
        if (typeDescription != null) {
            out.println(" * " + typeDescription.trim());
        }
        out.println(" * ");
        out.println(" * @author generated by " + this.getClass().getName());
        out.println(" */");
        out.println("public class " + typeName + " extends ListType {");
        out.println();
        out.println("  protected static final Constructor valueTypeConstructor;");
        out.println("  static {");
        out.println("    try {");
        out.println("      valueTypeConstructor = " + valueType + ".class.getConstructor(new Class[] { String.class });");
        out.println("    } catch (Exception e) {");
        out.println("      throw new RuntimeException(e);");
        out.println("    }");
        out.println("  }");
        out.println();
        out.println("  public " + typeName + "(Element type) {");
        out.println("    super(type);");
        out.println("  }");
        out.println();
        if (valueDescription != null) {
            out.println("  /** " + valueDescription + " */");
        }
        out.println("  public void add" + valueName + "(" + valueType + " value) {");
        out.println("    super.add(value);");
        out.println("  }");
        out.println();
        if (valueDescription != null) {
            out.println("  /** " + valueDescription + " */");
        }
        out.println("  public " + valueType + " get" + valueName + "(int index) {");
        out.println("    return (" + valueType + ") super.get(valueTypeConstructor, index);");
        out.println("  }");
        out.println();
        if (valueDescription != null) {
            out.println("  /** " + valueDescription + " */");
        }
        out.println("  public java.util.Iterator iterator" + valueName + "() {");
        out.println("    return super.iterator(valueTypeConstructor);");
        out.println("  }");
        out.println();
        if (valueDescription != null) {
            out.println("  /** " + valueDescription + " */");
        }
        out.println("  public int size" + valueName + "() {");
        out.println("    return super.size();");
        out.println("  }");
        out.println();
        this.printParameters(type, out);
        out.println("}");
        out.flush();
    }
}

