/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vcard4j.search;

import net.sf.vcard4j.search.BinaryQuery;
import net.sf.vcard4j.search.Query;
import net.sf.vcard4j.search.QueryStringTokenizer;
import net.sf.vcard4j.search.SimpleQuery;

public class QueryParser {
    private QueryStringTokenizer tokenizer;

    public Query parse(String queryString) {
        this.tokenizer = new QueryStringTokenizer(queryString);
        return this.parseQueries();
    }

    protected Query parseQueries() {
        int nextType;
        Query query0 = this.parseQuery();
        block4: while ((nextType = this.tokenizer.nextType()) != -1) {
            switch (nextType) {
                case 3: 
                case 4: {
                    this.tokenizer.next();
                    Query query1 = this.parseQuery();
                    BinaryQuery queryB = new BinaryQuery();
                    queryB.setLeftOperand(query0);
                    queryB.setRightOperand(query1);
                    queryB.setOperator(nextType == 3);
                    query0 = queryB;
                    continue block4;
                }
                case -1: {
                    continue block4;
                }
            }
            throw new RuntimeException("Parse error: expecting 'AND' or 'OR' instead of: " + this.tokenizer.remaining());
        }
        return query0;
    }

    protected Query parseQuery() {
        Query query;
        switch (this.tokenizer.nextType()) {
            case 1: {
                this.tokenizer.next();
                query = this.parseQuery();
                if (this.tokenizer.nextType() != 2) {
                    throw new RuntimeException("Parse error: expecting ')' instead of: " + this.tokenizer.remaining());
                }
                this.tokenizer.next();
                break;
            }
            case 5: 
            case 7: {
                query = this.parseSimpleQuery();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected token: " + this.tokenizer.remaining());
            }
        }
        return query;
    }

    protected Query parseSimpleQuery() {
        SimpleQuery query = new SimpleQuery();
        if (this.tokenizer.nextType() == 5) {
            query.setComplementaryTypes(true);
            this.tokenizer.next();
        }
        if (this.tokenizer.nextType() != 7) {
            throw new RuntimeException("Parse erro: expecting TYPE instead of: " + this.tokenizer.remaining());
        }
        query.addType((String)this.tokenizer.next());
        while (this.tokenizer.nextType() == 6) {
            this.tokenizer.next();
            if (this.tokenizer.nextType() != 7) {
                throw new RuntimeException("Parse erro: expecting type instead of: " + this.tokenizer.remaining());
            }
            query.addType((String)this.tokenizer.next());
        }
        switch (this.tokenizer.nextType()) {
            case 8: {
                query.setMatching(true);
                break;
            }
            case 9: {
                query.setMatching(false);
                break;
            }
            default: {
                throw new RuntimeException("Parse error: expecting '==' or '!=' instead of: " + this.tokenizer.remaining());
            }
        }
        this.tokenizer.next();
        if (this.tokenizer.nextType() != 10) {
            throw new RuntimeException("Parse erro: expecting pattern instead of: " + this.tokenizer.remaining());
        }
        query.setPattern((String)this.tokenizer.next());
        return query;
    }
}

