/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vcard4j.search;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryStringTokenizer
implements Iterator {
    public static final int UNDEFINED = -2;
    public static final int DONE = -1;
    public static final int UNKNOWN = 0;
    public static final int LEFT_BRACKET = 1;
    public static final int RIGHT_BRACKET = 2;
    public static final int QUERY_AND = 3;
    public static final int QUERY_OR = 4;
    public static final int TYPE_NOT = 5;
    public static final int TYPE_OR = 6;
    public static final int TYPE = 7;
    public static final int EQUALS = 8;
    public static final int DIFFERS = 9;
    public static final int PATTERN = 10;
    public static final int NB_TOKENS = 11;
    public static final String[][] TOKENS = new String[][]{{null, null}, {"(", null}, {")", null}, {null, "[^\\w\\-][aA][nN][dD][^\\w\\-]"}, {null, "[^\\w\\-][oO][rR][^\\w\\-]"}, {"^", null}, {"|", null}, {null, "[\\w\\-]+"}, {"==", null}, {"!=", null}, {"\"", null}};
    public static final Matcher[] MATCHERS = new Matcher[11];
    private int[] indexes = new int[11];
    private int minIndex = -2;
    private String queryString;
    private char[] array;
    private int index = 0;

    public QueryStringTokenizer(String query) {
        this.queryString = query;
        this.array = query.toCharArray();
        for (int i = 0; i < 11; ++i) {
            if (TOKENS[i][1] == null) continue;
            QueryStringTokenizer.MATCHERS[i] = Pattern.compile(TOKENS[i][1]).matcher(query);
        }
        this.resetIndexes();
    }

    private void resetIndexes() {
        if (this.minIndex != -2) {
            return;
        }
        if (this.index >= this.array.length || this.queryString.substring(this.index).trim().length() == 0) {
            this.minIndex = -1;
            this.index = this.array.length;
            return;
        }
        System.out.println("Tokenizing: " + this.queryString.substring(this.index));
        this.minIndex = 0;
        for (int i = 0; i < 11; ++i) {
            this.indexes[i] = TOKENS[i][0] != null ? this.queryString.indexOf(TOKENS[i][0], this.index) : (MATCHERS[i] != null && MATCHERS[i].find(this.index) ? MATCHERS[i].start() : -1);
            if ((this.indexes[i] <= 0 || this.indexes[i] >= this.indexes[this.minIndex]) && this.indexes[this.minIndex] >= 0) continue;
            this.minIndex = i;
        }
        if (this.index < this.indexes[this.minIndex] && this.queryString.substring(this.index, this.indexes[this.minIndex]).trim().length() > 0) {
            this.minIndex = 0;
        }
        System.out.println("Token: " + TOKENS[this.minIndex][0] + "/" + TOKENS[this.minIndex][1]);
    }

    @Override
    public boolean hasNext() {
        this.resetIndexes();
        return this.minIndex != -1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public Object next() {
        String tmp = null;
        this.resetIndexes();
        if (this.minIndex == 10) {
            this.index = this.indexes[this.minIndex];
            StringBuffer sb = new StringBuffer();
            while (this.array[++this.index] != '\"') {
                if (this.array[this.index] == '\\') {
                    ++this.index;
                }
                sb.append(this.array[this.index]);
            }
            tmp = sb.toString();
            ++this.index;
        } else if (TOKENS[this.minIndex][0] != null) {
            tmp = TOKENS[this.minIndex][0];
            this.index = this.indexes[this.minIndex] + TOKENS[this.minIndex][0].length();
        } else if (MATCHERS[this.minIndex] != null) {
            tmp = MATCHERS[this.minIndex].group();
            this.index = MATCHERS[this.minIndex].end();
        } else {
            tmp = this.queryString.substring(this.index);
            this.index = this.array.length;
        }
        this.minIndex = -2;
        return tmp;
    }

    public String remaining() {
        if (this.index < this.array.length) {
            return this.queryString.substring(this.index);
        }
        return null;
    }

    public int nextType() {
        this.resetIndexes();
        return this.minIndex;
    }
}

