/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.commons.utils.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.orioai.commons.utils.xml.NamespaceContextImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLExplorer {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected XPathFactory xPathFactory;
    protected Map<String, String> namespaces;
    protected XPath environnement;

    public void init() {
        this.xPathFactory = XPathFactory.newInstance();
        this.environnement = this.xPathFactory.newXPath();
        this.environnement.setNamespaceContext(new NamespaceContextImpl(this.namespaces));
    }

    public NodeList getNodesFromTagNameNS(String inputXML, String localName, String namespaceURI) {
        NodeList result = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputStream inputStream = this.getInputStreamFromString(inputXML);
            Document doc = builder.parse(inputStream);
            result = doc.getElementsByTagName(localName);
        }
        catch (Exception e) {
            this.logger.error((Object)("can't get nodes from input xml : " + inputXML + " for tag " + localName), (Throwable)e);
        }
        return result;
    }

    public NodeList getNodesFromXPath(String inputXML, String xpath) {
        NodeList result = null;
        InputStream inputStream = this.getInputStreamFromString(inputXML);
        InputSource source = new InputSource(inputStream);
        try {
            XPath environnement = this.xPathFactory.newXPath();
            environnement.setNamespaceContext(new NamespaceContextImpl(this.namespaces));
            XPathExpression expression = environnement.compile(xpath);
            result = (NodeList)expression.evaluate(source, XPathConstants.NODESET);
        }
        catch (Exception e) {
            this.logger.debug((Object)("can't evaluate XPATH expression :" + xpath + " for string :" + inputXML), (Throwable)e);
        }
        if (result.getLength() > 0) {
            this.logger.debug((Object)("found " + result.getLength() + " nodes !"));
        }
        return result;
    }

    public NodeList getNodesFromXPath(Element element, String xpath) {
        NodeList result = null;
        try {
            XPath environnement = this.xPathFactory.newXPath();
            environnement.setNamespaceContext(new NamespaceContextImpl(this.namespaces));
            XPathExpression expression = environnement.compile(xpath);
            result = (NodeList)expression.evaluate(element, XPathConstants.NODESET);
        }
        catch (Exception e) {
            this.logger.debug((Object)("can't evaluate XPATH expression :" + xpath + " for element :" + element), (Throwable)e);
        }
        if (result.getLength() > 0) {
            this.logger.debug((Object)("found " + result.getLength() + " nodes !"));
        }
        return result;
    }

    public Node getNodeFromXPath(String inputXML, String xpath) {
        Node result = null;
        InputStream inputStream = this.getInputStreamFromString(inputXML);
        InputSource source = new InputSource(inputStream);
        try {
            XPath environnement = this.xPathFactory.newXPath();
            environnement.setNamespaceContext(new NamespaceContextImpl(this.namespaces));
            XPathExpression expression = environnement.compile(xpath);
            result = (Node)expression.evaluate(source, XPathConstants.NODE);
        }
        catch (Exception e) {
            this.logger.debug((Object)("can't evaluate XPATH expression :" + xpath + " for string :" + inputXML), (Throwable)e);
        }
        return result;
    }

    public Node getNodeFromXPath(Element element, String xpath) {
        Node result = null;
        try {
            XPath environnement = this.xPathFactory.newXPath();
            environnement.setNamespaceContext(new NamespaceContextImpl(this.namespaces));
            XPathExpression expression = environnement.compile(xpath);
            result = (Node)expression.evaluate(element, XPathConstants.NODE);
        }
        catch (Exception e) {
            this.logger.debug((Object)("can't evaluate XPATH expression :" + xpath + " for element :" + element), (Throwable)e);
        }
        return result;
    }

    public List<String> getValuesFromTagNameNS(String inputXML, String localName, String namespaceURI) {
        List<String> result = null;
        try {
            NodeList nodeList = this.getNodesFromTagNameNS(inputXML, localName, namespaceURI);
            if (nodeList != null) {
                result = this.fillStringListFromNodeList(nodeList);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("can't parse string : " + inputXML + " for tag " + localName), (Throwable)e);
        }
        return result;
    }

    public List<String> getValuesFromXPath(String inputXML, String xpath) {
        List<String> result = null;
        try {
            NodeList nodeList = this.getNodesFromXPath(inputXML, xpath);
            result = this.fillStringListFromNodeList(nodeList);
        }
        catch (Exception e) {
            this.logger.debug((Object)("can't evaluate XPATH expression :" + xpath + " for string :" + inputXML));
        }
        return result;
    }

    public List<String> getValuesFromXPath(Element element, String xpath) {
        List<String> result = null;
        try {
            NodeList nodeList = this.getNodesFromXPath(element, xpath);
            result = this.fillStringListFromNodeList(nodeList);
        }
        catch (Exception e) {
            this.logger.debug((Object)("can't evaluate XPATH expression :" + xpath + " for string :" + element));
        }
        return result;
    }

    protected InputStream getInputStreamFromString(String inputXML) {
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(inputXML.getBytes("UTF-8"));
        }
        catch (Exception e) {
            this.logger.error((Object)("can't get inputstream for string :" + inputXML), (Throwable)e);
        }
        return inputStream;
    }

    protected List<String> fillStringListFromNodeList(NodeList nodeList) {
        ArrayList<String> result = new ArrayList<String>();
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Node node = nodeList.item(index);
            String value = null;
            try {
                value = node.getTextContent();
                if (value == null) continue;
                result.add(value);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public static InputStream stringToInputStream(String vocabularyString) {
        ByteArrayInputStream result = null;
        try {
            result = new ByteArrayInputStream(vocabularyString.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            result = new ByteArrayInputStream(vocabularyString.getBytes());
        }
        return result;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }
}

