/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.commons.vocabulary.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.orioai.commons.vcard.IVcardService;
import org.orioai.commons.vocabulary.Term;
import org.orioai.commons.vocabulary.service.CreateVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CreateStaticVocabulary
extends CreateVocabulary {
    private static Logger log = LoggerFactory.getLogger(CreateStaticVocabulary.class);
    private String oriOaiVocabularyServiceUrl;

    public CreateStaticVocabulary(String vocabularyId, List<String> allLocales, String defaultLanguage, Term lastKnownTermVocabulary, Cache xmlVocabularyCache, Cache xmlVocabularyLastKnownCache, Cache termVocabularyCache, Cache termVocabularyLastKnownCache, String oriOaiVocabularyServiceUrl, HashMap<String, List<String>> vocabulariesVcardAttributes, IVcardService vcardService) {
        super(vocabularyId, allLocales, defaultLanguage, lastKnownTermVocabulary, xmlVocabularyCache, xmlVocabularyLastKnownCache, termVocabularyCache, termVocabularyLastKnownCache, vocabulariesVcardAttributes, vcardService);
        this.oriOaiVocabularyServiceUrl = oriOaiVocabularyServiceUrl;
        if (!oriOaiVocabularyServiceUrl.endsWith("/")) {
            this.oriOaiVocabularyServiceUrl = this.oriOaiVocabularyServiceUrl + "/";
        }
    }

    private String fileToString(File f) throws IOException {
        String s = "";
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(f), "utf-8");
        BufferedReader br = new BufferedReader(isr);
        String line = br.readLine();
        while (line != null) {
            s = s + line + "\n";
            line = br.readLine();
        }
        br.close();
        return s;
    }

    @Override
    protected Object[] getXmlVocabulary(String vocabularyId) {
        Object[] result = new Object[2];
        String xmlVocabulary = null;
        Element xmlVocabularyCacheElt = this.xmlVocabularyCache.get((Serializable)((Object)vocabularyId));
        if (xmlVocabularyCacheElt == null) {
            log.info("getXmlVocabulary :: get the remote xml and put it into the cache :: " + vocabularyId);
            xmlVocabulary = "";
            try {
                xmlVocabulary = this.fileToString(new File(this.oriOaiVocabularyServiceUrl + vocabularyId + ".xml"));
            }
            catch (IOException e) {
                log.error("getXmlVocabulary :: get the xml from the disk :: {}", (Object)vocabularyId, (Object)e);
            }
            this.xmlVocabularyCache.put(new Element((Serializable)((Object)vocabularyId), (Serializable)((Object)xmlVocabulary)));
        } else {
            xmlVocabulary = (String)xmlVocabularyCacheElt.getObjectValue();
            log.debug("getXmlVocabulary :: get the xml from the cache :: {}", (Object)vocabularyId);
        }
        result[0] = xmlVocabulary;
        result[1] = true;
        return result;
    }
}

