/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.commons.vocabulary.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.orioai.commons.vcard.IVcardService;
import org.orioai.commons.vocabulary.Term;
import org.orioai.commons.vocabulary.TermValue;
import org.orioai.commons.vocabulary.service.VocabularyServiceImpl;
import org.orioai.commons.vocabulary.service.exceptions.NotFoundVocabularyException;
import org.orioai.commons.vocabulary.service.exceptions.VocabularyException;
import org.orioai.commons.vocabulary.service.remote.RemoteVocabularyTerm;
import org.orioai.commons.vocabulary.service.remote.VdexVocabularyParser;
import org.orioai.ws.vocabulary.IVocabularyService;
import org.orioai.ws.vocabulary.RestCxfVocabularyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CreateVocabulary
extends Thread {
    private static Logger log = LoggerFactory.getLogger(CreateVocabulary.class);
    private String vocabularyId;
    private Term lastKnownTermVocabulary;
    protected Cache xmlVocabularyCache;
    protected Cache xmlVocabularyLastKnownCache;
    private Cache termVocabularyCache;
    private IVocabularyService oriOaiVocabularyService;
    private Cache termVocabularyLastKnownCache;
    private HashMap<String, List<String>> vocabulariesVcardAttributes;
    private IVcardService vcardService;
    private static List<String> beingCreating = new ArrayList<String>();
    private List<String> allLocales;
    private String defaultLanguage;
    protected int resultState = -1;
    protected static final int RESULT_STATE_NOT_FINISHED = -1;
    protected static final int RESULT_STATE_RESULT_OK = 1;
    protected static final int RESULT_STATE_RESULT_UNAVAILABLE = 0;
    protected static final int RESULT_STATE_NO_RESULT = 2;

    public CreateVocabulary(String vocabularyId, List<String> allLocales, String defaultLanguage, Term lastKnownTermVocabulary, Cache xmlVocabularyCache, Cache xmlVocabularyLastKnownCache, Cache termVocabularyCache, Cache termVocabularyLastKnownCache, HashMap<String, List<String>> vocabulariesVcardAttributes, IVcardService vcardService) {
        this.vocabularyId = vocabularyId;
        this.allLocales = allLocales;
        this.defaultLanguage = defaultLanguage;
        this.lastKnownTermVocabulary = lastKnownTermVocabulary;
        this.termVocabularyCache = termVocabularyCache;
        this.xmlVocabularyCache = xmlVocabularyCache;
        this.xmlVocabularyLastKnownCache = xmlVocabularyLastKnownCache;
        this.termVocabularyLastKnownCache = termVocabularyLastKnownCache;
        this.vocabulariesVcardAttributes = vocabulariesVcardAttributes;
        this.vcardService = vcardService;
    }

    public CreateVocabulary(String vocabularyId, List<String> allLocales, String defaultLanguage, Term lastKnownTermVocabulary, Cache xmlVocabularyCache, Cache xmlVocabularyLastKnownCache, Cache termVocabularyCache, Cache termVocabularyLastKnownCache, String oriOaiVocabularyServiceUrl, HashMap<String, List<String>> vocabulariesVcardAttributes, IVcardService vcardService) {
        this(vocabularyId, allLocales, defaultLanguage, lastKnownTermVocabulary, xmlVocabularyCache, xmlVocabularyLastKnownCache, termVocabularyCache, termVocabularyLastKnownCache, vocabulariesVcardAttributes, vcardService);
        this.oriOaiVocabularyService = new RestCxfVocabularyService(oriOaiVocabularyServiceUrl);
    }

    protected Object[] getXmlVocabulary(String vocabularyId) {
        Element xmlVocabularyCacheElt;
        Object[] result = new Object[2];
        String xmlVocabulary = null;
        String xmlVocabularyLastKnown = null;
        boolean xmlVocabularyChangedSinceLastTime = true;
        Element xmlVocabularyLastKnownCacheElt = this.xmlVocabularyLastKnownCache.get((Serializable)((Object)vocabularyId));
        if (xmlVocabularyLastKnownCacheElt != null) {
            xmlVocabularyLastKnown = (String)xmlVocabularyLastKnownCacheElt.getObjectValue();
        }
        if ((xmlVocabularyCacheElt = this.xmlVocabularyCache.get((Serializable)((Object)vocabularyId))) == null) {
            log.info("run :: get the remote xml and put it into the cache :: " + vocabularyId);
            try {
                xmlVocabulary = this.oriOaiVocabularyService.getVocabulary(vocabularyId);
                this.xmlVocabularyCache.put(new Element((Serializable)((Object)vocabularyId), (Serializable)((Object)xmlVocabulary)));
                log.info("run :: remote xml has been put it into the cache :: " + vocabularyId);
                this.xmlVocabularyLastKnownCache.put(new Element((Serializable)((Object)vocabularyId), (Serializable)((Object)xmlVocabulary)));
            }
            catch (NotFoundVocabularyException e) {
                log.error("run :: error when getting XML vocabulary from ori-oai-vocabulary :: {}", (Object)vocabularyId, (Object)e);
            }
            if (xmlVocabularyLastKnown != null && xmlVocabularyLastKnown.equals(xmlVocabulary)) {
                xmlVocabularyChangedSinceLastTime = false;
            }
        } else {
            xmlVocabularyChangedSinceLastTime = false;
            xmlVocabulary = (String)xmlVocabularyCacheElt.getObjectValue();
            log.debug("run :: get the xml from the cache :: {}", (Object)vocabularyId);
        }
        result[0] = xmlVocabulary;
        result[1] = xmlVocabularyChangedSinceLastTime;
        return result;
    }

    @Override
    public void run() {
        String key = this.vocabularyId;
        if (!beingCreating.contains(this.vocabularyId)) {
            beingCreating.add(key);
            log.debug("run :: create the term and put it into the cache :: {}", (Object)this.vocabularyId);
            String xmlVocabulary = null;
            boolean xmlVocabularyChangedSinceLastTime = true;
            try {
                Object[] getXmlVocabularyResult = this.getXmlVocabulary(this.vocabularyId);
                if (getXmlVocabularyResult != null) {
                    xmlVocabulary = (String)getXmlVocabularyResult[0];
                    xmlVocabularyChangedSinceLastTime = (Boolean)getXmlVocabularyResult[1];
                }
                if (xmlVocabulary != null) {
                    Term vtc = null;
                    if (xmlVocabularyChangedSinceLastTime || this.lastKnownTermVocabulary == null) {
                        log.info("run :: XML vocabulary changed since last time, we generate Term vocabulary :: " + this.vocabularyId);
                        VdexVocabularyParser oovP = new VdexVocabularyParser(this.vocabularyId, xmlVocabulary);
                        RemoteVocabularyTerm rootTerm = oovP.getTerm();
                        vtc = VocabularyServiceImpl.getTermFromVocabulary(rootTerm, this.allLocales, this.defaultLanguage);
                        List<String> vcardAttributes = this.vocabulariesVcardAttributes.get(this.vocabularyId);
                        List<TermValue> allHierarchyValues = vtc.getAllHierarchyValues();
                        ArrayList<String> allValues = new ArrayList<String>(allHierarchyValues.size());
                        for (int i = 0; allHierarchyValues != null && vcardAttributes != null && vcardAttributes.size() > 0 && i < allHierarchyValues.size(); ++i) {
                            TermValue value = allHierarchyValues.get(i);
                            allValues.add(value.getValue());
                        }
                        List<List<List<String>>> vcardAttributeValues = this.vcardService.extractAttributeValue(allValues, vcardAttributes);
                        for (int i = 0; i < vcardAttributeValues.size(); ++i) {
                            List<List<String>> elementVcardAttributeValues = vcardAttributeValues.get(i);
                            TermValue value = allHierarchyValues.get(i);
                            for (int j = 0; j < vcardAttributes.size(); ++j) {
                                List<String> values = elementVcardAttributeValues.get(j);
                                value.setVcardAttributeValues(vcardAttributes.get(j), values);
                            }
                        }
                    } else {
                        log.info("run :: XML vocabulary did not changed since last time, we get Term vocabulary from last element cache :: " + this.vocabularyId);
                        if (this.lastKnownTermVocabulary != null) {
                            vtc = this.lastKnownTermVocabulary;
                        }
                    }
                    this.termVocabularyCache.put(new Element((Serializable)((Object)key), (Serializable)vtc));
                    log.info("run :: term vocabulary has been put it into the cache :: " + this.vocabularyId);
                    this.termVocabularyLastKnownCache.put(new Element((Serializable)((Object)key), (Serializable)vtc));
                    this.resultState = 1;
                } else {
                    log.warn("run :: Unable find vocabulary with vocabularyId=" + this.vocabularyId);
                    this.resultState = 0;
                }
            }
            catch (VocabularyException e) {
                log.debug("run :: VocabularyException", (Throwable)e);
                xmlVocabulary = null;
                this.resultState = 2;
            }
            beingCreating.remove(key);
        } else {
            this.resultState = 2;
        }
    }
}

