/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.commons.vocabulary.service;

import java.io.Serializable;
import java.util.List;
import net.sf.ehcache.Element;
import org.orioai.commons.vocabulary.Term;
import org.orioai.commons.vocabulary.service.CreateStaticVocabulary;
import org.orioai.commons.vocabulary.service.VocabularyServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticLocalVocabularyServiceImpl
extends VocabularyServiceImpl {
    private static Logger log = LoggerFactory.getLogger(StaticLocalVocabularyServiceImpl.class);
    private String oriOaiVocabularyServicePath;

    public void setOriOaiVocabularyServicePath(String oriOaiVocabularyServicePath) {
        try {
            this.oriOaiVocabularyServicePath = this.getClass().getResource(oriOaiVocabularyServicePath).getFile();
        }
        catch (Exception e) {
            log.error("getRootVocabularyTerm :: Error when getting the directory : " + oriOaiVocabularyServicePath, (Throwable)e);
        }
    }

    @Override
    protected Term getRootVocabularyTerm(String vocabularyId, boolean waitResponse, List<String> availableLanguages, String defaultLanguage) {
        Term vtc = null;
        Element termVocabularyCacheElt = this.termVocabularyCache.get((Serializable)((Object)vocabularyId));
        if (termVocabularyCacheElt == null) {
            log.debug("getRootVocabularyTerm :: the term into the cache is null, we are going to get the last known :: {} (waitResponse={})", (Object)vocabularyId, (Object)waitResponse);
            Element termVocabularyLastKnownCacheElt = null;
            try {
                termVocabularyLastKnownCacheElt = this.termVocabularyLastKnownCache.get((Serializable)((Object)vocabularyId));
                if (termVocabularyLastKnownCacheElt != null) {
                    vtc = (Term)termVocabularyLastKnownCacheElt.getObjectValue();
                }
            }
            catch (IllegalStateException e) {
                log.warn("getRootVocabularyTerm :: vocabularyId=" + vocabularyId + " :: IllegalStateException", (Throwable)e);
            }
            if (vtc == null) {
                log.debug("getRootVocabularyTerm :: {} :: last known getted is null", (Object)vocabularyId);
            } else {
                log.debug("getRootVocabularyTerm :: {} :: last known getted is NOT null", (Object)vocabularyId);
            }
            CreateStaticVocabulary cv = new CreateStaticVocabulary(vocabularyId, availableLanguages, defaultLanguage, vtc, this.xmlVocabularyCache, this.xmlVocabularyLastKnownCache, this.termVocabularyCache, this.termVocabularyLastKnownCache, this.oriOaiVocabularyServicePath, this.vocabulariesVcardAttributes, this.vcardService);
            cv.start();
            if (waitResponse && vtc == null) {
                try {
                    cv.join(60000L);
                }
                catch (InterruptedException e) {
                    log.error("getRootVocabularyTerm :: InterruptedException", (Throwable)e);
                }
                termVocabularyCacheElt = this.termVocabularyCache.get((Serializable)((Object)vocabularyId));
                if (termVocabularyCacheElt != null) {
                    vtc = (Term)termVocabularyCacheElt.getObjectValue();
                }
            }
        } else {
            vtc = (Term)termVocabularyCacheElt.getObjectValue();
            log.debug("getRootVocabularyTerm :: get the term into the cache :: {}", (Object)vocabularyId);
        }
        return vtc;
    }
}

