/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.commons.vocabulary.service.remote;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Locale;
import org.apache.commons.digester.Digester;
import org.orioai.commons.vocabulary.service.exceptions.VocabularyException;
import org.orioai.commons.vocabulary.service.remote.RemoteVocabularyTerm;
import org.orioai.commons.vocabulary.service.remote.RemoteVocabularyTermCaption;
import org.orioai.commons.vocabulary.service.remote.RemoteVocabularyTermLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class VdexVocabularyParser {
    private static Logger log = LoggerFactory.getLogger(VdexVocabularyParser.class);
    private RemoteVocabularyTerm term;

    public VdexVocabularyParser(String vocabularyId, String xmlContent) throws VocabularyException {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.push((Object)this);
        digester.addObjectCreate("vdex:vdex", RemoteVocabularyTerm.class);
        digester.addBeanPropertySetter("vdex:vdex/vdex:vocabIdentifier", "classificationId");
        digester.addBeanPropertySetter("vdex:vdex/vdex:metadata/orioai:value", "value");
        digester.addSetNext("vdex:vdex", "setTerm");
        digester.addObjectCreate("vdex:vdex/vdex:vocabName", RemoteVocabularyTermCaption.class);
        digester.addSetNext("vdex:vdex/vdex:vocabName", "setCaption");
        digester.addObjectCreate("vdex:vdex/vdex:vocabName/vdex:langstring", RemoteVocabularyTermLabel.class);
        digester.addBeanPropertySetter("vdex:vdex/vdex:vocabName/vdex:langstring", "value");
        digester.addSetProperties("vdex:vdex/vdex:vocabName/vdex:langstring", "language", "lang");
        digester.addSetNext("vdex:vdex/vdex:vocabName/vdex:langstring", "addLabel");
        digester.addObjectCreate("*/vdex:term", RemoteVocabularyTerm.class);
        digester.addSetProperties("*/vdex:term", "validIndex", "validIndex");
        digester.addBeanPropertySetter("*/vdex:term/vdex:termIdentifier", "classificationId");
        digester.addBeanPropertySetter("*/vdex:term/vdex:termIdentifier", "valueFromIdentifier");
        digester.addBeanPropertySetter("*/vdex:term/vdex:metadata/orioai:value", "value");
        digester.addSetNext("*/vdex:term", "setTerm");
        digester.addObjectCreate("*/vdex:term/vdex:caption", RemoteVocabularyTermCaption.class);
        digester.addSetNext("*/vdex:term/vdex:caption", "setCaption");
        digester.addObjectCreate("*/vdex:term/vdex:caption/vdex:langstring", RemoteVocabularyTermLabel.class);
        digester.addBeanPropertySetter("*/vdex:term/vdex:caption/vdex:langstring", "value");
        digester.addSetProperties("*/vdex:term/vdex:caption/vdex:langstring", "language", "lang");
        digester.addSetNext("*/vdex:term/vdex:caption/vdex:langstring", "addLabel");
        digester.addObjectCreate("*/vdex:term/vdex:description", RemoteVocabularyTermCaption.class);
        digester.addSetNext("*/vdex:term/vdex:description", "setDescription");
        digester.addObjectCreate("*/vdex:term/vdex:description/vdex:langstring", RemoteVocabularyTermLabel.class);
        digester.addBeanPropertySetter("*/vdex:term/vdex:description/vdex:langstring", "value");
        digester.addSetProperties("*/vdex:term/vdex:description/vdex:langstring", "language", "lang");
        digester.addSetNext("*/vdex:term/vdex:description/vdex:langstring", "addLabel");
        InputSource inSource = new InputSource(new StringReader(xmlContent));
        try {
            digester.parse(inSource);
        }
        catch (IOException e) {
            log.error("VocabularyTermsParser :: Unable to parse file [vocabularyId=" + vocabularyId + "] " + xmlContent + " " + e.toString(), (Throwable)e);
            throw new VocabularyException();
        }
        catch (SAXException e) {
            log.error("VocabularyTermsParser :: Unable to parse file [vocabularyId=" + vocabularyId + "] " + xmlContent + " " + e.toString(), (Throwable)e);
            throw new VocabularyException();
        }
    }

    public RemoteVocabularyTerm getTerm() {
        return this.term;
    }

    public void setTerm(RemoteVocabularyTerm term) {
        this.term = term;
    }

    public void show() {
        RemoteVocabularyTerm rootTerm = this.term;
        Locale locale = Locale.FRENCH;
        String language = locale.getLanguage();
        System.out.println("\n\n\n\n\nid=" + rootTerm.getId());
        System.out.println("label=" + rootTerm.getLabel(language, language));
        System.out.println("values=" + rootTerm.getValues());
        System.out.println("size=" + rootTerm.getChildrenSize());
        List<RemoteVocabularyTerm> children = rootTerm.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            RemoteVocabularyTerm child = children.get(i);
            System.out.println("\n\tid=" + child.getId());
            System.out.println("\tlabel=" + child.getLabel(language, language));
            System.out.println("\tdescription=" + child.getDescription(language, language));
            System.out.println("\tvalues=" + child.getValues());
            System.out.println("\tsize=" + child.getChildrenSize());
            List<RemoteVocabularyTerm> children2 = child.getChildren();
            for (int j = 0; j < children2.size(); ++j) {
                RemoteVocabularyTerm child2 = children2.get(j);
                System.out.println("\n\t\tid=" + child2.getId());
                System.out.println("\t\tlabel=" + child2.getLabel(language, language));
                System.out.println("\t\tdescription=" + child2.getDescription(language, language));
                System.out.println("\t\tvalues=" + child2.getValues());
                System.out.println("\t\tsize=" + child2.getChildrenSize());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String fileName = "D:\\Travail\\Developpement\\ori-oai-vocabulary (trunk)\\conf\\properties\\ori_vocabularies\\override\\search_static_repositories.xml";
        BufferedReader fichier = new BufferedReader(new FileReader(fileName));
        String xml = "";
        String str = null;
        while ((str = fichier.readLine()) != null) {
            xml = xml + str + "\n";
        }
        VdexVocabularyParser parser = new VdexVocabularyParser("id", xml);
        parser.show();
    }
}

