/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.ws.indexing.exceptions;

import org.slf4j.Logger;

public class IndexingException
extends Exception {
    private static final long serialVersionUID = 1L;
    private Exception exception;
    private String message;
    private Logger log;

    public IndexingException(Exception e, Logger log, String message) {
        this(e, log, message, true);
    }

    public IndexingException(Exception e, Logger log, String message, boolean logIt) {
        super(e);
        this.exception = e;
        this.message = message;
        this.log = log;
        if (logIt) {
            this.logErrorMessage();
        }
    }

    public IndexingException(Exception e, Logger log) {
        this(e, log, true);
    }

    public IndexingException(Exception e, Logger log, boolean logIt) {
        super(e);
        this.exception = e;
        this.log = log;
        if (logIt) {
            this.logErrorMessage();
        }
    }

    public IndexingException(String message, Logger log) {
        this(message, log, true);
    }

    public IndexingException(String message, Logger log, boolean logIt) {
        this(new Exception(message), log, logIt);
    }

    public final void logErrorMessage() {
        if (this.message != null) {
            if (!this.message.equalsIgnoreCase(this.exception.getMessage())) {
                this.log.error(this.message + " : {}", (Object)this.exception.getMessage(), (Object)this.exception);
            } else {
                this.log.error(this.exception.getMessage(), (Throwable)this.exception);
            }
        } else {
            this.log.error(this.exception.getMessage(), (Throwable)this.exception);
        }
    }
}

