/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key.passwd.swing;

import de.schlichtherle.key.passwd.swing.BasicInvalidKeyFeedback;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class HurlingWindowFeedback
extends BasicInvalidKeyFeedback {
    private static final double PI = Math.PI;
    private static final double TWO_PI = Math.PI * 2;
    public static final int DISTANCE = 25;
    public static final int CYCLE = 150;
    public static final int DURATION = 1500;
    public static final int FPS = 75;
    private final double distance;
    private final double cycle;
    private final int duration;
    private final int fps;

    public HurlingWindowFeedback() {
        this(25, 150, 1500, 75);
    }

    protected HurlingWindowFeedback(int distance, int cycle, int duration, int fps) {
        this.distance = distance;
        this.cycle = cycle;
        this.duration = duration;
        this.fps = fps;
        if (duration > this.getDelay()) {
            this.setDelay(duration);
        }
    }

    protected void startAnimation() {
        super.startAnimation();
        final Window window = SwingUtilities.getWindowAncestor(this.getPanel());
        if (window == null) {
            return;
        }
        final Point origin = window.getLocation();
        final long startTime = System.currentTimeMillis();
        Timer timer = new Timer(1000 / this.fps, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                long elapsed = System.currentTimeMillis() - startTime;
                if (elapsed < (long)HurlingWindowFeedback.this.duration && window.isShowing()) {
                    double amplitude = Math.sin(Math.PI * (double)elapsed / (double)HurlingWindowFeedback.this.duration) * HurlingWindowFeedback.this.distance;
                    double angle = Math.PI * 2 * (double)elapsed / HurlingWindowFeedback.this.cycle;
                    int quakingX = (int)(Math.cos(angle) * amplitude + (double)origin.x);
                    int quakingY = (int)(Math.sin(angle) * amplitude + (double)origin.y);
                    window.setLocation(quakingX, quakingY);
                    window.repaint();
                } else {
                    ((Timer)e.getSource()).stop();
                    window.setLocation(origin);
                    window.repaint();
                }
            }
        });
        timer.start();
    }
}

