/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.util;

import de.schlichtherle.util.JointEnumeration;
import java.io.IOException;
import java.util.Enumeration;

public class ClassLoaders {
    ClassLoaders() {
    }

    public static Class loadClass(String classToLoad, Class loadingClass) throws ClassNotFoundException {
        ClassLoader l1 = loadingClass.getClassLoader();
        if (l1 == null) {
            l1 = ClassLoader.getSystemClassLoader();
        }
        try {
            return l1.loadClass(classToLoad);
        }
        catch (ClassNotFoundException cnfe) {
            ClassLoader l2 = Thread.currentThread().getContextClassLoader();
            if (l2 == null) {
                l2 = ClassLoader.getSystemClassLoader();
            }
            if (l1 == l2) {
                throw cnfe;
            }
            return l2.loadClass(classToLoad);
        }
    }

    public static Enumeration getResources(String name, Class loadingClass) throws IOException {
        ClassLoader l2;
        ClassLoader l1 = loadingClass.getClassLoader();
        if (l1 == null) {
            l1 = ClassLoader.getSystemClassLoader();
        }
        if ((l2 = Thread.currentThread().getContextClassLoader()) == null) {
            l2 = ClassLoader.getSystemClassLoader();
        }
        return l1 == l2 ? l1.getResources(name) : new JointEnumeration(l1.getResources(name), l2.getResources(name));
    }
}

