/*
 * Decompiled with CFR 0.152.
 */
package fj;

import fj.F;
import fj.F2;
import fj.Function;
import fj.Ord;
import fj.P1;
import fj.Semigroup;
import fj.data.Array;
import fj.data.List;
import fj.data.Natural;
import fj.data.Option;
import fj.data.Set;
import fj.data.Stream;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Monoid<A> {
    private final F<A, F<A, A>> sum;
    private final A zero;
    public static final Monoid<Integer> intAdditionMonoid = Monoid.monoid(Semigroup.intAdditionSemigroup, Integer.valueOf(0));
    public static final Monoid<Integer> intMultiplicationMonoid = Monoid.monoid(Semigroup.intMultiplicationSemigroup, Integer.valueOf(1));
    public static final Monoid<BigInteger> bigintAdditionMonoid = Monoid.monoid(Semigroup.bigintAdditionSemigroup, BigInteger.ZERO);
    public static final Monoid<BigInteger> bigintMultiplicationMonoid = Monoid.monoid(Semigroup.bigintMultiplicationSemigroup, BigInteger.ONE);
    public static final Monoid<BigDecimal> bigdecimalAdditionMonoid = Monoid.monoid(Semigroup.bigdecimalAdditionSemigroup, BigDecimal.ZERO);
    public static final Monoid<BigDecimal> bigdecimalMultiplicationMonoid = Monoid.monoid(Semigroup.bigdecimalMultiplicationSemigroup, BigDecimal.ONE);
    public static final Monoid<Natural> naturalAdditionMonoid = Monoid.monoid(Semigroup.naturalAdditionSemigroup, Natural.ZERO);
    public static final Monoid<Natural> naturalMultiplicationMonoid = Monoid.monoid(Semigroup.naturalMultiplicationSemigroup, Natural.ONE);
    public static final Monoid<Long> longAdditionMonoid = Monoid.monoid(Semigroup.longAdditionSemigroup, Long.valueOf(0L));
    public static final Monoid<Long> longMultiplicationMonoid = Monoid.monoid(Semigroup.longMultiplicationSemigroup, Long.valueOf(1L));
    public static final Monoid<Boolean> disjunctionMonoid = Monoid.monoid(Semigroup.disjunctionSemigroup, Boolean.valueOf(false));
    public static final Monoid<Boolean> exclusiveDisjunctionMonoid = Monoid.monoid(Semigroup.exclusiveDisjunctionSemiGroup, Boolean.valueOf(false));
    public static final Monoid<Boolean> conjunctionMonoid = Monoid.monoid(Semigroup.conjunctionSemigroup, Boolean.valueOf(true));
    public static final Monoid<String> stringMonoid = Monoid.monoid(Semigroup.stringSemigroup, "");
    public static final Monoid<StringBuffer> stringBufferMonoid = Monoid.monoid(Semigroup.stringBufferSemigroup, new StringBuffer());
    public static final Monoid<StringBuilder> stringBuilderMonoid = Monoid.monoid(Semigroup.stringBuilderSemigroup, new StringBuilder());

    private Monoid(F<A, F<A, A>> f, A a) {
        this.sum = f;
        this.zero = a;
    }

    public Semigroup<A> semigroup() {
        return Semigroup.semigroup(this.sum);
    }

    public A sum(A a, A a2) {
        return this.sum.f(a).f(a2);
    }

    public F<A, A> sum(A a) {
        return this.sum.f(a);
    }

    public F<A, F<A, A>> sum() {
        return this.sum;
    }

    public A zero() {
        return this.zero;
    }

    public A sumRight(List<A> list) {
        return list.foldRight(this.sum, this.zero);
    }

    public A sumRight(Stream<A> stream) {
        return stream.foldRight(new F2<A, P1<A>, A>(){

            @Override
            public A f(A a, P1<A> p1) {
                return Monoid.this.sum(a, p1._1());
            }
        }, this.zero);
    }

    public A sumLeft(List<A> list) {
        return list.foldLeft(this.sum, this.zero);
    }

    public A sumLeft(Stream<A> stream) {
        return stream.foldLeft(this.sum, this.zero);
    }

    public F<List<A>, A> sumLeft() {
        return new F<List<A>, A>(){

            @Override
            public A f(List<A> list) {
                return Monoid.this.sumLeft(list);
            }
        };
    }

    public F<List<A>, A> sumRight() {
        return new F<List<A>, A>(){

            @Override
            public A f(List<A> list) {
                return Monoid.this.sumRight(list);
            }
        };
    }

    public F<Stream<A>, A> sumLeftS() {
        return new F<Stream<A>, A>(){

            @Override
            public A f(Stream<A> stream) {
                return Monoid.this.sumLeft(stream);
            }
        };
    }

    public A join(Iterable<A> iterable, A a) {
        Stream<A> stream = Stream.iterableStream(iterable);
        return stream.isEmpty() ? this.zero : stream.foldLeft1(Function.compose(this.sum, Function.flip(this.sum).f(a)));
    }

    public static <A> Monoid<A> monoid(F<A, F<A, A>> f, A a) {
        return new Monoid<A>(f, a);
    }

    public static <A> Monoid<A> monoid(F2<A, A, A> f2, A a) {
        return new Monoid<A>(Function.curry(f2), a);
    }

    public static <A> Monoid<A> monoid(Semigroup<A> semigroup, A a) {
        return new Monoid<A>(semigroup.sum(), a);
    }

    public static <A, B> Monoid<F<A, B>> functionMonoid(Monoid<B> monoid) {
        return Monoid.monoid(Semigroup.functionSemigroup(monoid.semigroup()), Function.constant(monoid.zero));
    }

    public static <A> Monoid<List<A>> listMonoid() {
        return Monoid.monoid(Semigroup.listSemigroup(), List.nil());
    }

    public static <A> Monoid<Option<A>> optionMonoid() {
        return Monoid.monoid(Semigroup.optionSemigroup(), Option.none());
    }

    public static <A> Monoid<Option<A>> firstOptionMonoid() {
        return Monoid.monoid(Semigroup.firstOptionSemigroup(), Option.none());
    }

    public static <A> Monoid<Option<A>> lastOptionMonoid() {
        return Monoid.monoid(Semigroup.lastOptionSemigroup(), Option.none());
    }

    public static <A> Monoid<Stream<A>> streamMonoid() {
        return Monoid.monoid(Semigroup.streamSemigroup(), Stream.nil());
    }

    public static <A> Monoid<Array<A>> arrayMonoid() {
        return Monoid.monoid(Semigroup.arraySemigroup(), Array.empty());
    }

    public static <A> Monoid<Set<A>> setMonoid(Ord<A> ord) {
        return Monoid.monoid(Semigroup.setSemigroup(), Set.empty(ord));
    }
}

