/*
 * Decompiled with CFR 0.152.
 */
package fj;

import fj.Class;
import fj.F;
import fj.Function;
import fj.P;
import fj.P1;
import fj.P2;
import fj.P3;
import fj.P4;
import fj.P5;
import fj.P6;
import fj.P7;
import fj.P8;
import fj.Unit;
import fj.data.Array;
import fj.data.Either;
import fj.data.LazyString;
import fj.data.List;
import fj.data.Natural;
import fj.data.NonEmptyList;
import fj.data.Option;
import fj.data.Stream;
import fj.data.Tree;
import fj.data.Validation;
import fj.data.hlist.HList;
import fj.data.vector.V2;
import fj.data.vector.V3;
import fj.data.vector.V4;
import fj.data.vector.V5;
import fj.data.vector.V6;
import fj.data.vector.V7;
import fj.data.vector.V8;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Show<A> {
    private final F<A, Stream<Character>> f;
    public static final Show<Boolean> booleanShow = Show.anyShow();
    public static final Show<Byte> byteShow = Show.anyShow();
    public static final Show<Character> charShow = Show.anyShow();
    public static final Show<Double> doubleShow = Show.anyShow();
    public static final Show<Float> floatShow = Show.anyShow();
    public static final Show<Integer> intShow = Show.anyShow();
    public static final Show<BigInteger> bigintShow = Show.anyShow();
    public static final Show<BigDecimal> bigdecimalShow = Show.anyShow();
    public static final Show<Long> longShow = Show.anyShow();
    public static final Show<Short> shortShow = Show.anyShow();
    public static final Show<String> stringShow = Show.anyShow();
    public static final Show<StringBuffer> stringBufferShow = Show.anyShow();
    public static final Show<StringBuilder> stringBuilderShow = Show.anyShow();
    public static final Show<Natural> naturalShow = bigintShow.comap(new F<Natural, BigInteger>(){

        @Override
        public BigInteger f(Natural natural) {
            return natural.bigIntegerValue();
        }
    });
    public static final Show<LazyString> lazyStringShow = Show.show(new F<LazyString, Stream<Character>>(){

        @Override
        public Stream<Character> f(LazyString lazyString) {
            return lazyString.toStream();
        }
    });
    public static final Show<HList.HNil> HListShow = Show.showS(Function.constant("Nil"));

    private Show(F<A, Stream<Character>> f) {
        this.f = f;
    }

    public <B> Show<B> comap(F<B, A> f) {
        return Show.show(Function.compose(this.f, f));
    }

    public Stream<Character> show(A a) {
        return this.f.f(a);
    }

    public List<Character> showl(A a) {
        return this.show(a).toList();
    }

    public String showS(A a) {
        return Stream.asString(this.show(a));
    }

    public F<A, String> showS_() {
        return new F<A, String>(){

            @Override
            public String f(A a) {
                return Show.this.showS(a);
            }
        };
    }

    public F<A, Stream<Character>> show_() {
        return this.f;
    }

    public Unit println(A a) {
        this.print(a);
        System.out.println();
        return Unit.unit();
    }

    public Unit print(A a) {
        char[] cArray = new char[8192];
        int n = 0;
        Stream<Character> stream = this.show(a);
        while (stream.isNotEmpty()) {
            cArray[n] = stream.head().charValue();
            if (++n == 8192) {
                System.out.print(cArray);
                n = 0;
            }
            stream = stream.tail()._1();
        }
        System.out.print(Array.copyOfRange(cArray, 0, n));
        return Unit.unit();
    }

    public void printlnE(A a) {
        System.err.println(this.showS(a));
    }

    public static <A> Show<A> show(F<A, Stream<Character>> f) {
        return new Show<A>(f);
    }

    public static <A> Show<A> showS(final F<A, String> f) {
        return new Show<A>(new F<A, Stream<Character>>(){

            @Override
            public Stream<Character> f(A a) {
                return Stream.fromString((String)f.f(a));
            }
        });
    }

    public static <A> Show<A> anyShow() {
        return new Show<A>(new F<A, Stream<Character>>(){

            @Override
            public Stream<Character> f(A a) {
                return Stream.fromString(a.toString());
            }
        });
    }

    public static <A> Show<Option<A>> optionShow(final Show<A> show) {
        return new Show<Option<A>>(new F<Option<A>, Stream<Character>>(){

            @Override
            public Stream<Character> f(Option<A> option) {
                return option.isNone() ? Stream.fromString("None") : Stream.fromString("Some(").append((Stream)show.f.f(option.some())).append(Stream.single(Character.valueOf(')')));
            }
        });
    }

    public static <A, B> Show<Either<A, B>> eitherShow(final Show<A> show, final Show<B> show2) {
        return new Show<Either<A, B>>(new F<Either<A, B>, Stream<Character>>(){

            @Override
            public Stream<Character> f(Either<A, B> either) {
                return either.isLeft() ? Stream.fromString("Left(").append((Stream)show.f.f(either.left().value())).append(Stream.single(Character.valueOf(')'))) : Stream.fromString("Right(").append((Stream)show2.f.f(either.right().value())).append(Stream.single(Character.valueOf(')')));
            }
        });
    }

    public static <A, B> Show<Validation<A, B>> validationShow(final Show<A> show, final Show<B> show2) {
        return new Show<Validation<A, B>>(new F<Validation<A, B>, Stream<Character>>(){

            @Override
            public Stream<Character> f(Validation<A, B> validation) {
                return validation.isFail() ? Stream.fromString("Fail(").append((Stream)show.f.f(validation.fail())).append(Stream.single(Character.valueOf(')'))) : Stream.fromString("Success(").append((Stream)show2.f.f(validation.success())).append(Stream.single(Character.valueOf(')')));
            }
        });
    }

    public static <A> Show<List<A>> listShow(final Show<A> show) {
        return new Show<List<A>>(new F<List<A>, Stream<Character>>(){

            @Override
            public Stream<Character> f(List<A> list) {
                return Show.streamShow(show).show(list.toStream());
            }
        });
    }

    public static <A> Show<NonEmptyList<A>> nonEmptyListShow(Show<A> show) {
        return Show.listShow(show).comap(NonEmptyList.toList_());
    }

    public static <A> Show<Tree<A>> treeShow(final Show<A> show) {
        return new Show<Tree<A>>(new F<Tree<A>, Stream<Character>>(){

            @Override
            public Stream<Character> f(Tree<A> tree) {
                Stream<Character> stream = ((Stream)show.f.f(tree.root())).append((Stream)Show.p1Show(Show.streamShow(Show.treeShow(show))).f.f(tree.subForest())).snoc(Character.valueOf(')'));
                return Stream.cons(Character.valueOf('('), P.p(stream));
            }
        });
    }

    public static <A> Show<Stream<A>> streamShow(final Show<A> show) {
        return new Show<Stream<A>>(new F<Stream<A>, Stream<Character>>(){

            @Override
            public Stream<Character> f(Stream<A> stream) {
                return Stream.join(stream.map(show.show_()).intersperse(Stream.fromString(",")).cons(Stream.fromString("<")).snoc(P.p(Stream.fromString(">"))));
            }
        });
    }

    public static <A> Show<Array<A>> arrayShow(final Show<A> show) {
        return new Show<Array<A>>(new F<Array<A>, Stream<Character>>(){

            @Override
            public Stream<Character> f(Array<A> array) {
                Stream<Object> stream = Stream.nil();
                for (int i = 0; i < array.length(); ++i) {
                    stream = stream.append((Stream)show.f.f(array.get(i)));
                    if (i == array.length() - 1) continue;
                    stream = stream.snoc(Character.valueOf(','));
                }
                stream = stream.snoc(Character.valueOf('}'));
                return Stream.cons(Character.valueOf('{'), P.p(stream));
            }
        });
    }

    public static <A> Show<Class<A>> classShow() {
        return new Show<Class<A>>(new F<Class<A>, Stream<Character>>(){

            @Override
            public Stream<Character> f(Class<A> clazz) {
                return Show.anyShow().show(clazz.clas());
            }
        });
    }

    public static <A> Show<P1<A>> p1Show(final Show<A> show) {
        return new Show<P1<A>>(new F<P1<A>, Stream<Character>>(){

            @Override
            public Stream<Character> f(P1<A> p1) {
                return Stream.cons(Character.valueOf('('), P.p(show.show(p1._1()))).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A, B> Show<P2<A, B>> p2Show(final Show<A> show, final Show<B> show2) {
        return new Show<P2<A, B>>(new F<P2<A, B>, Stream<Character>>(){

            @Override
            public Stream<Character> f(P2<A, B> p2) {
                return Stream.cons(Character.valueOf('('), P.p(show.show(p2._1()))).snoc(Character.valueOf(',')).append(show2.show(p2._2())).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A, B, C> Show<P3<A, B, C>> p3Show(final Show<A> show, final Show<B> show2, final Show<C> show3) {
        return new Show<P3<A, B, C>>(new F<P3<A, B, C>, Stream<Character>>(){

            @Override
            public Stream<Character> f(P3<A, B, C> p3) {
                return Stream.cons(Character.valueOf('('), P.p(show.show(p3._1()))).snoc(Character.valueOf(',')).append(show2.show(p3._2())).snoc(Character.valueOf(',')).append(show3.show(p3._3())).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A, B, C, D> Show<P4<A, B, C, D>> p4Show(final Show<A> show, final Show<B> show2, final Show<C> show3, final Show<D> show4) {
        return new Show<P4<A, B, C, D>>(new F<P4<A, B, C, D>, Stream<Character>>(){

            @Override
            public Stream<Character> f(P4<A, B, C, D> p4) {
                return Stream.cons(Character.valueOf('('), P.p(show.show(p4._1()))).snoc(Character.valueOf(',')).append(show2.show(p4._2())).snoc(Character.valueOf(',')).append(show3.show(p4._3())).snoc(Character.valueOf(',')).append(show4.show(p4._4())).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A, B, C, D, E> Show<P5<A, B, C, D, E>> p5Show(final Show<A> show, final Show<B> show2, final Show<C> show3, final Show<D> show4, final Show<E> show5) {
        return new Show<P5<A, B, C, D, E>>(new F<P5<A, B, C, D, E>, Stream<Character>>(){

            @Override
            public Stream<Character> f(P5<A, B, C, D, E> p5) {
                return Stream.cons(Character.valueOf('('), P.p(show.show(p5._1()))).snoc(Character.valueOf(',')).append(show2.show(p5._2())).snoc(Character.valueOf(',')).append(show3.show(p5._3())).snoc(Character.valueOf(',')).append(show4.show(p5._4())).snoc(Character.valueOf(',')).append(show5.show(p5._5())).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A, B, C, D, E, F$> Show<P6<A, B, C, D, E, F$>> p6Show(final Show<A> show, final Show<B> show2, final Show<C> show3, final Show<D> show4, final Show<E> show5, final Show<F$> show6) {
        return new Show<P6<A, B, C, D, E, F$>>(new F<P6<A, B, C, D, E, F$>, Stream<Character>>(){

            @Override
            public Stream<Character> f(P6<A, B, C, D, E, F$> p6) {
                return Stream.cons(Character.valueOf('('), P.p(show.show(p6._1()))).snoc(Character.valueOf(',')).append(show2.show(p6._2())).snoc(Character.valueOf(',')).append(show3.show(p6._3())).snoc(Character.valueOf(',')).append(show4.show(p6._4())).snoc(Character.valueOf(',')).append(show5.show(p6._5())).snoc(Character.valueOf(',')).append(show6.show(p6._6())).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A, B, C, D, E, F$, G> Show<P7<A, B, C, D, E, F$, G>> p7Show(final Show<A> show, final Show<B> show2, final Show<C> show3, final Show<D> show4, final Show<E> show5, final Show<F$> show6, final Show<G> show7) {
        return new Show<P7<A, B, C, D, E, F$, G>>(new F<P7<A, B, C, D, E, F$, G>, Stream<Character>>(){

            @Override
            public Stream<Character> f(P7<A, B, C, D, E, F$, G> p7) {
                return Stream.cons(Character.valueOf('('), P.p(show.show(p7._1()))).snoc(Character.valueOf(',')).append(show2.show(p7._2())).snoc(Character.valueOf(',')).append(show3.show(p7._3())).snoc(Character.valueOf(',')).append(show4.show(p7._4())).snoc(Character.valueOf(',')).append(show5.show(p7._5())).snoc(Character.valueOf(',')).append(show6.show(p7._6())).snoc(Character.valueOf(',')).append(show7.show(p7._7())).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A, B, C, D, E, F$, G, H> Show<P8<A, B, C, D, E, F$, G, H>> p8Show(final Show<A> show, final Show<B> show2, final Show<C> show3, final Show<D> show4, final Show<E> show5, final Show<F$> show6, final Show<G> show7, final Show<H> show8) {
        return new Show<P8<A, B, C, D, E, F$, G, H>>(new F<P8<A, B, C, D, E, F$, G, H>, Stream<Character>>(){

            @Override
            public Stream<Character> f(P8<A, B, C, D, E, F$, G, H> p8) {
                return Stream.cons(Character.valueOf('('), P.p(show.show(p8._1()))).snoc(Character.valueOf(',')).append(show2.show(p8._2())).snoc(Character.valueOf(',')).append(show3.show(p8._3())).snoc(Character.valueOf(',')).append(show4.show(p8._4())).snoc(Character.valueOf(',')).append(show5.show(p8._5())).snoc(Character.valueOf(',')).append(show6.show(p8._6())).snoc(Character.valueOf(',')).append(show7.show(p8._7())).snoc(Character.valueOf(',')).append(show8.show(p8._8())).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A> Show<V2<A>> v2Show(Show<A> show) {
        return Show.streamShow(show).comap(V2.toStream_());
    }

    public static <A> Show<V3<A>> v3Show(Show<A> show) {
        return Show.streamShow(show).comap(V3.toStream_());
    }

    public static <A> Show<V4<A>> v4Show(Show<A> show) {
        return Show.streamShow(show).comap(V4.toStream_());
    }

    public static <A> Show<V5<A>> v5Show(Show<A> show) {
        return Show.streamShow(show).comap(V5.toStream_());
    }

    public static <A> Show<V6<A>> v6Show(Show<A> show) {
        return Show.streamShow(show).comap(V6.toStream_());
    }

    public static <A> Show<V7<A>> v7Show(Show<A> show) {
        return Show.streamShow(show).comap(V7.toStream_());
    }

    public static <A> Show<V8<A>> v8Show(Show<A> show) {
        return Show.streamShow(show).comap(V8.toStream_());
    }

    public static <A> Show<Stream<A>> unlineShow(final Show<A> show) {
        return new Show<Stream<A>>(new F<Stream<A>, Stream<Character>>(){

            @Override
            public Stream<Character> f(Stream<A> stream) {
                return Stream.join(stream.map(show.show_()).intersperse(Stream.fromString("\n")));
            }
        });
    }

    public static <E, L extends HList<L>> Show<HList.HCons<E, L>> HListShow(final Show<E> show, final Show<L> show2) {
        return Show.show(new F<HList.HCons<E, L>, Stream<Character>>(){

            @Override
            public Stream<Character> f(HList.HCons<E, L> hCons) {
                return show.show(hCons.head()).cons(Character.valueOf('[')).append(show2.show(hCons.tail())).snoc(Character.valueOf(']'));
            }
        });
    }
}

