/*
 * Decompiled with CFR 0.152.
 */
package fj.control.parallel;

import fj.F;
import fj.F2;
import fj.Function;
import fj.P1;
import fj.data.Either;
import fj.data.List;
import fj.data.Option;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Callables {
    private Callables() {
    }

    public static <A> Callable<A> callable(final A a) {
        return new Callable<A>(){

            @Override
            public A call() throws Exception {
                return a;
            }
        };
    }

    public static <A> Callable<A> callable(final Exception exception) {
        return new Callable<A>(){

            @Override
            public A call() throws Exception {
                throw exception;
            }
        };
    }

    public static <A> F<A, Callable<A>> callable() {
        return new F<A, Callable<A>>(){

            @Override
            public Callable<A> f(A a) {
                return Callables.callable(a);
            }
        };
    }

    public static <A, B> F<A, Callable<B>> callable(final F<A, B> f) {
        return new F<A, Callable<B>>(){

            @Override
            public Callable<B> f(final A a) {
                return new Callable<B>(){

                    @Override
                    public B call() {
                        return f.f(a);
                    }
                };
            }
        };
    }

    public static <A, B> F<F<A, B>, F<A, Callable<B>>> arrow() {
        return new F<F<A, B>, F<A, Callable<B>>>(){

            @Override
            public F<A, Callable<B>> f(F<A, B> f) {
                return Callables.callable(f);
            }
        };
    }

    public static <A, B> Callable<B> bind(final Callable<A> callable, final F<A, Callable<B>> f) {
        return new Callable<B>(){

            @Override
            public B call() throws Exception {
                return ((Callable)f.f(callable.call())).call();
            }
        };
    }

    public static <A, B> F<Callable<A>, Callable<B>> fmap(final F<A, B> f) {
        return new F<Callable<A>, Callable<B>>(){

            @Override
            public Callable<B> f(Callable<A> callable) {
                return Callables.bind(callable, Callables.callable(f));
            }
        };
    }

    public static <A, B> Callable<B> apply(final Callable<A> callable, Callable<F<A, B>> callable2) {
        return Callables.bind(callable2, new F<F<A, B>, Callable<B>>(){

            @Override
            public Callable<B> f(F<A, B> f) {
                return Callables.fmap(f).f(callable);
            }
        });
    }

    public static <A, B, C> Callable<C> bind(Callable<A> callable, Callable<B> callable2, F<A, F<B, C>> f) {
        return Callables.apply(callable2, Callables.fmap(f).f(callable));
    }

    public static <A> Callable<A> join(Callable<Callable<A>> callable) {
        return Callables.bind(callable, Function.identity());
    }

    public static <A, B, C> F<Callable<A>, F<Callable<B>, Callable<C>>> liftM2(final F<A, F<B, C>> f) {
        return Function.curry(new F2<Callable<A>, Callable<B>, Callable<C>>(){

            @Override
            public Callable<C> f(Callable<A> callable, Callable<B> callable2) {
                return Callables.bind(callable, callable2, f);
            }
        });
    }

    public static <A> Callable<List<A>> sequence(List<Callable<A>> list) {
        return list.foldRight(Callables.liftM2(List.cons()), Callables.callable(List.nil()));
    }

    public static <A> F<List<Callable<A>>, Callable<List<A>>> sequence_() {
        return new F<List<Callable<A>>, Callable<List<A>>>(){

            @Override
            public Callable<List<A>> f(List<Callable<A>> list) {
                return Callables.sequence(list);
            }
        };
    }

    public static <A> P1<Option<A>> option(final Callable<A> callable) {
        return new P1<Option<A>>(){

            @Override
            public Option<A> _1() {
                try {
                    return Option.some(callable.call());
                }
                catch (Exception exception) {
                    return Option.none();
                }
            }
        };
    }

    public static <A> F<Callable<A>, P1<Option<A>>> option() {
        return new F<Callable<A>, P1<Option<A>>>(){

            @Override
            public P1<Option<A>> f(Callable<A> callable) {
                return Callables.option(callable);
            }
        };
    }

    public static <A> P1<Either<Exception, A>> either(final Callable<A> callable) {
        return new P1<Either<Exception, A>>(){

            @Override
            public Either<Exception, A> _1() {
                try {
                    return Either.right(callable.call());
                }
                catch (Exception exception) {
                    return Either.left(exception);
                }
            }
        };
    }

    public static <A> F<Callable<A>, P1<Either<Exception, A>>> either() {
        return new F<Callable<A>, P1<Either<Exception, A>>>(){

            @Override
            public P1<Either<Exception, A>> f(Callable<A> callable) {
                return Callables.either(callable);
            }
        };
    }

    public static <A> Callable<A> fromEither(final P1<Either<Exception, A>> p1) {
        return new Callable<A>(){

            @Override
            public A call() throws Exception {
                Either either = (Either)p1._1();
                if (either.isLeft()) {
                    throw (Exception)either.left().value();
                }
                return either.right().value();
            }
        };
    }

    public static <A> F<P1<Either<Exception, A>>, Callable<A>> fromEither() {
        return new F<P1<Either<Exception, A>>, Callable<A>>(){

            @Override
            public Callable<A> f(P1<Either<Exception, A>> p1) {
                return Callables.fromEither(p1);
            }
        };
    }

    public static <A> Callable<A> fromOption(final P1<Option<A>> p1) {
        return new Callable<A>(){

            @Override
            public A call() throws Exception {
                Option option = (Option)p1._1();
                if (option.isSome()) {
                    return option.some();
                }
                throw new Exception("No value.");
            }
        };
    }

    public static <A> F<P1<Option<A>>, Callable<A>> fromOption() {
        return new F<P1<Option<A>>, Callable<A>>(){

            @Override
            public Callable<A> f(P1<Option<A>> p1) {
                return Callables.fromOption(p1);
            }
        };
    }

    public static <A> Callable<A> normalise(Callable<A> callable) {
        try {
            return Callables.callable(callable.call());
        }
        catch (Exception exception) {
            return Callables.callable(exception);
        }
    }

    public static <A> F<Callable<A>, Callable<A>> normalise() {
        return new F<Callable<A>, Callable<A>>(){

            @Override
            public Callable<A> f(Callable<A> callable) {
                return Callables.normalise(callable);
            }
        };
    }
}

