/*
 * Decompiled with CFR 0.152.
 */
package fj.control.parallel;

import fj.Effect;
import fj.F;
import fj.F2;
import fj.Function;
import fj.P;
import fj.P1;
import fj.P2;
import fj.Unit;
import fj.control.parallel.Actor;
import fj.control.parallel.Callables;
import fj.control.parallel.QueueActor;
import fj.control.parallel.Strategy;
import fj.data.Either;
import fj.data.List;
import fj.data.Option;
import fj.data.Stream;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Promise<A> {
    private final Actor<P2<Either<P1<A>, Actor<A>>, Promise<A>>> actor;
    private final Strategy<Unit> s;
    private final CountDownLatch l = new CountDownLatch(1);
    private volatile Option<A> v = Option.none();
    private final Queue<Actor<A>> waiting = new LinkedList<Actor<A>>();

    private Promise(Strategy<Unit> strategy, Actor<P2<Either<P1<A>, Actor<A>>, Promise<A>>> actor) {
        this.s = strategy;
        this.actor = actor;
    }

    private static <A> Promise<A> mkPromise(Strategy<Unit> strategy) {
        Actor<P2<Either<P1<A>, Actor<A>>, Promise<A>>> actor = QueueActor.queueActor(strategy, new Effect<P2<Either<P1<A>, Actor<A>>, Promise<A>>>(){

            @Override
            public void e(P2<Either<P1<A>, Actor<A>>, Promise<A>> p2) {
                Promise promise = p2._2();
                Queue queue = promise.waiting;
                if (p2._1().isLeft()) {
                    Object a = p2._1().left().value()._1();
                    promise.v = Option.some(a);
                    promise.l.countDown();
                    while (!queue.isEmpty()) {
                        ((Actor)queue.remove()).act(a);
                    }
                } else if (promise.v.isNone()) {
                    queue.add(p2._1().right().value());
                } else {
                    p2._1().right().value().act(promise.v.some());
                }
            }
        }).asActor();
        return new Promise<A>(strategy, actor);
    }

    public static <A> Promise<A> promise(Strategy<Unit> strategy, P1<A> p1) {
        Promise<A> promise = Promise.mkPromise(strategy);
        promise.actor.act(P.p(Either.left(p1), promise));
        return promise;
    }

    public static <A> F<P1<A>, Promise<A>> promise(final Strategy<Unit> strategy) {
        return new F<P1<A>, Promise<A>>(){

            @Override
            public Promise<A> f(P1<A> p1) {
                return Promise.promise((Strategy<Unit>)strategy, p1);
            }
        };
    }

    public static <A> Promise<Callable<A>> promise(Strategy<Unit> strategy, final Callable<A> callable) {
        return Promise.promise(strategy, new P1<Callable<A>>(){

            @Override
            public Callable<A> _1() {
                return Callables.normalise(callable);
            }
        });
    }

    public static <A, B> F<A, Promise<B>> promise(final Strategy<Unit> strategy, final F<A, B> f) {
        return new F<A, Promise<B>>(){

            @Override
            public Promise<B> f(A a) {
                return Promise.promise((Strategy<Unit>)strategy, P1.curry(f).f(a));
            }
        };
    }

    public void to(Actor<A> actor) {
        this.actor.act(P.p(Either.right(actor), this));
    }

    public <B> Promise<B> fmap(F<A, B> f) {
        return this.bind(Promise.promise(this.s, f));
    }

    public static <A, B> F<Promise<A>, Promise<B>> fmap_(final F<A, B> f) {
        return new F<Promise<A>, Promise<B>>(){

            @Override
            public Promise<B> f(Promise<A> promise) {
                return promise.fmap(f);
            }
        };
    }

    public static <A> Promise<A> join(Promise<Promise<A>> promise) {
        F f = Function.identity();
        return promise.bind(f);
    }

    public static <A> Promise<A> join(Strategy<Unit> strategy, P1<Promise<A>> p1) {
        return Promise.join(Promise.promise(strategy, p1));
    }

    public <B> Promise<B> bind(F<A, Promise<B>> f) {
        final Promise<A> promise = Promise.mkPromise(this.s);
        Actor actor = Actor.actor(this.s, new Effect<B>(){

            @Override
            public void e(B b) {
                promise.actor.act(P.p(Either.left(P.p(b)), promise));
            }
        });
        this.to(actor.promise().comap(f));
        return promise;
    }

    public <B> Promise<B> apply(Promise<F<A, B>> promise) {
        return promise.bind(new F<F<A, B>, Promise<B>>(){

            @Override
            public Promise<B> f(F<A, B> f) {
                return Promise.this.fmap(f);
            }
        });
    }

    public <B, C> Promise<C> bind(Promise<B> promise, F<A, F<B, C>> f) {
        return promise.apply(this.fmap(f));
    }

    public <B, C> Promise<C> bind(P1<Promise<B>> p1, F<A, F<B, C>> f) {
        return Promise.join(this.s, p1).apply(this.fmap(f));
    }

    public static <A, B, C> F<Promise<A>, F<Promise<B>, Promise<C>>> liftM2(final F<A, F<B, C>> f) {
        return Function.curry(new F2<Promise<A>, Promise<B>, Promise<C>>(){

            @Override
            public Promise<C> f(Promise<A> promise, Promise<B> promise2) {
                return promise.bind(promise2, f);
            }
        });
    }

    public static <A> Promise<List<A>> sequence(Strategy<Unit> strategy, List<Promise<A>> list) {
        return Promise.join(Promise.foldRight(strategy, Promise.liftM2(List.cons()), Promise.promise(strategy, P.p(List.nil()))).f(list));
    }

    public static <A> F<List<Promise<A>>, Promise<List<A>>> sequence(final Strategy<Unit> strategy) {
        return new F<List<Promise<A>>, Promise<List<A>>>(){

            @Override
            public Promise<List<A>> f(List<Promise<A>> list) {
                return Promise.sequence((Strategy<Unit>)strategy, list);
            }
        };
    }

    public static <A> Promise<Stream<A>> sequence(Strategy<Unit> strategy, Stream<Promise<A>> stream) {
        return Promise.join(Promise.foldRightS(strategy, Function.curry(new F2<Promise<A>, P1<Promise<Stream<A>>>, Promise<Stream<A>>>(){

            @Override
            public Promise<Stream<A>> f(Promise<A> promise, final P1<Promise<Stream<A>>> p1) {
                return promise.bind(new F<A, Promise<Stream<A>>>(){

                    @Override
                    public Promise<Stream<A>> f(A a) {
                        return ((Promise)p1._1()).fmap(Stream.cons_().f(a));
                    }
                });
            }
        }), Promise.promise(strategy, P.p(Stream.nil()))).f(stream));
    }

    public static <A> F<List<Promise<A>>, Promise<List<A>>> sequenceS(final Strategy<Unit> strategy) {
        return new F<List<Promise<A>>, Promise<List<A>>>(){

            @Override
            public Promise<List<A>> f(List<Promise<A>> list) {
                return Promise.sequence((Strategy<Unit>)strategy, list);
            }
        };
    }

    public static <A> Promise<P1<A>> sequence(Strategy<Unit> strategy, P1<Promise<A>> p1) {
        return Promise.join(Promise.promise(strategy, p1)).fmap(P.p1());
    }

    public static <A, B> F<List<A>, Promise<B>> foldRight(final Strategy<Unit> strategy, final F<A, F<B, B>> f, final B b) {
        return new F<List<A>, Promise<B>>(){

            @Override
            public Promise<B> f(List<A> list) {
                return list.isEmpty() ? Promise.promise((Strategy<Unit>)strategy, P.p(b)) : Promise.liftM2(f).f(Promise.promise((Strategy<Unit>)strategy, P.p(list.head()))).f(Promise.join(strategy, P1.curry(this).f(list.tail())));
            }
        };
    }

    public static <A, B> F<Stream<A>, Promise<B>> foldRightS(final Strategy<Unit> strategy, final F<A, F<P1<B>, B>> f, final B b) {
        return new F<Stream<A>, Promise<B>>(){

            @Override
            public Promise<B> f(final Stream<A> stream) {
                return stream.isEmpty() ? Promise.promise((Strategy<Unit>)strategy, P.p(b)) : Promise.liftM2(f).f(Promise.promise((Strategy<Unit>)strategy, P.p(stream.head()))).f(Promise.join(strategy, new P1<Promise<P1<B>>>(){

                    @Override
                    public Promise<P1<B>> _1() {
                        return this.f(stream.tail()._1()).fmap(P.p1());
                    }
                }));
            }
        };
    }

    public A claim() {
        try {
            this.l.await();
        }
        catch (InterruptedException interruptedException) {
            throw new Error(interruptedException);
        }
        return this.v.some();
    }

    public Option<A> claim(long l, TimeUnit timeUnit) {
        try {
            if (this.l.await(l, timeUnit)) {
                return this.v;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new Error(interruptedException);
        }
        return Option.none();
    }

    public boolean isFulfilled() {
        return this.v.isSome();
    }

    public <B> Promise<B> cobind(final F<Promise<A>, B> f) {
        return Promise.promise(this.s, new P1<B>(){

            @Override
            public B _1() {
                return f.f(Promise.this);
            }
        });
    }

    public Promise<Promise<A>> cojoin() {
        F f = Function.identity();
        return this.cobind(f);
    }

    public <B> Stream<B> sequenceW(final Stream<F<Promise<A>, B>> stream) {
        return stream.isEmpty() ? Stream.nil() : Stream.cons(stream.head().f(this), new P1<Stream<B>>(){

            @Override
            public Stream<B> _1() {
                return Promise.this.sequenceW(stream.tail()._1());
            }
        });
    }
}

