/*
 * Decompiled with CFR 0.152.
 */
package fj.control.parallel;

import fj.Effect;
import fj.F;
import fj.Function;
import fj.P;
import fj.P1;
import fj.Unit;
import fj.control.parallel.Actor;
import fj.control.parallel.Strategy;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueueActor<A> {
    private final AtomicBoolean suspended = new AtomicBoolean(true);
    private final Queue<A> mbox = new ConcurrentLinkedQueue<A>();
    private final Actor<Unit> act;
    private final Actor<A> selfish;

    private QueueActor(Strategy<Unit> strategy, final Effect<A> effect) {
        this.act = Actor.actor(strategy, new Effect<Unit>(){

            @Override
            public void e(Unit unit) {
                Object e = QueueActor.this.mbox.poll();
                if (e != null) {
                    effect.e(e);
                    QueueActor.this.act.act(unit);
                } else {
                    QueueActor.this.suspended.set(true);
                    QueueActor.this.work();
                }
            }
        });
        this.selfish = Actor.actor(strategy, new Effect<A>(){

            @Override
            public void e(A a) {
                QueueActor.this.act(a);
            }
        });
    }

    private P1<Unit> work() {
        boolean bl = this.mbox.isEmpty();
        return bl ? P.p(Unit.unit()) : (this.suspended.compareAndSet(!bl, false) ? this.act.act(Unit.unit()) : P.p(Unit.unit()));
    }

    public static <A> QueueActor<A> queueActor(Strategy<Unit> strategy, Effect<A> effect) {
        return new QueueActor<A>(strategy, effect);
    }

    public static <A> QueueActor<A> queueActor(Strategy<Unit> strategy, F<A, P1<Unit>> f) {
        return QueueActor.queueActor(strategy, Effect.f(Function.compose(P1.__1(), f)));
    }

    public Actor<A> asActor() {
        return this.selfish;
    }

    public void act(A a) {
        if (this.mbox.offer(a)) {
            this.work();
        } else {
            this.selfish.act(a);
        }
    }
}

