/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Equal;
import fj.F;
import fj.F2;
import fj.F3;
import fj.Function;
import fj.P1;
import fj.P2;
import fj.data.Array;
import fj.data.Option;
import fj.data.Stream;
import fj.data.Zipper;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IterableW<A>
implements Iterable<A> {
    private final Iterable<A> i;

    private IterableW(Iterable<A> iterable) {
        this.i = iterable;
    }

    public static <A> IterableW<A> wrap(Iterable<A> iterable) {
        return new IterableW<A>(iterable);
    }

    public static <A, T extends Iterable<A>> F<T, IterableW<A>> wrap() {
        return new F<T, IterableW<A>>(){

            @Override
            public IterableW<A> f(T t) {
                return IterableW.wrap(t);
            }
        };
    }

    public static <A> IterableW<A> iterable(A a) {
        return IterableW.wrap(Option.some(a));
    }

    public static <A, B> F<A, IterableW<B>> iterable(final F<A, B> f) {
        return new F<A, IterableW<B>>(){

            @Override
            public IterableW<B> f(A a) {
                return IterableW.iterable(f.f(a));
            }
        };
    }

    public static <A, B> F<F<A, B>, F<A, IterableW<B>>> arrow() {
        return new F<F<A, B>, F<A, IterableW<B>>>(){

            @Override
            public F<A, IterableW<B>> f(F<A, B> f) {
                return IterableW.iterable(f);
            }
        };
    }

    public <B, T extends Iterable<B>> IterableW<B> bind(final F<A, T> f) {
        return IterableW.wrap(Stream.iterableStream(this).bind(new F<A, Stream<B>>(){

            @Override
            public Stream<B> f(A a) {
                return Stream.iterableStream((Iterable)f.f(a));
            }
        }));
    }

    public <B> IterableW<B> apply(Iterable<F<A, B>> iterable) {
        return IterableW.wrap(iterable).bind(new F<F<A, B>, Iterable<B>>(){

            @Override
            public Iterable<B> f(F<A, B> f) {
                return IterableW.this.map(f);
            }
        });
    }

    public static <A, B, C> IterableW<C> bind(Iterable<A> iterable, Iterable<B> iterable2, F<A, F<B, C>> f) {
        return IterableW.wrap(iterable2).apply(IterableW.wrap(iterable).map(f));
    }

    public static <A, B, C> F<Iterable<A>, F<Iterable<B>, IterableW<C>>> liftM2(final F<A, F<B, C>> f) {
        return Function.curry(new F2<Iterable<A>, Iterable<B>, IterableW<C>>(){

            @Override
            public IterableW<C> f(Iterable<A> iterable, Iterable<B> iterable2) {
                return IterableW.bind(iterable, iterable2, f);
            }
        });
    }

    public static <A, T extends Iterable<A>> IterableW<IterableW<A>> sequence(Iterable<T> iterable) {
        final Stream<T> stream = Stream.iterableStream(iterable);
        return stream.isEmpty() ? IterableW.iterable(IterableW.wrap(Option.none())) : IterableW.wrap((Iterable)stream.head()).bind(new F<A, Iterable<IterableW<A>>>(){

            @Override
            public Iterable<IterableW<A>> f(final A a) {
                return IterableW.sequence(stream.tail().map(IterableW.wrap())._1()).bind(new F<IterableW<A>, Iterable<IterableW<A>>>(){

                    @Override
                    public Iterable<IterableW<A>> f(final IterableW<A> iterableW) {
                        return IterableW.iterable(IterableW.wrap(Stream.cons(a, new P1<Stream<A>>(){

                            @Override
                            public Stream<A> _1() {
                                return Stream.iterableStream(iterableW);
                            }
                        })));
                    }
                });
            }
        });
    }

    public static <A, B, T extends Iterable<B>> F<IterableW<A>, F<F<A, T>, IterableW<B>>> bind() {
        return new F<IterableW<A>, F<F<A, T>, IterableW<B>>>(){

            @Override
            public F<F<A, T>, IterableW<B>> f(final IterableW<A> iterableW) {
                return new F<F<A, T>, IterableW<B>>(){

                    @Override
                    public IterableW<B> f(F<A, T> f) {
                        return iterableW.bind(f);
                    }
                };
            }
        };
    }

    public static <A, T extends Iterable<A>> IterableW<A> join(Iterable<T> iterable) {
        F f = Function.identity();
        return IterableW.wrap(iterable).bind(f);
    }

    public static <A, T extends Iterable<A>> F<Iterable<T>, IterableW<A>> join() {
        return new F<Iterable<T>, IterableW<A>>(){

            @Override
            public IterableW<A> f(Iterable<T> iterable) {
                return IterableW.join(iterable);
            }
        };
    }

    public <B> IterableW<B> map(F<A, B> f) {
        return this.bind(IterableW.iterable(f));
    }

    public static <A, B> F<F<A, B>, F<IterableW<A>, IterableW<B>>> map() {
        return new F<F<A, B>, F<IterableW<A>, IterableW<B>>>(){

            @Override
            public F<IterableW<A>, IterableW<B>> f(final F<A, B> f) {
                return new F<IterableW<A>, IterableW<B>>(){

                    @Override
                    public IterableW<B> f(IterableW<A> iterableW) {
                        return iterableW.map(f);
                    }
                };
            }
        };
    }

    public <B> B foldLeft(F<B, F<A, B>> f, B b) {
        B b2 = b;
        for (A a : this) {
            b2 = f.f(b2).f(a);
        }
        return b2;
    }

    public A foldLeft1(F2<A, A, A> f2) {
        return this.foldLeft1(Function.curry(f2));
    }

    public A foldLeft1(F<A, F<A, A>> f) {
        return Stream.iterableStream(this).foldLeft1(f);
    }

    public <B> B foldRight(final F2<A, B, B> f2, B b) {
        F f = Function.identity();
        return (B)this.foldLeft(Function.curry(new F3<F<B, B>, A, B, B>(){

            @Override
            public B f(F<B, B> f, A a, B b) {
                return f.f(f2.f(a, b));
            }
        }), f).f(b);
    }

    @Override
    public Iterator<A> iterator() {
        return this.i.iterator();
    }

    public <B> IterableW<B> zapp(Iterable<F<A, B>> iterable) {
        return IterableW.wrap(Stream.iterableStream(this).zapp(Stream.iterableStream(iterable)));
    }

    public <B, C> Iterable<C> zipWith(Iterable<B> iterable, F<A, F<B, C>> f) {
        return IterableW.wrap(Stream.iterableStream(this).zipWith(Stream.iterableStream(iterable), f));
    }

    public <B, C> Iterable<C> zipWith(Iterable<B> iterable, F2<A, B, C> f2) {
        return this.zipWith(iterable, Function.curry(f2));
    }

    public <B> Iterable<P2<A, B>> zip(Iterable<B> iterable) {
        return IterableW.wrap(Stream.iterableStream(this).zip(Stream.iterableStream(iterable)));
    }

    public Iterable<P2<A, Integer>> zipIndex() {
        return IterableW.wrap(Stream.iterableStream(this).zipIndex());
    }

    public List<A> toStandardList() {
        return new List<A>(){

            @Override
            public int size() {
                return Stream.iterableStream(IterableW.this).length();
            }

            @Override
            public boolean isEmpty() {
                return Stream.iterableStream(IterableW.this).isEmpty();
            }

            @Override
            public boolean contains(Object object) {
                return Stream.iterableStream(IterableW.this).exists(Equal.anyEqual().eq(object));
            }

            @Override
            public Iterator<A> iterator() {
                return IterableW.this.iterator();
            }

            @Override
            public Object[] toArray() {
                return Array.iterableArray(Stream.iterableStream(IterableW.this)).array();
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                return Stream.iterableStream(IterableW.this).toCollection().toArray(TArray);
            }

            @Override
            public boolean add(A a) {
                return false;
            }

            @Override
            public boolean remove(Object object) {
                return false;
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                return Stream.iterableStream(IterableW.this).toCollection().containsAll(collection);
            }

            @Override
            public boolean addAll(Collection<? extends A> collection) {
                return false;
            }

            @Override
            public boolean addAll(int n, Collection<? extends A> collection) {
                return false;
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                return false;
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                return false;
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException("Modifying an immutable List.");
            }

            @Override
            public A get(int n) {
                return Stream.iterableStream(IterableW.this).index(n);
            }

            @Override
            public A set(int n, A a) {
                throw new UnsupportedOperationException("Modifying an immutable List.");
            }

            @Override
            public void add(int n, A a) {
                throw new UnsupportedOperationException("Modifying an immutable List.");
            }

            @Override
            public A remove(int n) {
                throw new UnsupportedOperationException("Modifying an immutable List.");
            }

            @Override
            public int indexOf(Object object) {
                int n = -1;
                for (Object a : IterableW.this) {
                    ++n;
                    if (!a.equals(object)) continue;
                    return n;
                }
                return n;
            }

            @Override
            public int lastIndexOf(Object object) {
                int n = -1;
                int n2 = -1;
                for (Object a : IterableW.this) {
                    ++n;
                    if (!a.equals(object)) continue;
                    n2 = n;
                }
                return n2;
            }

            @Override
            public ListIterator<A> listIterator() {
                return this.toListIterator(IterableW.this.toZipper());
            }

            @Override
            public ListIterator<A> listIterator(int n) {
                return this.toListIterator(IterableW.this.toZipper().bind(Zipper.move().f(n)));
            }

            @Override
            public List<A> subList(int n, int n2) {
                return IterableW.wrap(Stream.iterableStream(IterableW.this).drop(n).take(n2 - n)).toStandardList();
            }

            private ListIterator<A> toListIterator(final Option<Zipper<A>> option) {
                return new ListIterator<A>(){
                    private Option<Zipper<A>> pz;
                    {
                        this.pz = option;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.pz.isSome() && !this.pz.some().atEnd();
                    }

                    @Override
                    public A next() {
                        if (!this.pz.isSome()) {
                            throw new NoSuchElementException();
                        }
                        this.pz = this.pz.some().next();
                        if (this.pz.isSome()) {
                            return this.pz.some().focus();
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public boolean hasPrevious() {
                        return this.pz.isSome() && !this.pz.some().atStart();
                    }

                    @Override
                    public A previous() {
                        this.pz = this.pz.some().previous();
                        return this.pz.some().focus();
                    }

                    @Override
                    public int nextIndex() {
                        return this.pz.some().index() + (this.pz.some().atEnd() ? 0 : 1);
                    }

                    @Override
                    public int previousIndex() {
                        return this.pz.some().index() - (this.pz.some().atStart() ? 0 : 1);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Remove on immutable ListIterator");
                    }

                    @Override
                    public void set(A a) {
                        throw new UnsupportedOperationException("Set on immutable ListIterator");
                    }

                    @Override
                    public void add(A a) {
                        throw new UnsupportedOperationException("Add on immutable ListIterator");
                    }
                };
            }
        };
    }

    public Option<Zipper<A>> toZipper() {
        return Zipper.fromStream(Stream.iterableStream(this));
    }
}

