/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.F;
import fj.F2;
import fj.Function;
import fj.Monoid;
import fj.data.List;
import fj.data.Option;
import fj.data.Stream;
import fj.data.vector.V;
import fj.data.vector.V2;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Natural
extends Number {
    private final BigInteger value;
    private static final long serialVersionUID = -588673650944359682L;
    public static final F<BigInteger, Option<Natural>> fromBigInt = new F<BigInteger, Option<Natural>>(){

        @Override
        public Option<Natural> f(BigInteger bigInteger) {
            return Natural.natural(bigInteger);
        }
    };
    public static final Natural ZERO = Natural.natural(0L).some();
    public static final Natural ONE = Natural.natural(1L).some();
    public static final F<Natural, F<Natural, Natural>> add = Function.curry(new F2<Natural, Natural, Natural>(){

        @Override
        public Natural f(Natural natural, Natural natural2) {
            return natural.add(natural2);
        }
    });
    public static final F<Natural, F<Natural, Option<Natural>>> subtract = Function.curry(new F2<Natural, Natural, Option<Natural>>(){

        @Override
        public Option<Natural> f(Natural natural, Natural natural2) {
            return natural2.subtract(natural);
        }
    });
    public static final F<Natural, F<Natural, Natural>> multiply = Function.curry(new F2<Natural, Natural, Natural>(){

        @Override
        public Natural f(Natural natural, Natural natural2) {
            return natural.multiply(natural2);
        }
    });
    public static final F<Natural, F<Natural, Natural>> divide = Function.curry(new F2<Natural, Natural, Natural>(){

        @Override
        public Natural f(Natural natural, Natural natural2) {
            return natural2.divide(natural);
        }
    });
    public static final F<Natural, F<Natural, Natural>> mod = Function.curry(new F2<Natural, Natural, Natural>(){

        @Override
        public Natural f(Natural natural, Natural natural2) {
            return natural2.mod(natural);
        }
    });
    public static final F<Natural, F<Natural, V2<Natural>>> divmod = Function.curry(new F2<Natural, Natural, V2<Natural>>(){

        @Override
        public V2<Natural> f(Natural natural, Natural natural2) {
            return natural2.divmod(natural);
        }
    });
    public static final F<Natural, BigInteger> bigIntegerValue = new F<Natural, BigInteger>(){

        @Override
        public BigInteger f(Natural natural) {
            return natural.bigIntegerValue();
        }
    };

    private Natural(BigInteger bigInteger) {
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw Bottom.error("Natural less than zero");
        }
        this.value = bigInteger;
    }

    public static Option<Natural> natural(BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) < 0 ? Option.none() : Option.some(new Natural(bigInteger));
    }

    public static Option<Natural> natural(long l) {
        return Natural.natural(BigInteger.valueOf(l));
    }

    public Natural succ() {
        return this.add(ONE);
    }

    public static F<Natural, Natural> succ_() {
        return new F<Natural, Natural>(){

            @Override
            public Natural f(Natural natural) {
                return natural.succ();
            }
        };
    }

    public Option<Natural> pred() {
        return this.subtract(ONE);
    }

    public static F<Natural, Option<Natural>> pred_() {
        return new F<Natural, Option<Natural>>(){

            @Override
            public Option<Natural> f(Natural natural) {
                return natural.pred();
            }
        };
    }

    public Natural add(Natural natural) {
        return Natural.natural(natural.value.add(this.value)).some();
    }

    public Option<Natural> subtract(Natural natural) {
        return Natural.natural(natural.value.subtract(this.value));
    }

    public Natural multiply(Natural natural) {
        return Natural.natural(natural.value.multiply(this.value)).some();
    }

    public Natural divide(Natural natural) {
        return Natural.natural(this.value.divide(natural.value)).some();
    }

    public Natural mod(Natural natural) {
        return Natural.natural(this.value.mod(natural.value)).some();
    }

    public V2<Natural> divmod(Natural natural) {
        BigInteger[] bigIntegerArray = this.value.divideAndRemainder(natural.value);
        return V.v(Natural.natural(bigIntegerArray[0]).some(), Natural.natural(bigIntegerArray[1]).some());
    }

    public BigInteger bigIntegerValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    public static Natural sum(Stream<Natural> stream) {
        return Monoid.naturalAdditionMonoid.sumLeft(stream);
    }

    public static Natural product(Stream<Natural> stream) {
        return Monoid.naturalMultiplicationMonoid.sumLeft(stream);
    }

    public static Natural sum(List<Natural> list) {
        return Monoid.naturalAdditionMonoid.sumLeft(list);
    }

    public static Natural product(List<Natural> list) {
        return Monoid.naturalMultiplicationMonoid.sumLeft(list);
    }
}

