/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.Effect;
import fj.F;
import fj.F2;
import fj.Function;
import fj.P;
import fj.P1;
import fj.P2;
import fj.P3;
import fj.P4;
import fj.P5;
import fj.P6;
import fj.P7;
import fj.P8;
import fj.Show;
import fj.Unit;
import fj.data.Array;
import fj.data.Either;
import fj.data.List;
import fj.data.Stream;
import fj.data.Validation;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Option<A>
implements Iterable<A> {
    public static final F<String, Option<Byte>> parseByte = new F<String, Option<Byte>>(){

        @Override
        public Option<Byte> f(String string) {
            return Validation.parseByte(string).toOption();
        }
    };
    public static final F<String, Option<Double>> parseDouble = new F<String, Option<Double>>(){

        @Override
        public Option<Double> f(String string) {
            return Validation.parseDouble(string).toOption();
        }
    };
    public static final F<String, Option<Float>> parseFloat = new F<String, Option<Float>>(){

        @Override
        public Option<Float> f(String string) {
            return Validation.parseFloat(string).toOption();
        }
    };
    public static final F<String, Option<Integer>> parseInt = new F<String, Option<Integer>>(){

        @Override
        public Option<Integer> f(String string) {
            return Validation.parseInt(string).toOption();
        }
    };
    public static final F<String, Option<Long>> parseLong = new F<String, Option<Long>>(){

        @Override
        public Option<Long> f(String string) {
            return Validation.parseLong(string).toOption();
        }
    };
    public static final F<String, Option<Short>> parseShort = new F<String, Option<Short>>(){

        @Override
        public Option<Short> f(String string) {
            return Validation.parseShort(string).toOption();
        }
    };

    private Option() {
    }

    public String toString() {
        Show show = Show.anyShow();
        return Show.optionShow(show).showS(this);
    }

    @Override
    public final Iterator<A> iterator() {
        return this.toCollection().iterator();
    }

    public abstract A some();

    public final boolean isSome() {
        return this instanceof Some;
    }

    public final boolean isNone() {
        return this instanceof None;
    }

    public static <A> F<Option<A>, Boolean> isSome_() {
        return new F<Option<A>, Boolean>(){

            @Override
            public Boolean f(Option<A> option) {
                return option.isSome();
            }
        };
    }

    public static <A> F<Option<A>, Boolean> isNone_() {
        return new F<Option<A>, Boolean>(){

            @Override
            public Boolean f(Option<A> option) {
                return option.isNone();
            }
        };
    }

    public final <B> B option(B b, F<A, B> f) {
        return this.isSome() ? f.f(this.some()) : b;
    }

    public final <B> B option(P1<B> p1, F<A, B> f) {
        return this.isSome() ? f.f(this.some()) : p1._1();
    }

    public final int length() {
        return this.isSome() ? 1 : 0;
    }

    public final A orSome(P1<A> p1) {
        return this.isSome() ? this.some() : p1._1();
    }

    public final A orSome(A a) {
        return this.isSome() ? this.some() : a;
    }

    public final A valueE(P1<String> p1) {
        if (this.isSome()) {
            return this.some();
        }
        throw Bottom.error(p1._1());
    }

    public final A valueE(String string) {
        if (this.isSome()) {
            return this.some();
        }
        throw Bottom.error(string);
    }

    public final <B> Option<B> map(F<A, B> f) {
        return this.isSome() ? Option.some(f.f(this.some())) : Option.none();
    }

    public static <A, B> F<F<A, B>, F<Option<A>, Option<B>>> map() {
        return Function.curry(new F2<F<A, B>, Option<A>, Option<B>>(){

            @Override
            public Option<B> f(F<A, B> f, Option<A> option) {
                return option.map(f);
            }
        });
    }

    public final Unit foreach(F<A, Unit> f) {
        return this.isSome() ? f.f(this.some()) : Unit.unit();
    }

    public final void foreach(Effect<A> effect) {
        if (this.isSome()) {
            effect.e(this.some());
        }
    }

    public final Option<A> filter(F<A, Boolean> f) {
        return this.isSome() ? (f.f(this.some()).booleanValue() ? this : Option.none()) : Option.none();
    }

    public final <B> Option<B> bind(F<A, Option<B>> f) {
        return this.isSome() ? f.f(this.some()) : Option.none();
    }

    public final <B, C> Option<C> bind(Option<B> option, F<A, F<B, C>> f) {
        return option.apply(this.map(f));
    }

    public final <B, C, D> Option<D> bind(Option<B> option, Option<C> option2, F<A, F<B, F<C, D>>> f) {
        return option2.apply(this.bind(option, f));
    }

    public final <B, C, D, E> Option<E> bind(Option<B> option, Option<C> option2, Option<D> option3, F<A, F<B, F<C, F<D, E>>>> f) {
        return option3.apply(this.bind(option, option2, f));
    }

    public final <B, C, D, E, F$> Option<F$> bind(Option<B> option, Option<C> option2, Option<D> option3, Option<E> option4, F<A, F<B, F<C, F<D, F<E, F$>>>>> f) {
        return option4.apply(this.bind(option, option2, option3, f));
    }

    public final <B, C, D, E, F$, G> Option<G> bind(Option<B> option, Option<C> option2, Option<D> option3, Option<E> option4, Option<F$> option5, F<A, F<B, F<C, F<D, F<E, F<F$, G>>>>>> f) {
        return option5.apply(this.bind(option, option2, option3, option4, f));
    }

    public final <B, C, D, E, F$, G, H> Option<H> bind(Option<B> option, Option<C> option2, Option<D> option3, Option<E> option4, Option<F$> option5, Option<G> option6, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, H>>>>>>> f) {
        return option6.apply(this.bind(option, option2, option3, option4, option5, f));
    }

    public final <B, C, D, E, F$, G, H, I> Option<I> bind(Option<B> option, Option<C> option2, Option<D> option3, Option<E> option4, Option<F$> option5, Option<G> option6, Option<H> option7, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, F<H, I>>>>>>>> f) {
        return option7.apply(this.bind(option, option2, option3, option4, option5, option6, f));
    }

    public final <B> Option<P2<A, B>> bindProduct(Option<B> option) {
        return this.bind(option, P.p2());
    }

    public final <B, C> Option<P3<A, B, C>> bindProduct(Option<B> option, Option<C> option2) {
        return this.bind(option, option2, P.p3());
    }

    public final <B, C, D> Option<P4<A, B, C, D>> bindProduct(Option<B> option, Option<C> option2, Option<D> option3) {
        return this.bind(option, option2, option3, P.p4());
    }

    public final <B, C, D, E> Option<P5<A, B, C, D, E>> bindProduct(Option<B> option, Option<C> option2, Option<D> option3, Option<E> option4) {
        return this.bind(option, option2, option3, option4, P.p5());
    }

    public final <B, C, D, E, F$> Option<P6<A, B, C, D, E, F$>> bindProduct(Option<B> option, Option<C> option2, Option<D> option3, Option<E> option4, Option<F$> option5) {
        return this.bind(option, option2, option3, option4, option5, P.p6());
    }

    public final <B, C, D, E, F$, G> Option<P7<A, B, C, D, E, F$, G>> bindProduct(Option<B> option, Option<C> option2, Option<D> option3, Option<E> option4, Option<F$> option5, Option<G> option6) {
        return this.bind(option, option2, option3, option4, option5, option6, P.p7());
    }

    public final <B, C, D, E, F$, G, H> Option<P8<A, B, C, D, E, F$, G, H>> bindProduct(Option<B> option, Option<C> option2, Option<D> option3, Option<E> option4, Option<F$> option5, Option<G> option6, Option<H> option7) {
        return this.bind(option, option2, option3, option4, option5, option6, option7, P.p8());
    }

    public final <B> Option<B> sequence(Option<B> option) {
        F f = Function.constant(option);
        return this.bind(f);
    }

    public final <B> Option<B> apply(Option<F<A, B>> option) {
        return option.bind(new F<F<A, B>, Option<B>>(){

            @Override
            public Option<B> f(final F<A, B> f) {
                return Option.this.map(new F<A, B>(){

                    @Override
                    public B f(A a) {
                        return f.f(a);
                    }
                });
            }
        });
    }

    public final Option<A> orElse(P1<Option<A>> p1) {
        return this.isSome() ? this : p1._1();
    }

    public final Option<A> orElse(Option<A> option) {
        return this.isSome() ? this : option;
    }

    public final <X> Either<X, A> toEither(P1<X> p1) {
        return this.isSome() ? Either.right(this.some()) : Either.left(p1._1());
    }

    public final <X> Either<X, A> toEither(X x) {
        return this.isSome() ? Either.right(this.some()) : Either.left(x);
    }

    public static <A, X> F<Option<A>, F<X, Either<X, A>>> toEither() {
        return Function.curry(new F2<Option<A>, X, Either<X, A>>(){

            @Override
            public Either<X, A> f(Option<A> option, X x) {
                return option.toEither(x);
            }
        });
    }

    public final List<A> toList() {
        return this.isSome() ? List.cons(this.some(), List.nil()) : List.nil();
    }

    public final Stream<A> toStream() {
        return this.isSome() ? Stream.nil().cons(this.some()) : Stream.nil();
    }

    public final Array<A> toArray() {
        return this.isSome() ? Array.array(this.some()) : Array.empty();
    }

    public final Array<A> toArray(Class<A[]> clazz) {
        if (this.isSome()) {
            Object[] objectArray = (Object[])java.lang.reflect.Array.newInstance(clazz.getComponentType(), 1);
            objectArray[0] = this.some();
            return Array.array(objectArray);
        }
        return Array.array((Object[])java.lang.reflect.Array.newInstance(clazz.getComponentType(), 0));
    }

    public final A[] array(Class<A[]> clazz) {
        return this.toArray(clazz).array(clazz);
    }

    public final A toNull() {
        return (A)this.orSome((Object)null);
    }

    public final boolean forall(F<A, Boolean> f) {
        return this.isNone() || f.f(this.some()) != false;
    }

    public final boolean exists(F<A, Boolean> f) {
        return this.isSome() && f.f(this.some()) != false;
    }

    public final Collection<A> toCollection() {
        return this.toList().toCollection();
    }

    public static <T> F<T, Option<T>> some_() {
        return new F<T, Option<T>>(){

            @Override
            public Option<T> f(T t) {
                return Option.some(t);
            }
        };
    }

    public static <T> Option<T> some(T t) {
        return new Some<T>(t);
    }

    public static <T> Option<T> none() {
        return new None();
    }

    public static <T> Option<T> fromNull(T t) {
        return t == null ? Option.none() : Option.some(t);
    }

    public static <T> F<T, Option<T>> fromNull() {
        return new F<T, Option<T>>(){

            @Override
            public Option<T> f(T t) {
                return Option.fromNull(t);
            }
        };
    }

    public static <A> Option<A> join(Option<Option<A>> option) {
        F f = Function.identity();
        return option.bind(f);
    }

    public static <A> Option<List<A>> sequence(final List<Option<A>> list) {
        return list.isEmpty() ? Option.some(List.nil()) : list.head().bind(new F<A, Option<List<A>>>(){

            @Override
            public Option<List<A>> f(A a) {
                return Option.sequence(list.tail()).map(List.cons_(a));
            }
        });
    }

    public static <A> Option<A> iif(F<A, Boolean> f, A a) {
        return f.f(a) != false ? Option.some(a) : Option.none();
    }

    public static <A> Option<A> iif(boolean bl, P1<A> p1) {
        return bl ? Option.some(p1._1()) : Option.none();
    }

    public static <A> Option<A> iif(boolean bl, A a) {
        return Option.iif(bl, P.p(a));
    }

    public static <A> F2<F<A, Boolean>, A, Option<A>> iif() {
        return new F2<F<A, Boolean>, A, Option<A>>(){

            @Override
            public Option<A> f(F<A, Boolean> f, A a) {
                return Option.iif(f, a);
            }
        };
    }

    public static <A> List<A> somes(List<Option<A>> list) {
        return list.filter(Option.<Option<A>>isSome_()).map(new F<Option<A>, A>(){

            @Override
            public A f(Option<A> option) {
                return option.some();
            }
        });
    }

    public static <A> Stream<A> somes(Stream<Option<A>> stream) {
        return stream.filter(Option.<Option<A>>isSome_()).map(new F<Option<A>, A>(){

            @Override
            public A f(Option<A> option) {
                return option.some();
            }
        });
    }

    public static Option<String> fromString(String string) {
        return Option.fromNull(string).bind(new F<String, Option<String>>(){

            @Override
            public Option<String> f(String string) {
                Option option = Option.none();
                return string.length() == 0 ? option : Option.some(string);
            }
        });
    }

    public static F<String, Option<String>> fromString() {
        return new F<String, Option<String>>(){

            @Override
            public Option<String> f(String string) {
                return Option.fromString(string);
            }
        };
    }

    public static <A> F<Option<A>, A> fromSome() {
        return new F<Option<A>, A>(){

            @Override
            public A f(Option<A> option) {
                return option.some();
            }
        };
    }

    public static <A, B, C> F<Option<A>, F<Option<B>, Option<C>>> liftM2(final F<A, F<B, C>> f) {
        return Function.curry(new F2<Option<A>, Option<B>, Option<C>>(){

            @Override
            public Option<C> f(Option<A> option, Option<B> option2) {
                return option.bind(option2, f);
            }
        });
    }

    public static <A, B> F<F<A, Option<B>>, F<Option<A>, Option<B>>> bind() {
        return Function.curry(new F2<F<A, Option<B>>, Option<A>, Option<B>>(){

            @Override
            public Option<B> f(F<A, Option<B>> f, Option<A> option) {
                return option.bind(f);
            }
        });
    }

    public static <A> F<Option<Option<A>>, Option<A>> join() {
        return new F<Option<Option<A>>, Option<A>>(){

            @Override
            public Option<A> f(Option<Option<A>> option) {
                return Option.join(option);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Some<A>
    extends Option<A> {
        private final A a;

        Some(A a) {
            this.a = a;
        }

        @Override
        public A some() {
            return this.a;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class None<A>
    extends Option<A> {
        private None() {
        }

        @Override
        public A some() {
            throw Bottom.error("some on None");
        }
    }
}

