/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.Effect;
import fj.F;
import fj.F2;
import fj.F3;
import fj.F4;
import fj.F5;
import fj.F6;
import fj.F7;
import fj.F8;
import fj.Function;
import fj.P;
import fj.P1;
import fj.Semigroup;
import fj.Unit;
import fj.data.Array;
import fj.data.Either;
import fj.data.List;
import fj.data.NonEmptyList;
import fj.data.Option;
import fj.data.Stream;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Validation<E, T>
implements Iterable<T> {
    private final Either<E, T> e;
    public static final F<String, Validation<NumberFormatException, Byte>> parseByte = new F<String, Validation<NumberFormatException, Byte>>(){

        @Override
        public Validation<NumberFormatException, Byte> f(String string) {
            return Validation.parseByte(string);
        }
    };
    public static final F<String, Validation<NumberFormatException, Double>> parseDouble = new F<String, Validation<NumberFormatException, Double>>(){

        @Override
        public Validation<NumberFormatException, Double> f(String string) {
            return Validation.parseDouble(string);
        }
    };
    public static final F<String, Validation<NumberFormatException, Float>> parseFloat = new F<String, Validation<NumberFormatException, Float>>(){

        @Override
        public Validation<NumberFormatException, Float> f(String string) {
            return Validation.parseFloat(string);
        }
    };
    public static final F<String, Validation<NumberFormatException, Integer>> parseInt = new F<String, Validation<NumberFormatException, Integer>>(){

        @Override
        public Validation<NumberFormatException, Integer> f(String string) {
            return Validation.parseInt(string);
        }
    };
    public static final F<String, Validation<NumberFormatException, Long>> parseLong = new F<String, Validation<NumberFormatException, Long>>(){

        @Override
        public Validation<NumberFormatException, Long> f(String string) {
            return Validation.parseLong(string);
        }
    };
    public static final F<String, Validation<NumberFormatException, Short>> parseShort = new F<String, Validation<NumberFormatException, Short>>(){

        @Override
        public Validation<NumberFormatException, Short> f(String string) {
            return Validation.parseShort(string);
        }
    };

    private Validation(Either<E, T> either) {
        this.e = either;
    }

    public boolean isFail() {
        return this.e.isLeft();
    }

    public boolean isSuccess() {
        return this.e.isRight();
    }

    public E fail() {
        if (this.isFail()) {
            return this.e.left().value();
        }
        throw Bottom.error("Validation: fail on success value");
    }

    public T success() {
        if (this.isSuccess()) {
            return this.e.right().value();
        }
        throw Bottom.error("Validation: success on fail value");
    }

    public <X> X validation(F<E, X> f, F<T, X> f2) {
        return this.e.either(f, f2);
    }

    public FailProjection<E, T> f() {
        return new FailProjection(this);
    }

    public Either<E, T> toEither() {
        return this.e;
    }

    public T successE(P1<String> p1) {
        return this.e.right().valueE(p1);
    }

    public T successE(String string) {
        return this.e.right().valueE(P.p(string));
    }

    public T orSuccess(P1<T> p1) {
        return this.e.right().orValue(p1);
    }

    public T orSuccess(T t) {
        return this.e.right().orValue(P.p(t));
    }

    public T on(F<E, T> f) {
        return this.e.right().on(f);
    }

    public Unit foreach(F<T, Unit> f) {
        return this.e.right().foreach(f);
    }

    public void foreach(Effect<T> effect) {
        this.e.right().foreach(effect);
    }

    public <A> Validation<E, A> map(F<T, A> f) {
        return this.isFail() ? Validation.fail(this.fail()) : Validation.success(f.f(this.success()));
    }

    public <A> Validation<E, A> bind(F<T, Validation<E, A>> f) {
        return this.isSuccess() ? f.f(this.success()) : Validation.fail(this.fail());
    }

    public <A> Validation<E, A> sequence(Validation<E, A> validation) {
        return this.bind(Function.constant(validation));
    }

    public <A> Option<Validation<A, T>> filter(F<T, Boolean> f) {
        return this.e.right().filter(f).map(Validation.<E, T>validation());
    }

    public <A> Validation<E, A> apply(Validation<E, F<T, A>> validation) {
        return validation.bind(new F<F<T, A>, Validation<E, A>>(){

            @Override
            public Validation<E, A> f(F<T, A> f) {
                return Validation.this.map(f);
            }
        });
    }

    public boolean forall(F<T, Boolean> f) {
        return this.e.right().forall(f);
    }

    public boolean exists(F<T, Boolean> f) {
        return this.e.right().exists(f);
    }

    public List<T> toList() {
        return this.e.right().toList();
    }

    public Option<T> toOption() {
        return this.e.right().toOption();
    }

    public Array<T> toArray() {
        return this.e.right().toArray();
    }

    public Stream<T> toStream() {
        return this.e.right().toStream();
    }

    public <A> Validation<E, A> accumapply(Semigroup<E> semigroup, Validation<E, F<T, A>> validation) {
        return this.isFail() ? Validation.fail(validation.isFail() ? semigroup.sum(validation.fail(), this.fail()) : this.fail()) : (validation.isFail() ? Validation.fail(validation.fail()) : Validation.success(validation.success().f(this.success())));
    }

    public <A, B> Validation<E, B> accumulate(Semigroup<E> semigroup, Validation<E, A> validation, F<T, F<A, B>> f) {
        return validation.accumapply(semigroup, this.map(f));
    }

    public <A, B> Validation<E, B> accumulate(Semigroup<E> semigroup, Validation<E, A> validation, F2<T, A, B> f2) {
        return validation.accumapply(semigroup, this.map(Function.curry(f2)));
    }

    public <A> Option<E> accumulate(Semigroup<E> semigroup, Validation<E, A> validation) {
        return this.accumulate(semigroup, validation, new F2<T, A, Unit>(){

            @Override
            public Unit f(T t, A a) {
                return Unit.unit();
            }
        }).f().toOption();
    }

    public <A, B, C> Validation<E, C> accumulate(Semigroup<E> semigroup, Validation<E, A> validation, Validation<E, B> validation2, F<T, F<A, F<B, C>>> f) {
        return validation2.accumapply(semigroup, this.accumulate(semigroup, validation, f));
    }

    public <A, B, C> Validation<E, C> accumulate(Semigroup<E> semigroup, Validation<E, A> validation, Validation<E, B> validation2, F3<T, A, B, C> f3) {
        return validation2.accumapply(semigroup, this.accumulate(semigroup, validation, Function.curry(f3)));
    }

    public <A, B> Option<E> accumulate(Semigroup<E> semigroup, Validation<E, A> validation, Validation<E, B> validation2) {
        return this.accumulate(semigroup, validation, validation2, new F3<T, A, B, Unit>(){

            @Override
            public Unit f(T t, A a, B b) {
                return Unit.unit();
            }
        }).f().toOption();
    }

    public <A, B, C, D> Validation<E, D> accumulate(Semigroup<E> semigroup, Validation<E, A> validation, Validation<E, B> validation2, Validation<E, C> validation3, F<T, F<A, F<B, F<C, D>>>> f) {
        return validation3.accumapply(semigroup, this.accumulate(semigroup, validation, validation2, f));
    }

    public <A, B, C, D> Validation<E, D> accumulate(Semigroup<E> semigroup, Validation<E, A> validation, Validation<E, B> validation2, Validation<E, C> validation3, F4<T, A, B, C, D> f4) {
        return validation3.accumapply(semigroup, this.accumulate(semigroup, validation, validation2, Function.curry(f4)));
    }

    public <A, B, C> Option<E> accumulate(Semigroup<E> semigroup, Validation<E, A> validation, Validation<E, B> validation2, Validation<E, C> validation3) {
        return this.accumulate(semigroup, validation, validation2, validation3, new F4<T, A, B, C, Unit>(){

            @Override
            public Unit f(T t, A a, B b, C c) {
                return Unit.unit();
            }
        }).f().toOption();
    }

    public <A, B, C, D, E$> Validation<E, E$> accumulate(Semigroup<E> semigroup, Validation<E, A> validation, Validation<E, B> validation2, Validation<E, C> validation3, Validation<E, D> validation4, F<T, F<A, F<B, F<C, F<D, E$>>>>> f) {
        return validation4.accumapply(semigroup, this.accumulate(semigroup, validation, validation2, validation3, f));
    }

    public <A, B, C, D, E$> Validation<E, E$> accumulate(Semigroup<E> semigroup, Validation<E, A> validation, Validation<E, B> validation2, Validation<E, C> validation3, Validation<E, D> validation4, F5<T, A, B, C, D, E$> f5) {
        return validation4.accumapply(semigroup, this.accumulate(semigroup, validation, validation2, validation3, Function.curry(f5)));
    }

    public <A, B, C, D> Option<E> accumulate(Semigroup<E> semigroup, Validation<E, A> validation, Validation<E, B> validation2, Validation<E, C> validation3, Validation<E, D> validation4) {
        return this.accumulate(semigroup, validation, validation2, validation3, validation4, new F5<T, A, B, C, D, Unit>(){

            @Override
            public Unit f(T t, A a, B b, C c, D d) {
                return Unit.unit();
            }
        }).f().toOption();
    }

    public <A, B, C, D, E$, F$> Validation<E, F$> accumulate(Semigroup<E> semigroup, Validation<E, A> validation, Validation<E, B> validation2, Validation<E, C> validation3, Validation<E, D> validation4, Validation<E, E$> validation5, F<T, F<A, F<B, F<C, F<D, F<E$, F$>>>>>> f) {
        return validation5.accumapply(semigroup, this.accumulate(semigroup, validation, validation2, validation3, validation4, f));
    }

    public <A, B, C, D, E$, F$> Validation<E, F$> accumulate(Semigroup<E> semigroup, Validation<E, A> validation, Validation<E, B> validation2, Validation<E, C> validation3, Validation<E, D> validation4, Validation<E, E$> validation5, F6<T, A, B, C, D, E$, F$> f6) {
        return validation5.accumapply(semigroup, this.accumulate(semigroup, validation, validation2, validation3, validation4, Function.curry(f6)));
    }

    public <A, B, C, D, E$> Option<E> accumulate(Semigroup<E> semigroup, Validation<E, A> validation, Validation<E, B> validation2, Validation<E, C> validation3, Validation<E, D> validation4, Validation<E, E$> validation5) {
        return this.accumulate(semigroup, validation, validation2, validation3, validation4, validation5, new F6<T, A, B, C, D, E$, Unit>(){

            @Override
            public Unit f(T t, A a, B b, C c, D d, E$ E$) {
                return Unit.unit();
            }
        }).f().toOption();
    }

    public <A, B, C, D, E$, F$, G> Validation<E, G> accumulate(Semigroup<E> semigroup, Validation<E, A> validation, Validation<E, B> validation2, Validation<E, C> validation3, Validation<E, D> validation4, Validation<E, E$> validation5, Validation<E, F$> validation6, F<T, F<A, F<B, F<C, F<D, F<E$, F<F$, G>>>>>>> f) {
        return validation6.accumapply(semigroup, this.accumulate(semigroup, validation, validation2, validation3, validation4, validation5, f));
    }

    public <A, B, C, D, E$, F$, G> Validation<E, G> accumulate(Semigroup<E> semigroup, Validation<E, A> validation, Validation<E, B> validation2, Validation<E, C> validation3, Validation<E, D> validation4, Validation<E, E$> validation5, Validation<E, F$> validation6, F7<T, A, B, C, D, E$, F$, G> f7) {
        return validation6.accumapply(semigroup, this.accumulate(semigroup, validation, validation2, validation3, validation4, validation5, Function.curry(f7)));
    }

    public <A, B, C, D, E$, F$> Option<E> accumulate(Semigroup<E> semigroup, Validation<E, A> validation, Validation<E, B> validation2, Validation<E, C> validation3, Validation<E, D> validation4, Validation<E, E$> validation5, Validation<E, F$> validation6) {
        return this.accumulate(semigroup, validation, validation2, validation3, validation4, validation5, validation6, new F7<T, A, B, C, D, E$, F$, Unit>(){

            @Override
            public Unit f(T t, A a, B b, C c, D d, E$ E$, F$ F$) {
                return Unit.unit();
            }
        }).f().toOption();
    }

    public <A, B, C, D, E$, F$, G, H> Validation<E, H> accumulate(Semigroup<E> semigroup, Validation<E, A> validation, Validation<E, B> validation2, Validation<E, C> validation3, Validation<E, D> validation4, Validation<E, E$> validation5, Validation<E, F$> validation6, Validation<E, G> validation7, F<T, F<A, F<B, F<C, F<D, F<E$, F<F$, F<G, H>>>>>>>> f) {
        return validation7.accumapply(semigroup, this.accumulate(semigroup, validation, validation2, validation3, validation4, validation5, validation6, f));
    }

    public <A, B, C, D, E$, F$, G, H> Validation<E, H> accumulate(Semigroup<E> semigroup, Validation<E, A> validation, Validation<E, B> validation2, Validation<E, C> validation3, Validation<E, D> validation4, Validation<E, E$> validation5, Validation<E, F$> validation6, Validation<E, G> validation7, F8<T, A, B, C, D, E$, F$, G, H> f8) {
        return validation7.accumapply(semigroup, this.accumulate(semigroup, validation, validation2, validation3, validation4, validation5, validation6, Function.curry(f8)));
    }

    public <A, B, C, D, E$, F$, G> Option<E> accumulate(Semigroup<E> semigroup, Validation<E, A> validation, Validation<E, B> validation2, Validation<E, C> validation3, Validation<E, D> validation4, Validation<E, E$> validation5, Validation<E, F$> validation6, Validation<E, G> validation7) {
        return this.accumulate(semigroup, validation, validation2, validation3, validation4, validation5, validation6, validation7, new F8<T, A, B, C, D, E$, F$, G, Unit>(){

            @Override
            public Unit f(T t, A a, B b, C c, D d, E$ E$, F$ F$, G g) {
                return Unit.unit();
            }
        }).f().toOption();
    }

    @Override
    public Iterator<T> iterator() {
        return this.toEither().right().iterator();
    }

    public Validation<NonEmptyList<E>, T> nel() {
        return this.isSuccess() ? Validation.success(this.success()) : Validation.fail(NonEmptyList.nel(this.fail()));
    }

    public static <E, T> Validation<E, T> validation(Either<E, T> either) {
        return new Validation<E, T>(either);
    }

    public static <E, T> F<Either<E, T>, Validation<E, T>> validation() {
        return new F<Either<E, T>, Validation<E, T>>(){

            @Override
            public Validation<E, T> f(Either<E, T> either) {
                return Validation.validation(either);
            }
        };
    }

    public static <E, T> F<Validation<E, T>, Either<E, T>> either() {
        return new F<Validation<E, T>, Either<E, T>>(){

            @Override
            public Either<E, T> f(Validation<E, T> validation) {
                return validation.toEither();
            }
        };
    }

    public static <E, T> Validation<E, T> success(T t) {
        return Validation.validation(Either.right(t));
    }

    public static <E, T> Validation<E, T> fail(E e) {
        return Validation.validation(Either.left(e));
    }

    public static <E, T> Validation<NonEmptyList<E>, T> failNEL(E e) {
        return Validation.fail(NonEmptyList.nel(e));
    }

    public static <E, T> Validation<E, T> condition(boolean bl, E e, T t) {
        return bl ? Validation.success(t) : Validation.fail(e);
    }

    public static Validation<NumberFormatException, Byte> parseByte(String string) {
        try {
            return Validation.success(Byte.parseByte(string));
        }
        catch (NumberFormatException numberFormatException) {
            return Validation.fail(numberFormatException);
        }
    }

    public static Validation<NumberFormatException, Double> parseDouble(String string) {
        try {
            return Validation.success(Double.parseDouble(string));
        }
        catch (NumberFormatException numberFormatException) {
            return Validation.fail(numberFormatException);
        }
    }

    public static Validation<NumberFormatException, Float> parseFloat(String string) {
        try {
            return Validation.success(Float.valueOf(Float.parseFloat(string)));
        }
        catch (NumberFormatException numberFormatException) {
            return Validation.fail(numberFormatException);
        }
    }

    public static Validation<NumberFormatException, Integer> parseInt(String string) {
        try {
            return Validation.success(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            return Validation.fail(numberFormatException);
        }
    }

    public static Validation<NumberFormatException, Long> parseLong(String string) {
        try {
            return Validation.success(Long.parseLong(string));
        }
        catch (NumberFormatException numberFormatException) {
            return Validation.fail(numberFormatException);
        }
    }

    public static Validation<NumberFormatException, Short> parseShort(String string) {
        try {
            return Validation.success(Short.parseShort(string));
        }
        catch (NumberFormatException numberFormatException) {
            return Validation.fail(numberFormatException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class FailProjection<E, T>
    implements Iterable<E> {
        private final Validation<E, T> v;

        private FailProjection(Validation<E, T> validation2) {
            this.v = validation2;
        }

        public Validation<E, T> validation() {
            return this.v;
        }

        public E failE(P1<String> p1) {
            return this.v.toEither().left().valueE(p1);
        }

        public E failE(String string) {
            return this.failE(P.p(string));
        }

        public E orFail(P1<E> p1) {
            return (E)this.v.toEither().left().orValue((E)p1);
        }

        public E orFail(E e) {
            return (E)this.orFail((E)P.p(e));
        }

        public E on(F<T, E> f) {
            return this.v.toEither().left().on(f);
        }

        public Unit foreach(F<E, Unit> f) {
            return this.v.toEither().left().foreach(f);
        }

        public void foreach(Effect<E> effect) {
            this.v.toEither().left().foreach(effect);
        }

        public <A> Validation<A, T> map(F<E, A> f) {
            return Validation.validation(this.v.toEither().left().map(f));
        }

        public <A> Validation<A, T> bind(F<E, Validation<A, T>> f) {
            return this.v.isFail() ? f.f(this.v.fail()) : Validation.success(this.v.success());
        }

        public <A> Validation<A, T> sequence(final Validation<A, T> validation) {
            return this.bind(new F<E, Validation<A, T>>(){

                @Override
                public Validation<A, T> f(E e) {
                    return validation;
                }
            });
        }

        public <A> Option<Validation<E, A>> filter(F<E, Boolean> f) {
            return this.v.toEither().left().filter(f).map(Validation.validation());
        }

        public <A> Validation<A, T> apply(Validation<F<E, A>, T> validation) {
            return validation.f().bind(new F<F<E, A>, Validation<A, T>>(){

                @Override
                public Validation<A, T> f(F<E, A> f) {
                    return FailProjection.this.map(f);
                }
            });
        }

        public boolean forall(F<E, Boolean> f) {
            return this.v.toEither().left().forall(f);
        }

        public boolean exists(F<E, Boolean> f) {
            return this.v.toEither().left().exists(f);
        }

        public List<E> toList() {
            return this.v.toEither().left().toList();
        }

        public Option<E> toOption() {
            return this.v.toEither().left().toOption();
        }

        public Array<E> toArray() {
            return this.v.toEither().left().toArray();
        }

        public Stream<E> toStream() {
            return this.v.toEither().left().toStream();
        }

        @Override
        public Iterator<E> iterator() {
            return this.v.toEither().left().iterator();
        }
    }
}

