/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Equal;
import fj.F;
import fj.F2;
import fj.F3;
import fj.Function;
import fj.Ord;
import fj.P;
import fj.P1;
import fj.P2;
import fj.P3;
import fj.Show;
import fj.data.Option;
import fj.data.Stream;
import fj.function.Integers;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Zipper<A>
implements Iterable<Zipper<A>> {
    private final Stream<A> left;
    private final A focus;
    private final Stream<A> right;

    private Zipper(Stream<A> stream, A a, Stream<A> stream2) {
        this.left = stream;
        this.focus = a;
        this.right = stream2;
    }

    public static <A> Zipper<A> zipper(Stream<A> stream, A a, Stream<A> stream2) {
        return new Zipper<A>(stream, a, stream2);
    }

    public static <A> Zipper<A> zipper(P3<Stream<A>, A, Stream<A>> p3) {
        return new Zipper<A>(p3._1(), p3._2(), p3._3());
    }

    public static <A> F3<Stream<A>, A, Stream<A>, Zipper<A>> zipper() {
        return new F3<Stream<A>, A, Stream<A>, Zipper<A>>(){

            @Override
            public Zipper<A> f(Stream<A> stream, A a, Stream<A> stream2) {
                return Zipper.zipper(stream, a, stream2);
            }
        };
    }

    public P3<Stream<A>, A, Stream<A>> p() {
        return P.p(this.left, this.focus, this.right);
    }

    public static <A> F<Zipper<A>, P3<Stream<A>, A, Stream<A>>> p_() {
        return new F<Zipper<A>, P3<Stream<A>, A, Stream<A>>>(){

            @Override
            public P3<Stream<A>, A, Stream<A>> f(Zipper<A> zipper) {
                return zipper.p();
            }
        };
    }

    public static <A> Ord<Zipper<A>> ord(Ord<A> ord) {
        Ord<Stream<A>> ord2 = Ord.streamOrd(ord);
        return Ord.p3Ord(ord2, ord, ord2).comap(Zipper.<Zipper<A>>p_());
    }

    public static <A> Equal<Zipper<A>> eq(Equal<A> equal) {
        Equal<Stream<A>> equal2 = Equal.streamEqual(equal);
        return Equal.p3Equal(equal2, equal, equal2).comap(Zipper.<Zipper<A>>p_());
    }

    public static <A> Show<Zipper<A>> show(Show<A> show) {
        Show<Stream<A>> show2 = Show.streamShow(show);
        return Show.p3Show(show2, show, show2).comap(Zipper.<Zipper<A>>p_());
    }

    public <B> Zipper<B> map(F<A, B> f) {
        return Zipper.zipper(this.left.map(f), f.f(this.focus), this.right.map(f));
    }

    public <B> B foldRight(F<A, F<B, B>> f, B b) {
        return this.left.foldLeft(Function.flip(f), this.right.cons(this.focus).foldRight(Function.compose(Function.andThen().f(P1.__1()), f), b));
    }

    public static <A> Zipper<A> single(A a) {
        return Zipper.zipper(Stream.nil(), a, Stream.nil());
    }

    public static <A> Option<Zipper<A>> fromStream(Stream<A> stream) {
        if (stream.isEmpty()) {
            return Option.none();
        }
        return Option.some(Zipper.zipper(Stream.nil(), stream.head(), stream.tail()._1()));
    }

    public static <A> Option<Zipper<A>> fromStreamEnd(Stream<A> stream) {
        if (stream.isEmpty()) {
            return Option.none();
        }
        Stream<A> stream2 = stream.reverse();
        return Option.some(Zipper.zipper(stream2.tail()._1(), stream2.head(), Stream.nil()));
    }

    public A focus() {
        return this.focus;
    }

    public Option<Zipper<A>> next() {
        return this.right.isEmpty() ? Option.none() : Option.some(this.tryNext());
    }

    public Zipper<A> tryNext() {
        if (this.right.isEmpty()) {
            throw new Error("Tried next at the end of a zipper.");
        }
        return Zipper.zipper(this.left.cons(this.focus), this.right.head(), this.right.tail()._1());
    }

    public Option<Zipper<A>> previous() {
        return this.left.isEmpty() ? Option.none() : Option.some(this.tryPrevious());
    }

    public Zipper<A> tryPrevious() {
        if (this.left.isEmpty()) {
            throw new Error("Tried previous at the beginning of a zipper.");
        }
        return Zipper.zipper(this.left.tail()._1(), this.left.head(), this.right.cons(this.focus));
    }

    public static <A> F<Zipper<A>, Option<Zipper<A>>> next_() {
        return new F<Zipper<A>, Option<Zipper<A>>>(){

            @Override
            public Option<Zipper<A>> f(Zipper<A> zipper) {
                return zipper.next();
            }
        };
    }

    public static <A> F<Zipper<A>, Option<Zipper<A>>> previous_() {
        return new F<Zipper<A>, Option<Zipper<A>>>(){

            @Override
            public Option<Zipper<A>> f(Zipper<A> zipper) {
                return zipper.previous();
            }
        };
    }

    public Zipper<A> insertLeft(A a) {
        return Zipper.zipper(this.left, a, this.right.cons(this.focus));
    }

    public Zipper<A> insertRight(A a) {
        return Zipper.zipper(this.left.cons(this.focus), a, this.right);
    }

    public Option<Zipper<A>> deleteLeft() {
        return this.left.isEmpty() && this.right.isEmpty() ? Option.none() : Option.some(Zipper.zipper(this.left.isEmpty() ? this.left : this.left.tail()._1(), this.left.isEmpty() ? this.right.head() : this.left.head(), this.left.isEmpty() ? this.right.tail()._1() : this.right));
    }

    public Option<Zipper<A>> deleteRight() {
        return this.left.isEmpty() && this.right.isEmpty() ? Option.none() : Option.some(Zipper.zipper(this.right.isEmpty() ? this.left.tail()._1() : this.left, this.right.isEmpty() ? this.left.head() : this.right.head(), this.right.isEmpty() ? this.right : this.right.tail()._1()));
    }

    public Zipper<A> deleteOthers() {
        Stream stream = Stream.nil();
        return Zipper.zipper(stream, this.focus, stream);
    }

    public int length() {
        return this.foldRight(Function.constant(Integers.add.f(1)), 0);
    }

    public boolean atStart() {
        return this.left.isEmpty();
    }

    public boolean atEnd() {
        return this.right.isEmpty();
    }

    public Zipper<Zipper<A>> positions() {
        Stream stream = Stream.unfold(new F<Zipper<A>, Option<P2<Zipper<A>, Zipper<A>>>>(){

            @Override
            public Option<P2<Zipper<A>, Zipper<A>>> f(Zipper<A> zipper) {
                return zipper.previous().map(Function.join(P.p2()));
            }
        }, this);
        Stream stream2 = Stream.unfold(new F<Zipper<A>, Option<P2<Zipper<A>, Zipper<A>>>>(){

            @Override
            public Option<P2<Zipper<A>, Zipper<A>>> f(Zipper<A> zipper) {
                return zipper.next().map(Function.join(P.p2()));
            }
        }, this);
        return Zipper.zipper(stream, this, stream2);
    }

    public <B> Zipper<B> cobind(F<Zipper<A>, B> f) {
        return this.positions().map(f);
    }

    public Zipper<P2<A, Boolean>> zipWithFocus() {
        return Zipper.zipper(this.left.zip(Stream.repeat(false)), P.p(this.focus, true), this.right.zip(Stream.repeat(false)));
    }

    public Option<Zipper<A>> move(int n) {
        Option<Zipper<Zipper<A>>> option;
        block4: {
            int n2;
            block3: {
                int n3 = this.left.length();
                n2 = this.right.length();
                option = Option.some(this);
                if (n < 0 || n >= this.length()) {
                    return Option.none();
                }
                if (n3 < n) break block3;
                for (int i = n3 - n; i > 0; --i) {
                    option = option.bind(Zipper.<Zipper<A>>previous_());
                }
                break block4;
            }
            if (n2 < n) break block4;
            for (int i = n2 - n; i > 0; --i) {
                option = option.bind(Zipper.<Zipper<A>>next_());
            }
        }
        return option;
    }

    public static <A> F<Integer, F<Zipper<A>, Option<Zipper<A>>>> move() {
        return Function.curry(new F2<Integer, Zipper<A>, Option<Zipper<A>>>(){

            @Override
            public Option<Zipper<A>> f(Integer n, Zipper<A> zipper) {
                return zipper.move(n);
            }
        });
    }

    public Option<Zipper<A>> find(final F<A, Boolean> f) {
        if (f.f(this.focus()).booleanValue()) {
            return Option.some(this);
        }
        Zipper<Zipper<A>> zipper = this.positions();
        return zipper.lefts().interleave(zipper.rights()).find(new F<Zipper<A>, Boolean>(){

            @Override
            public Boolean f(Zipper<A> zipper) {
                return (Boolean)f.f(zipper.focus());
            }
        });
    }

    public int index() {
        return this.left.length();
    }

    public Zipper<A> cycleNext() {
        if (this.left.isEmpty() && this.right.isEmpty()) {
            return this;
        }
        if (this.right.isEmpty()) {
            Stream<A> stream = this.left.reverse();
            return Zipper.zipper(Stream.nil(), stream.head(), stream.tail()._1().snoc(P.p(this.focus)));
        }
        return this.tryNext();
    }

    public Zipper<A> cyclePrevious() {
        if (this.left.isEmpty() && this.right.isEmpty()) {
            return this;
        }
        if (this.left.isEmpty()) {
            Stream<A> stream = this.right.reverse();
            return Zipper.zipper(stream.tail()._1().snoc(P.p(this.focus)), stream.head(), Stream.nil());
        }
        return this.tryPrevious();
    }

    public Option<Zipper<A>> deleteLeftCycle() {
        if (this.left.isEmpty() && this.right.isEmpty()) {
            return Option.none();
        }
        if (this.left.isNotEmpty()) {
            return Option.some(Zipper.zipper(this.left.tail()._1(), this.left.head(), this.right));
        }
        Stream<A> stream = this.right.reverse();
        return Option.some(Zipper.zipper(stream.tail()._1(), stream.head(), Stream.nil()));
    }

    public Option<Zipper<A>> deleteRightCycle() {
        if (this.left.isEmpty() && this.right.isEmpty()) {
            return Option.none();
        }
        if (this.right.isNotEmpty()) {
            return Option.some(Zipper.zipper(this.left, this.right.head(), this.right.tail()._1()));
        }
        Stream<A> stream = this.left.reverse();
        return Option.some(Zipper.zipper(Stream.nil(), stream.head(), stream.tail()._1()));
    }

    public Zipper<A> replace(A a) {
        return Zipper.zipper(this.left, a, this.right);
    }

    public Stream<A> toStream() {
        return this.left.reverse().snoc(P.p(this.focus)).append(this.right);
    }

    public Stream<A> lefts() {
        return this.left;
    }

    public Stream<A> rights() {
        return this.right;
    }

    public <B, C> Zipper<C> zipWith(Zipper<B> zipper, F2<A, B, C> f2) {
        return f2.zipZipperM().f(this, zipper);
    }

    public <B, C> Zipper<C> zipWith(Zipper<B> zipper, F<A, F<B, C>> f) {
        return this.zipWith(zipper, Function.uncurryF2(f));
    }

    @Override
    public Iterator<Zipper<A>> iterator() {
        return this.positions().toStream().iterator();
    }
}

