/*
 * Decompiled with CFR 0.152.
 */
package fj.test;

import fj.Bottom;
import fj.Effect;
import fj.F;
import fj.F2;
import fj.Function;
import fj.Monoid;
import fj.Ord;
import fj.P2;
import fj.Unit;
import fj.data.Array;
import fj.data.List;
import fj.test.Gen;
import fj.test.Rand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Gen<A> {
    private final F<Integer, F<Rand, A>> f;

    private Gen(F<Integer, F<Rand, A>> f) {
        this.f = f;
    }

    public A gen(int n, Rand rand) {
        return this.f.f(n).f(rand);
    }

    public <B> Gen<B> map(final F<A, B> f) {
        return new Gen<A>(new F<Integer, F<Rand, B>>(){

            @Override
            public F<Rand, B> f(final Integer n) {
                return new F<Rand, B>(){

                    @Override
                    public B f(Rand rand) {
                        return f.f(Gen.this.gen(n, rand));
                    }
                };
            }
        });
    }

    public Gen<A> filter(final F<A, Boolean> f) {
        return Gen.gen(Function.curry(new F2<Integer, Rand, A>(){

            @Override
            public A f(Integer n, Rand rand) {
                Object a;
                while (!((Boolean)f.f(a = Gen.this.gen(n, rand))).booleanValue()) {
                }
                return a;
            }
        }));
    }

    public Unit foreach(Integer n, Rand rand, F<A, Unit> f) {
        return f.f(this.f.f(n).f(rand));
    }

    public void foreach(Integer n, Rand rand, Effect<A> effect) {
        effect.e(this.f.f(n).f(rand));
    }

    public <B> Gen<B> bind(final F<A, Gen<B>> f) {
        return new Gen<A>(new F<Integer, F<Rand, B>>(){

            @Override
            public F<Rand, B> f(final Integer n) {
                return new F<Rand, B>(){

                    @Override
                    public B f(Rand rand) {
                        return ((F)((Gen)f.f(Gen.this.gen(n, rand))).f.f(n)).f(rand);
                    }
                };
            }
        });
    }

    public <B, C> Gen<C> bind(Gen<B> gen, F<A, F<B, C>> f) {
        return gen.apply(this.map(f));
    }

    public <B, C, D> Gen<D> bind(Gen<B> gen, Gen<C> gen2, F<A, F<B, F<C, D>>> f) {
        return gen2.apply(this.bind(gen, f));
    }

    public <B, C, D, E> Gen<E> bind(Gen<B> gen, Gen<C> gen2, Gen<D> gen3, F<A, F<B, F<C, F<D, E>>>> f) {
        return gen3.apply(this.bind(gen, gen2, f));
    }

    public <B, C, D, E, F$> Gen<F$> bind(Gen<B> gen, Gen<C> gen2, Gen<D> gen3, Gen<E> gen4, F<A, F<B, F<C, F<D, F<E, F$>>>>> f) {
        return gen4.apply(this.bind(gen, gen2, gen3, f));
    }

    public <B, C, D, E, F$, G> Gen<G> bind(Gen<B> gen, Gen<C> gen2, Gen<D> gen3, Gen<E> gen4, Gen<F$> gen5, F<A, F<B, F<C, F<D, F<E, F<F$, G>>>>>> f) {
        return gen5.apply(this.bind(gen, gen2, gen3, gen4, f));
    }

    public <B, C, D, E, F$, G, H> Gen<H> bind(Gen<B> gen, Gen<C> gen2, Gen<D> gen3, Gen<E> gen4, Gen<F$> gen5, Gen<G> gen6, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, H>>>>>>> f) {
        return gen6.apply(this.bind(gen, gen2, gen3, gen4, gen5, f));
    }

    public <B, C, D, E, F$, G, H, I> Gen<I> bind(Gen<B> gen, Gen<C> gen2, Gen<D> gen3, Gen<E> gen4, Gen<F$> gen5, Gen<G> gen6, Gen<H> gen7, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, F<H, I>>>>>>>> f) {
        return gen7.apply(this.bind(gen, gen2, gen3, gen4, gen5, gen6, f));
    }

    public <B> Gen<B> apply(Gen<F<A, B>> gen) {
        return gen.bind(new F<F<A, B>, Gen<B>>(){

            @Override
            public Gen<B> f(final F<A, B> f) {
                return Gen.this.map(new F<A, B>(){

                    @Override
                    public B f(A a) {
                        return f.f(a);
                    }
                });
            }
        });
    }

    public Gen<A> resize(final int n) {
        return new Gen<A>(new F<Integer, F<Rand, A>>(){

            @Override
            public F<Rand, A> f(Integer n2) {
                return new F<Rand, A>(){

                    @Override
                    public A f(Rand rand) {
                        return ((F)Gen.this.f.f(n)).f(rand);
                    }
                };
            }
        });
    }

    public static <A> Gen<A> gen(F<Integer, F<Rand, A>> f) {
        return new Gen<A>(f);
    }

    public static <A> Gen<List<A>> sequence(List<Gen<A>> list) {
        return list.foldRight(new F<Gen<A>, F<Gen<List<A>>, Gen<List<A>>>>(){

            @Override
            public F<Gen<List<A>>, Gen<List<A>>> f(final Gen<A> gen) {
                return new F<Gen<List<A>>, Gen<List<A>>>(){

                    @Override
                    public Gen<List<A>> f(Gen<List<A>> gen2) {
                        return gen.bind(gen2, List.cons());
                    }
                };
            }
        }, Gen.value(List.nil()));
    }

    public static <A> Gen<List<A>> sequenceN(int n, Gen<A> gen) {
        return Gen.sequence(List.replicate(n, gen));
    }

    public static <A> Gen<A> parameterised(final F<Integer, F<Rand, Gen<A>>> f) {
        return new Gen<A>(Function.curry(new F2<Integer, Rand, A>(){

            @Override
            public A f(Integer n, Rand rand) {
                return ((Gen)((F)f.f(n)).f(rand)).gen(n, rand);
            }
        }));
    }

    public static <A> Gen<A> sized(F<Integer, Gen<A>> f) {
        return Gen.parameterised(Function.flip(Function.constant(f)));
    }

    public static <A> Gen<A> value(final A a) {
        return new Gen<A>(new F<Integer, F<Rand, A>>(){

            @Override
            public F<Rand, A> f(Integer n) {
                return new F<Rand, A>(){

                    @Override
                    public A f(Rand rand) {
                        return a;
                    }
                };
            }
        });
    }

    public static Gen<Integer> choose(int n, int n2) {
        final int n3 = Math.min(n, n2);
        final int n4 = Math.max(n, n2);
        return Gen.parameterised(Function.curry(new F2<Integer, Rand, Gen<Integer>>(){

            @Override
            public Gen<Integer> f(Integer n, Rand rand) {
                return Gen.value(rand.choose(n3, n4));
            }
        }));
    }

    public static Gen<Double> choose(double d, double d2) {
        final double d3 = Math.min(d, d2);
        final double d4 = Math.max(d, d2);
        return Gen.parameterised(new F<Integer, F<Rand, Gen<Double>>>(){

            @Override
            public F<Rand, Gen<Double>> f(Integer n) {
                return new F<Rand, Gen<Double>>(){

                    @Override
                    public Gen<Double> f(Rand rand) {
                        return Gen.value(rand.choose(d3, d4));
                    }
                };
            }
        });
    }

    public static <A> Gen<A> fail() {
        return new Gen<A>(new F<Integer, F<Rand, A>>(){

            @Override
            public F<Rand, A> f(Integer n) {
                return new F<Rand, A>(){

                    @Override
                    public A f(Rand rand) {
                        throw Bottom.error("Failing generator");
                    }
                };
            }
        });
    }

    public static <A> Gen<A> join(Gen<Gen<A>> gen) {
        return gen.bind(Function.identity());
    }

    public static <A> Gen<A> frequency(final List<P2<Integer, Gen<A>>> list) {
        F f = P2.__1();
        return Gen.choose(1, Monoid.intAdditionMonoid.sumLeft(list.map(f))).bind(new F<Integer, Gen<A>>(){

            @Override
            public Gen<A> f(Integer n) {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                final class Pick {
                    Pick() {
                    }

                    <A> Gen<A> pick(int n, List<P2<Integer, Gen<A>>> list) {
                        if (list.isEmpty()) {
                            return Gen.fail();
                        }
                        int n2 = list.head()._1();
                        return n <= n2 ? list.head()._2() : this.pick(n - n2, list.tail());
                    }
                }
                return new Pick().pick(n, list);
            }
        });
    }

    public static <A> Gen<A> elemFrequency(List<P2<Integer, A>> list) {
        return Gen.frequency(list.map(new F<P2<Integer, A>, P2<Integer, Gen<A>>>(){

            @Override
            public P2<Integer, Gen<A>> f(P2<Integer, A> p2) {
                return p2.map2(new F<A, Gen<A>>(){

                    @Override
                    public Gen<A> f(A a) {
                        return Gen.value(a);
                    }
                });
            }
        }));
    }

    public static <A> Gen<A> elements(final A ... AArray) {
        return Array.array(AArray).isEmpty() ? Gen.fail() : Gen.choose(0, AArray.length - 1).map(new F<Integer, A>(){

            @Override
            public A f(Integer n) {
                return AArray[n];
            }
        });
    }

    public static <A> Gen<A> oneOf(final List<Gen<A>> list) {
        return list.isEmpty() ? Gen.fail() : Gen.choose(0, list.length() - 1).bind(new F<Integer, Gen<A>>(){

            @Override
            public Gen<A> f(Integer n) {
                return (Gen)list.index(n);
            }
        });
    }

    public static <A> Gen<List<A>> listOf(final Gen<A> gen, final int n) {
        return Gen.sized(new F<Integer, Gen<List<A>>>(){

            @Override
            public Gen<List<A>> f(Integer n2) {
                return Gen.choose(n, n2).bind(new F<Integer, Gen<List<A>>>(){

                    @Override
                    public Gen<List<A>> f(Integer n) {
                        return Gen.sequenceN(n, gen);
                    }
                });
            }
        });
    }

    public static <A> Gen<List<A>> listOf(Gen<A> gen) {
        return Gen.listOf(gen, 0);
    }

    public static <A> Gen<List<A>> listOf1(Gen<A> gen) {
        return Gen.listOf(gen, 1);
    }

    public static <A> Gen<List<A>> pick(int n, final List<A> list) {
        return n < 0 || n > list.length() ? Gen.fail() : Gen.sequenceN(n, Gen.choose(0, list.length() - 1)).map(new F<List<Integer>, List<A>>(){

            @Override
            public List<A> f(List<Integer> list5) {
                List list2 = List.nil();
                List<Integer> list3 = list5.sort(Ord.intOrd);
                List list4 = list.zipIndex();
                while (list3.isNotEmpty() && list4.isNotEmpty()) {
                    if (list3.head().equals(list4.head()._2())) {
                        list3 = list3.tail();
                    } else {
                        list2 = list2.snoc(list4.head()._1());
                    }
                    list4 = list4.tail();
                }
                return list2;
            }
        });
    }

    public static <A> Gen<List<A>> someOf(final List<A> list) {
        return Gen.choose(0, list.length()).bind(new F<Integer, Gen<List<A>>>(){

            @Override
            public Gen<List<A>> f(Integer n) {
                return Gen.pick(n, list);
            }
        });
    }

    public static <A, B> Gen<F<A, B>> promote(final F<A, Gen<B>> f) {
        return new Gen<F<A, B>>(new F<Integer, F<Rand, F<A, B>>>(){

            @Override
            public F<Rand, F<A, B>> f(final Integer n) {
                return new F<Rand, F<A, B>>(){

                    @Override
                    public F<A, B> f(final Rand rand) {
                        return new F<A, B>(){

                            @Override
                            public B f(A a) {
                                return ((F)((Gen)f.f(a)).f.f(n)).f(rand);
                            }
                        };
                    }
                };
            }
        });
    }
}

