/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.esupecm.nuxeo2xml.service;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.jaxen.JaxenException;
import org.jaxen.dom4j.Dom4jXPath;
import org.jaxen.expr.Expr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.Step;

public class XmlTool {
    private static final Log log = LogFactory.getLog(XmlTool.class);

    public static Node createNodeFromXpath(String rootXpath, String xpath, Document document) {
        String parentXpathRoot = null;
        if (rootXpath != null) {
            LocationPath lpRoot = XmlTool.getLocationPath(rootXpath);
            List stepsRoot = lpRoot.getSteps();
            parentXpathRoot = XmlTool.getXPathFromSteps(stepsRoot, lpRoot.isAbsolute());
        }
        Element result = null;
        LocationPath lp = XmlTool.getLocationPath(xpath);
        if (lp != null) {
            List steps = lp.getSteps();
            Step lastStep = (Step)steps.remove(steps.size() - 1);
            String parentXpath = XmlTool.getXPathFromSteps(steps, lp.isAbsolute());
            Node parent = document.selectSingleNode(parentXpath);
            boolean haveToCreate = false;
            if (parent == null) {
                haveToCreate = true;
            }
            if (!haveToCreate && steps.size() > 0) {
                steps.remove(steps.size() - 1);
                String grandParentXpath = XmlTool.getXPathFromSteps(steps, lp.isAbsolute());
                if (parentXpathRoot != null && parentXpathRoot.equals(grandParentXpath)) {
                    haveToCreate = true;
                }
            }
            if (haveToCreate) {
                parent = XmlTool.createNodeFromXpath(rootXpath, parentXpath, document);
            }
            if (parent == null) {
                log.error((Object)"createNodeFromXpath :: can not create node from xpath");
            } else {
                String txt = lastStep.getText();
                String name = txt.substring(txt.indexOf("::") + "::".length());
                if (name.indexOf("[") != -1) {
                    name = name.substring(0, name.indexOf("["));
                }
                if (parent instanceof Element) {
                    Element parentElement = (Element)parent;
                    Element element = null;
                    switch (lastStep.getAxis()) {
                        case 9: {
                            Attribute newAttribute = DocumentHelper.createAttribute(null, (String)name, (String)"");
                            parentElement.add(newAttribute);
                            result = newAttribute;
                            break;
                        }
                        default: {
                            element = DocumentHelper.createElement((String)name);
                            parentElement.add(element);
                            result = element;
                        }
                    }
                    List predicates = lastStep.getPredicates();
                    if (predicates != null) {
                        for (int i = 0; i < predicates.size(); ++i) {
                            Predicate predicate = (Predicate)predicates.get(i);
                            if (element == null) continue;
                            XmlTool.addPredicates(element, predicate);
                        }
                    }
                } else {
                    log.error((Object)("createNodeFromXpath :: can not create child :: xpath=" + xpath));
                }
            }
        } else {
            log.error((Object)"createNodeFromXpath :: can not resolve xpath");
        }
        return result;
    }

    private static void addPredicates(Element element, Predicate predicate) {
        String predicateText = predicate.getExpr().simplify().getText();
        if (predicateText.startsWith("(") && predicateText.endsWith(")")) {
            predicateText = predicateText.substring(1, predicateText.length() - 1);
        }
        String[] predicateStepTexts = predicateText.split("/");
        for (int j = 0; predicateStepTexts != null && j < predicateStepTexts.length; ++j) {
            String predicateStepText = predicateStepTexts[j];
            String predicateStepTextType = predicateStepText.substring(0, predicateStepTexts[j].indexOf("::"));
            String predicateStepTextValue = predicateStepText.substring(predicateStepTextType.length() + "::".length());
            String predicateStepTextAttributeName = null;
            String predicateStepTextAttributeValue = null;
            if (predicateStepTextValue.indexOf("=") != -1) {
                predicateStepTextAttributeName = predicateStepTextValue.substring(0, predicateStepTextValue.indexOf("=")).trim();
                predicateStepTextAttributeValue = predicateStepTextValue.substring(predicateStepTextValue.indexOf("=") + 1).trim();
                predicateStepTextAttributeValue = predicateStepTextAttributeValue.replaceAll("\"", "");
                predicateStepTextAttributeValue = predicateStepTextAttributeValue.replaceAll("'", "");
            } else {
                predicateStepTextAttributeName = predicateStepTextValue;
            }
            if ("child".equals(predicateStepTextType)) {
                element = element.addElement(predicateStepTextAttributeName);
                if (predicateStepTextAttributeValue == null) continue;
                element.setText(predicateStepTextAttributeValue);
                continue;
            }
            element = element.addAttribute(predicateStepTextAttributeName, predicateStepTextAttributeValue);
        }
    }

    private static LocationPath getLocationPath(String xpath) {
        LocationPath lp = null;
        try {
            Expr xpathExpr = new Dom4jXPath(xpath).getRootExpr();
            if (xpathExpr instanceof LocationPath) {
                lp = (LocationPath)xpathExpr;
            }
        }
        catch (JaxenException e) {
            log.error((Object)("getLocationPath :: " + (Object)((Object)e)), (Throwable)e);
        }
        return lp;
    }

    private static String getXPathFromSteps(List<Step> steps, boolean absolutePath) {
        StringBuffer sb = new StringBuffer();
        if (absolutePath) {
            sb.append("/");
        }
        for (Step step : steps) {
            sb.append(step.getText()).append("/");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

