/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.esupecm.nuxeo2xml.service;

import de.schlichtherle.io.FileInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.dom4j.Dom4jXPath;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.io.impl.plugins.SingleDocumentReader;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.RuntimeContext;
import org.orioai.esupecm.nuxeo2xml.Nuxeo2XmlDescriptor;
import org.orioai.esupecm.nuxeo2xml.Nuxeo2XmlDescriptorMetadata;
import org.orioai.esupecm.nuxeo2xml.Nuxeo2XmlDescriptorMetadataTranslation;
import org.orioai.esupecm.nuxeo2xml.Nuxeo2XmlDescriptorNamespace;
import org.orioai.esupecm.nuxeo2xml.NuxeoDocumentUrlDescriptor;
import org.orioai.esupecm.nuxeo2xml.service.OriOaiNuxeo2XmlService;
import org.orioai.esupecm.nuxeo2xml.service.XmlTool;

public class OriOaiNuxeo2XmlServiceImpl
extends DefaultComponent
implements OriOaiNuxeo2XmlService {
    private static final Log log = LogFactory.getLog(OriOaiNuxeo2XmlServiceImpl.class);
    protected List<Nuxeo2XmlDescriptor> config = new ArrayList<Nuxeo2XmlDescriptor>();
    protected NuxeoDocumentUrlDescriptor nuxeoUrlConfig;
    protected Map<String, Nuxeo2XmlDescriptor> nuxeo2XmlDescriptorMap = new HashMap<String, Nuxeo2XmlDescriptor>();
    protected RuntimeContext context;
    private static final String NUXEO_URL = "NUXEO_URL";
    private static final String nuxeoIdXpath = "normalize-space(//@id)";

    public Map<String, Nuxeo2XmlDescriptor> getNuxeo2XmlDescriptorMap() {
        return this.nuxeo2XmlDescriptorMap;
    }

    public void activate(ComponentContext context) {
        this.context = context.getRuntimeContext();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("registerContribution :: add " + contribution + ", extensionPoint=" + extensionPoint + ", contributor=" + contributor));
        }
        if ("nuxeoDocumentUrl".equals(extensionPoint)) {
            this.nuxeoUrlConfig = (NuxeoDocumentUrlDescriptor)contribution;
        } else {
            this.config.add((Nuxeo2XmlDescriptor)contribution);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("unregisterContribution :: remove " + contribution + ", extensionPoint=" + extensionPoint + ", contributor=" + contributor));
        }
        if ("nuxeoDocumentUrl".equals(extensionPoint)) {
            this.nuxeoUrlConfig = null;
        } else {
            this.config.remove(contribution);
        }
    }

    public void registerExtension(Extension extension) throws Exception {
        super.registerExtension(extension);
        if (log.isDebugEnabled()) {
            log.debug((Object)"registerExtension :: register");
        }
        for (Nuxeo2XmlDescriptor desc : this.config) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("registerExtension :: desc = " + desc));
            }
            this.nuxeo2XmlDescriptorMap.put(desc.getMetadataSchemaNamespace(), desc);
        }
    }

    public static String readFileAsString(String filePath) throws IOException {
        StringBuffer fileData = new StringBuffer(1000);
        BufferedInputStream reader = new BufferedInputStream((InputStream)new FileInputStream(filePath));
        byte[] buf = new byte[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = new String(buf, 0, numRead, "utf-8");
            fileData.append(readData);
            buf = new byte[1024];
        }
        reader.close();
        return fileData.toString();
    }

    private String getEmbeddedXmlMetadataFilePath(DocumentModel doc, Nuxeo2XmlDescriptor nuxeoDescriptor) throws ClientException {
        String requestedFilename;
        Blob requestedBlob;
        Property propertyFile;
        if (nuxeoDescriptor != null && doc.isDownloadable() && (propertyFile = doc.getProperty("file:content")) != null && (requestedBlob = (Blob)propertyFile.getValue()) != null && (requestedFilename = requestedBlob.getFilename()).endsWith(".zip")) {
            try {
                File[] files;
                String versionUid = doc.getId();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getEmbeddedXmlMetadataFilePath :: versionUid=" + versionUid));
                }
                String tempdir = System.getProperty("java.io.tmpdir");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getEmbeddedXmlMetadataFilePath :: tempdir=" + tempdir));
                }
                File zipFile = new File(tempdir, "nuxeo-md-to-wf-" + versionUid + ".zip");
                File zipDirectory = new File(tempdir, "nuxeo-md-to-wf-" + versionUid);
                if (!zipDirectory.exists()) {
                    int len;
                    InputStream inputStream = requestedBlob.getStream();
                    FileOutputStream out = new FileOutputStream(zipFile);
                    byte[] buf = new byte[1024];
                    while ((len = inputStream.read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                    ((OutputStream)out).close();
                    inputStream.close();
                    de.schlichtherle.io.File trueZipFile = new de.schlichtherle.io.File(zipFile);
                    trueZipFile.copyAllTo(zipDirectory);
                }
                if ((files = zipDirectory.listFiles()) != null && files.length == 1 && files[0].isDirectory()) {
                    String rootDirecotoryName = files[0].getName();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("getEmbeddedXmlMetadataFilePath :: one directory element :: " + rootDirecotoryName));
                    }
                    zipDirectory = files[0];
                }
                File embeddedMetadataFile = new File(zipDirectory, nuxeoDescriptor.getEmbeddedMetadataFilePath());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getEmbeddedXmlMetadataFilePath :: embeddedMetadataFile=" + embeddedMetadataFile));
                }
                boolean exists = embeddedMetadataFile.exists();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getEmbeddedXmlMetadataFilePath :: exists=" + exists));
                }
                if (exists) {
                    String filePath = embeddedMetadataFile.getAbsolutePath();
                    return filePath;
                }
            }
            catch (Exception ie) {
                log.error((Object)("getEmbeddedXmlMetadataFilePath :: problem unziping zip file from document :" + doc.getId()), (Throwable)ie);
            }
        }
        return null;
    }

    @Override
    public String mergeXmlDoc(CoreSession session, DocumentModel version, String blobXpath, String lomBlobXpath, String wkfXmlDocument) {
        return wkfXmlDocument;
    }

    @Override
    public String mergeXmlDoc(CoreSession documentManager, DocumentModel doc, String metadataSchemaNamespace, String workflowXmlDocument) throws ClientException {
        StringBuffer xmlContent = new StringBuffer();
        try {
            Nuxeo2XmlDescriptorMetadata[] nuxeoDescriptorMetadatas;
            Nuxeo2XmlDescriptor nuxeoDescriptor;
            if (log.isDebugEnabled()) {
                log.debug((Object)("mergeXmlDoc :: documentRef : " + doc.getRef() + " metadataSchemaNamespace : " + metadataSchemaNamespace));
                log.debug((Object)("mergeXmlDoc :: nuxeo2XmlDescriptorMap = " + this.nuxeo2XmlDescriptorMap));
                log.debug((Object)("mergeXmlDoc :: metadataSchemaNamespace = " + metadataSchemaNamespace));
            }
            if ((nuxeoDescriptor = this.nuxeo2XmlDescriptorMap.get(metadataSchemaNamespace)) == null) {
                throw new ClientException(metadataSchemaNamespace + " not found in extension point nuxeoToxml of OriOaiNuxeo2XmlService. Probably in orioainuxeo2xml-contrib.xml");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("mergeXmlDoc :: used nuxeoDescriptor = " + nuxeoDescriptor));
            }
            if ((nuxeoDescriptorMetadatas = nuxeoDescriptor.getMetadatas()) == null) {
                return workflowXmlDocument;
            }
            SAXReader workflowReader = new SAXReader();
            Document workflowRootDocument = workflowReader.read((Reader)new StringReader(workflowXmlDocument));
            Nuxeo2XmlDescriptorNamespace[] nuxeoDescriptorNamespaces = nuxeoDescriptor.getNamespaces();
            HashMap<String, String> nsWorkflowMap = new HashMap<String, String>();
            for (int n = 0; nuxeoDescriptorNamespaces != null && n < nuxeoDescriptorNamespaces.length; ++n) {
                Nuxeo2XmlDescriptorNamespace nuxeoDescriptorNamespace = nuxeoDescriptorNamespaces[n];
                nsWorkflowMap.put(nuxeoDescriptorNamespace.getPrefix(), nuxeoDescriptorNamespace.getNamespace());
            }
            String embeddedXmlMetadataFilePath = this.getEmbeddedXmlMetadataFilePath(doc, nuxeoDescriptor);
            if (embeddedXmlMetadataFilePath != null) {
                SAXReader embeddedReader = new SAXReader();
                Document embeddedRootDocument = embeddedReader.read(new File(embeddedXmlMetadataFilePath));
                workflowRootDocument = this.getMergedXmlDocs(nuxeoDescriptorMetadatas, "FILE", embeddedRootDocument, nsWorkflowMap, workflowRootDocument, nsWorkflowMap);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("mergeXmlDoc :: embedded xml == " + workflowRootDocument.asXML()));
                }
            }
            SingleDocumentReader documentReader = new SingleDocumentReader(documentManager, doc);
            String nuxeoXmlDocument = documentReader.read().getDocument().asXML();
            if (log.isDebugEnabled()) {
                log.debug((Object)("mergeXmlDoc :: nuxeoXmlDocument = " + nuxeoXmlDocument));
            }
            HashMap<String, String> nsNuxeoMap = new HashMap<String, String>();
            nsNuxeoMap.put("dc", "http://purl.org/dc/elements/1.1/");
            nsNuxeoMap.put("oai_dc", "http://www.openarchives.org/OAI/2.0/oai_dc/");
            nsNuxeoMap.put("nx_dc", "http://www.nuxeo.org/ecm/schemas/dublincore/");
            nsNuxeoMap.put("nx_uid", "http://project.nuxeo.com/geide/schemas/uid/");
            nsNuxeoMap.put("nx_common", "http://www.nuxeo.org/ecm/schemas/common/");
            nsNuxeoMap.put("nx_file", "http://www.nuxeo.org/ecm/schemas/file/");
            nsNuxeoMap.put("nx_picture", "http://www.nuxeo.org/ecm/schemas/picture");
            SAXReader nuxeoReader = new SAXReader();
            Document nuxeoRootDocument = nuxeoReader.read((Reader)new StringReader(nuxeoXmlDocument));
            workflowRootDocument = this.getMergedXmlDocs(nuxeoDescriptorMetadatas, "NUXEO", nuxeoRootDocument, nsNuxeoMap, workflowRootDocument, nsWorkflowMap);
            workflowRootDocument = this.getMergedXmlDocs(nuxeoDescriptorMetadatas, "STATIC", null, null, workflowRootDocument, nsWorkflowMap);
            String newXml = workflowRootDocument.asXML();
            xmlContent.append(newXml);
            if (log.isDebugEnabled()) {
                log.debug((Object)("mergeXmlDoc :: newXml == " + newXml));
            }
        }
        catch (IOException e) {
            log.error((Object)("mergeXmlDoc :: IO error : documentRef : " + doc.getRef() + " metadataSchemaNamespace : " + metadataSchemaNamespace), (Throwable)e);
            xmlContent.append(workflowXmlDocument);
        }
        catch (DocumentException e) {
            log.error((Object)("mergeXmlDoc :: IO error : documentRef : " + doc.getRef() + " metadataSchemaNamespace : " + metadataSchemaNamespace), (Throwable)e);
            xmlContent.append(workflowXmlDocument);
        }
        catch (JaxenException e) {
            log.error((Object)("mergeXmlDoc :: IO error : documentRef : " + doc.getRef() + " metadataSchemaNamespace : " + metadataSchemaNamespace), (Throwable)e);
            xmlContent.append(workflowXmlDocument);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)xmlContent.toString());
        }
        return xmlContent.toString();
    }

    public Document getMergedXmlDocs(Nuxeo2XmlDescriptorMetadata[] nuxeoDescriptorMetadatas, String type, Document fromRootDocument, HashMap<String, String> nsFromMap, Document workflowRootDocument, HashMap<String, String> nsWorkflowMap) throws JaxenException {
        for (Nuxeo2XmlDescriptorMetadata nuxeoDescriptorMetadata : nuxeoDescriptorMetadatas) {
            try {
                if (!type.equals(nuxeoDescriptorMetadata.getType())) continue;
                boolean addIfEmpty = "empty".equals(nuxeoDescriptorMetadata.getCondition());
                ArrayList<String> elementValues = new ArrayList<String>();
                String fromXpath = nuxeoDescriptorMetadata.getFromXpath();
                if (fromXpath != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("getMergedXmlDocs :: fromXpath=" + fromXpath));
                    }
                    if (NUXEO_URL.equals(fromXpath)) {
                        fromXpath = nuxeoIdXpath;
                    }
                    Dom4jXPath fromXpathExpression = new Dom4jXPath(fromXpath);
                    fromXpathExpression.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(nsFromMap));
                    List fromElements = fromXpathExpression.selectNodes((Object)fromRootDocument);
                    if (fromElements != null) {
                        for (Object fromElement : fromElements) {
                            String elementValue = fromElement.toString();
                            if (fromElement instanceof Element) {
                                elementValue = ((Element)fromElement).getText();
                            } else if (fromElement instanceof Attribute) {
                                Attribute attrFromElement = (Attribute)fromElement;
                                elementValue = attrFromElement.getText();
                            }
                            if (NUXEO_URL.equals(nuxeoDescriptorMetadata.getFromXpath())) {
                                elementValue = this.nuxeoUrlConfig.getDocumentUrl() + elementValue;
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("getMergedXmlDocs :: nuxeoUrlConfig=" + this.nuxeoUrlConfig));
                                }
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("getMergedXmlDocs :: elementValue=" + elementValue));
                            }
                            if (elementValue == null || "".equals(elementValue)) continue;
                            elementValues.add(elementValue);
                        }
                    }
                } else {
                    elementValues.add("default");
                }
                String workflowXpath = nuxeoDescriptorMetadata.getWorkflowXpath();
                String workflowXpathRoot = nuxeoDescriptorMetadata.getWorkflowXpathRoot();
                if (elementValues == null) continue;
                if (workflowXpathRoot != null) {
                    Dom4jXPath workflowXpathRootExpression = new Dom4jXPath(workflowXpathRoot);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("getMergedXmlDocs :: workflowXpathRoot=" + workflowXpathRoot));
                    }
                    workflowXpathRootExpression.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(nsWorkflowMap));
                    Object workflowRootElementObject = workflowXpathRootExpression.selectSingleNode((Object)workflowRootDocument);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("getMergedXmlDocs :: workflowRootElementObject=" + workflowRootElementObject));
                    }
                    if (workflowRootElementObject == null) {
                        Node workflowRootNode = XmlTool.createNodeFromXpath(null, workflowXpathRoot, workflowRootDocument);
                        try {
                            workflowRootDocument = new SAXReader().read((Reader)new StringReader(workflowRootNode.getDocument().asXML()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            log.error((Object)("getMergedXmlDocs :: " + e), (Throwable)e);
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("getMergedXmlDocs :: workflowRootDocument=" + workflowRootDocument.asXML()));
                    }
                }
                Nuxeo2XmlDescriptorMetadataTranslation[] translations = nuxeoDescriptorMetadata.getTranslations();
                for (String elementValue : elementValues) {
                    elementValue = this.translateValue(elementValue, translations);
                    Dom4jXPath workflowXpathExpression = new Dom4jXPath(workflowXpath);
                    workflowXpathExpression.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(nsWorkflowMap));
                    List workflowElementList = workflowXpathExpression.selectNodes((Object)workflowRootDocument);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("getMergedXmlDocs :: workflowElementList=" + workflowElementList));
                    }
                    boolean foundSameValue = false;
                    int firstEmptyElementIndex = -1;
                    boolean empty = true;
                    for (int w = 0; !foundSameValue && workflowElementList != null && w < workflowElementList.size(); ++w) {
                        String workflowElementValue;
                        Element workflowElement;
                        Object workflowElementObject = workflowElementList.get(w);
                        if (workflowElementObject instanceof Element) {
                            workflowElement = (Element)workflowElementObject;
                            workflowElementValue = workflowElement.getText();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("getMergedXmlDocs :: workflowElementValue=" + workflowElementValue));
                            }
                            if (workflowElementValue.equals(elementValue)) {
                                foundSameValue = true;
                            }
                            if (firstEmptyElementIndex == -1 && workflowElementValue.equals("")) {
                                firstEmptyElementIndex = w;
                            }
                            if (workflowElementValue == null || workflowElementValue.equals("")) continue;
                            empty = false;
                            continue;
                        }
                        if (!(workflowElementObject instanceof Attribute)) continue;
                        workflowElement = (Attribute)workflowElementObject;
                        workflowElementValue = workflowElement.getText();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("getMergedXmlDocs :: workflowElementValue=" + workflowElementValue));
                        }
                        if (workflowElementValue.equals(elementValue)) {
                            foundSameValue = true;
                        }
                        if (firstEmptyElementIndex == -1 && workflowElementValue.equals("")) {
                            firstEmptyElementIndex = w;
                        }
                        if (workflowElementValue == null || workflowElementValue.equals("")) continue;
                        empty = false;
                    }
                    if (foundSameValue || addIfEmpty && (!addIfEmpty || !empty)) continue;
                    if (firstEmptyElementIndex != -1) {
                        Element workflowElement;
                        Object workflowElementObject = workflowElementList.get(firstEmptyElementIndex);
                        if (workflowElementObject instanceof Element) {
                            workflowElement = (Element)workflowElementObject;
                            if (nuxeoDescriptorMetadata.isCDATA()) {
                                workflowElement.add(DocumentHelper.createCDATA((String)elementValue));
                                continue;
                            }
                            workflowElement.setText(elementValue.trim());
                            continue;
                        }
                        if (!(workflowElementObject instanceof Attribute)) continue;
                        workflowElement = (Attribute)workflowElementObject;
                        workflowElement.setText(elementValue.trim());
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"getMergedXmlDocs :: add a node");
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("workflowXpathRoot=" + workflowXpathRoot));
                        log.debug((Object)("workflowXpath=" + workflowXpath));
                    }
                    Node created = XmlTool.createNodeFromXpath(workflowXpathRoot, workflowXpath, workflowRootDocument);
                    if (nuxeoDescriptorMetadata.isCDATA() && created instanceof Element) {
                        Element createdElement = (Element)created;
                        createdElement.add(DocumentHelper.createCDATA((String)elementValue));
                    } else {
                        created.setText(elementValue.trim());
                    }
                    workflowRootDocument = created.getDocument();
                }
            }
            catch (Exception e) {
                log.error((Object)("getMergedXmlDocs :: " + e), (Throwable)e);
            }
        }
        return workflowRootDocument;
    }

    private String translateValue(String fromValue, Nuxeo2XmlDescriptorMetadataTranslation[] translations) {
        String toValue = null;
        Nuxeo2XmlDescriptorMetadataTranslation defaultTranslation = null;
        for (int i = 0; translations != null && toValue == null && i < translations.length; ++i) {
            Nuxeo2XmlDescriptorMetadataTranslation translation = translations[i];
            if (fromValue.equals(translation.getFrom())) {
                toValue = translation.getTo();
            }
            if (translation.getFrom() != null) continue;
            defaultTranslation = translation;
        }
        if (toValue == null) {
            if (defaultTranslation != null) {
                return defaultTranslation.getTo();
            }
            return fromValue;
        }
        return toValue;
    }

    @Override
    public String getLastVersionUrl() {
        return this.nuxeoUrlConfig.getDocumentUrl();
    }
}

