/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.esupecm.relations;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remove;
import javax.faces.application.FacesMessage;
import javax.faces.event.ActionEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.relations.api.Literal;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QNameResource;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.Subject;
import org.nuxeo.ecm.platform.relations.api.impl.LiteralImpl;
import org.nuxeo.ecm.platform.relations.api.impl.QNameResourceImpl;
import org.nuxeo.ecm.platform.relations.api.impl.RelationDate;
import org.nuxeo.ecm.platform.relations.api.impl.ResourceImpl;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;
import org.nuxeo.ecm.platform.relations.api.util.RelationConstants;
import org.nuxeo.ecm.platform.relations.web.NodeInfo;
import org.nuxeo.ecm.platform.relations.web.NodeInfoImpl;
import org.nuxeo.ecm.platform.relations.web.StatementInfo;
import org.nuxeo.ecm.platform.relations.web.StatementInfoComparator;
import org.nuxeo.ecm.platform.relations.web.StatementInfoImpl;
import org.nuxeo.ecm.platform.relations.web.listener.RelationActions;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.invalidations.AutomaticDocumentBasedInvalidation;
import org.nuxeo.ecm.platform.ui.web.invalidations.DocumentContextBoundActionBean;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.runtime.api.Framework;

@Name(value="customRelationActions")
@Scope(value=ScopeType.CONVERSATION)
@AutomaticDocumentBasedInvalidation
public class CustomRelationActions
extends DocumentContextBoundActionBean
implements RelationActions,
Serializable {
    private static final long serialVersionUID = 2336539966097558178L;
    private static final Log log = LogFactory.getLog(CustomRelationActions.class);
    protected static boolean includeStatementsInEvents = false;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected RelationManager relationManager;
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(required=false)
    protected transient Principal currentUser;
    protected List<Statement> incomingStatements;
    protected List<StatementInfo> incomingStatementsInfo;
    protected List<Statement> outgoingStatements;
    protected List<StatementInfo> outgoingStatementsInfo;
    protected String predicateUri;
    protected String objectType;
    protected String objectLiteralValue;
    protected String objectUri;
    protected String objectDocumentUid;
    protected String objectDocumentTitle;
    protected String comment;
    protected Boolean showCreateForm = false;
    protected List<DocumentModel> resultDocuments;
    protected boolean hasSearchResults = false;
    protected String searchKeywords;

    public DocumentModel getDocumentModel(Node node) throws ClientException {
        if (node.isQNameResource()) {
            QNameResource resource = (QNameResource)node;
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("CoreSession", this.documentManager.getSessionId());
            Serializable o = this.relationManager.getResourceRepresentation(resource.getNamespace(), (Resource)resource, context);
            if (o instanceof DocumentModel) {
                return (DocumentModel)o;
            }
        }
        return null;
    }

    @Deprecated
    private QNameResource getOldDocumentResource(DocumentModel document) {
        QNameResourceImpl documentResource = null;
        if (document != null) {
            documentResource = new QNameResourceImpl("http://www.nuxeo.org/document/uid/", document.getId());
        }
        return documentResource;
    }

    public QNameResource getDocumentResource(DocumentModel document) throws ClientException {
        QNameResource documentResource = null;
        if (document != null) {
            documentResource = (QNameResource)this.relationManager.getResource("http://www.nuxeo.org/document/uid/", (Serializable)document, null);
        }
        return documentResource;
    }

    protected List<StatementInfo> getStatementsInfo(List<Statement> statements) throws ClientException {
        if (statements == null) {
            return null;
        }
        ArrayList<StatementInfo> infoList = new ArrayList<StatementInfo>();
        for (Statement statement : statements) {
            Subject subject = statement.getSubject();
            NodeInfoImpl subjectInfo = new NodeInfoImpl((Node)subject, this.getDocumentModel((Node)subject), true);
            Resource predicate = statement.getPredicate();
            Node object = statement.getObject();
            NodeInfoImpl objectInfo = new NodeInfoImpl(object, this.getDocumentModel(object), true);
            StatementInfoImpl info = new StatementInfoImpl(statement, (NodeInfo)subjectInfo, (NodeInfo)new NodeInfoImpl((Node)predicate), (NodeInfo)objectInfo);
            infoList.add((StatementInfo)info);
        }
        return infoList;
    }

    public List<StatementInfo> getIncomingStatementsInfo() throws ClientException {
        if (this.incomingStatementsInfo != null) {
            return this.incomingStatementsInfo;
        }
        DocumentModel currentDoc = this.getCurrentDocument();
        QNameResource docResource = this.getDocumentResource(currentDoc);
        if (docResource == null) {
            this.incomingStatements = Collections.emptyList();
            this.incomingStatementsInfo = Collections.emptyList();
        } else {
            StatementImpl pattern = new StatementImpl(null, null, (Node)docResource);
            this.incomingStatements = this.relationManager.getStatements("default", (Statement)pattern);
            QNameResource oldDocResource = this.getOldDocumentResource(currentDoc);
            StatementImpl oldPattern = new StatementImpl(null, null, (Node)oldDocResource);
            this.incomingStatements.addAll(this.relationManager.getStatements("default", (Statement)oldPattern));
            this.incomingStatementsInfo = this.getStatementsInfo(this.incomingStatements);
            Comparator comp = Collections.reverseOrder(new StatementInfoComparator());
            Collections.sort(this.incomingStatementsInfo, comp);
        }
        return this.incomingStatementsInfo;
    }

    public List<StatementInfo> getOutgoingStatementsInfo() throws ClientException {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        return this.getOutgoingStatementsInfo(currentDoc);
    }

    public List<StatementInfo> getOutgoingStatementsInfo(DocumentModel currentDoc) throws ClientException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getOutgoingStatementsInfo :: currentDoc=" + currentDoc));
        }
        if (this.outgoingStatementsInfo != null) {
            return this.outgoingStatementsInfo;
        }
        QNameResource docResource = this.getDocumentResource(currentDoc);
        if (docResource == null) {
            this.outgoingStatements = Collections.emptyList();
            this.outgoingStatementsInfo = Collections.emptyList();
        } else {
            StatementImpl pattern = new StatementImpl((Node)docResource, null, null);
            this.outgoingStatements = this.relationManager.getStatements("default", (Statement)pattern);
            this.outgoingStatementsInfo = this.getStatementsInfo(this.outgoingStatements);
            Comparator comp = Collections.reverseOrder(new StatementInfoComparator());
            Collections.sort(this.outgoingStatementsInfo, comp);
        }
        return this.outgoingStatementsInfo;
    }

    public void resetStatements() {
        this.incomingStatements = null;
        this.incomingStatementsInfo = null;
        this.outgoingStatements = null;
        this.outgoingStatementsInfo = null;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getObjectDocumentTitle() {
        return this.objectDocumentTitle;
    }

    public void setObjectDocumentTitle(String objectDocumentTitle) {
        this.objectDocumentTitle = objectDocumentTitle;
    }

    public String getObjectDocumentUid() {
        return this.objectDocumentUid;
    }

    public void setObjectDocumentUid(String objectDocumentUid) {
        this.objectDocumentUid = objectDocumentUid;
    }

    public String getObjectLiteralValue() {
        return this.objectLiteralValue;
    }

    public void setObjectLiteralValue(String objectLiteralValue) {
        this.objectLiteralValue = objectLiteralValue;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public String getObjectUri() {
        return this.objectUri;
    }

    public void setObjectUri(String objectUri) {
        this.objectUri = objectUri;
    }

    public String getPredicateUri() {
        return this.predicateUri;
    }

    public void setPredicateUri(String predicateUri) {
        this.predicateUri = predicateUri;
    }

    protected void notifyEvent(String eventId, DocumentModel source, Map<String, Serializable> options, String comment) {
        EventProducer evtProducer = null;
        try {
            evtProducer = (EventProducer)Framework.getService(EventProducer.class);
        }
        catch (Exception e) {
            log.error((Object)"Unable to get EventProducer to send event notification", (Throwable)e);
        }
        DocumentEventContext docCtx = new DocumentEventContext(this.documentManager, this.documentManager.getPrincipal(), source);
        options.put("category", (Serializable)((Object)"relationNotificationCategory"));
        options.put("comment", (Serializable)((Object)comment));
        try {
            evtProducer.fireEvent(docCtx.newEvent(eventId));
        }
        catch (ClientException e) {
            log.error((Object)"Error while trying to send notification message", (Throwable)e);
        }
    }

    public String addStatement() throws ClientException {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        return this.addStatement(currentDoc);
    }

    public String addStatement(DocumentModel currentDoc) throws ClientException {
        StatementImpl stmt;
        QNameResource documentResource = this.getDocumentResource(currentDoc);
        if (documentResource == null) {
            throw new ClientException("Document resource could not be retrieved");
        }
        ResourceImpl predicate = new ResourceImpl(this.predicateUri);
        LiteralImpl object = null;
        if (this.objectType.equals("literal")) {
            this.objectLiteralValue = this.objectLiteralValue.trim();
            object = new LiteralImpl(this.objectLiteralValue);
        } else if (this.objectType.equals("uri")) {
            this.objectUri = this.objectUri.trim();
            object = new ResourceImpl(this.objectUri);
        } else if (this.objectType.equals("document")) {
            this.objectDocumentUid = this.objectDocumentUid.trim();
            String repositoryName = this.navigationContext.getCurrentServerLocation().getName();
            String localName = repositoryName + "/" + this.objectDocumentUid;
            object = new QNameResourceImpl("http://www.nuxeo.org/document/uid/", localName);
        }
        if (this.outgoingStatements == null) {
            this.getOutgoingStatementsInfo(currentDoc);
        }
        if (!this.outgoingStatements.contains(stmt = new StatementImpl((Node)documentResource, (Node)predicate, (Node)object))) {
            ArrayList<StatementImpl> stmts = new ArrayList<StatementImpl>();
            String eventComment = null;
            if (this.comment != null) {
                this.comment = this.comment.trim();
                if (this.comment.length() > 0) {
                    stmt.addProperty(RelationConstants.COMMENT, (Node)new LiteralImpl(this.comment));
                    eventComment = this.comment;
                }
            }
            Literal now = RelationDate.getLiteralDate((Date)new Date());
            stmt.addProperty(RelationConstants.CREATION_DATE, (Node)now);
            stmt.addProperty(RelationConstants.MODIFICATION_DATE, (Node)now);
            if (this.currentUser != null) {
                stmt.addProperty(RelationConstants.AUTHOR, (Node)new LiteralImpl(this.currentUser.getName()));
            }
            stmts.add(stmt);
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            String currentLifeCycleState = currentDoc.getCurrentLifeCycleState();
            options.put("documentLifeCycle", (Serializable)((Object)currentLifeCycleState));
            if (includeStatementsInEvents) {
                CustomRelationActions.putStatements(options, (Statement)stmt);
            }
            options.put("graph", (Serializable)((Object)"default"));
            this.notifyEvent("beforeRelationCreation", currentDoc, options, eventComment);
            this.relationManager.add("default", stmts);
            if (includeStatementsInEvents) {
                CustomRelationActions.putStatements(options, this.relationManager.getStatements("default", (Statement)stmt));
            }
            this.notifyEvent("afterRelationCreation", currentDoc, options, eventComment);
            this.resetStatements();
            this.resetCreateFormValues();
        } else {
            this.facesMessages.add(FacesMessage.SEVERITY_WARN, (String)this.resourcesAccessor.getMessages().get("label.relation.already.exists"), new Object[0]);
        }
        return "document_relations";
    }

    private static void putStatements(Map<String, Serializable> options, List<Statement> statements) {
        options.put("statements", (Serializable)((Object)statements));
    }

    private static void putStatements(Map<String, Serializable> options, Statement statement) {
        LinkedList<Statement> statements = new LinkedList<Statement>();
        statements.add(statement);
        options.put("statements", statements);
    }

    public void toggleCreateForm(ActionEvent event) {
        this.showCreateForm = this.showCreateForm == false;
    }

    private void resetCreateFormValues() {
        this.predicateUri = "";
        this.objectType = "";
        this.objectLiteralValue = "";
        this.objectUri = "";
        this.objectDocumentUid = "";
        this.objectDocumentTitle = "";
        this.comment = "";
        this.showCreateForm = false;
    }

    public String deleteStatement(StatementInfo stmtInfo, DocumentModel source) throws ClientException {
        if (stmtInfo != null && this.outgoingStatementsInfo != null && this.outgoingStatementsInfo.contains(stmtInfo)) {
            Statement stmt = stmtInfo.getStatement();
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            String currentLifeCycleState = source.getCurrentLifeCycleState();
            options.put("documentLifeCycle", (Serializable)((Object)currentLifeCycleState));
            options.put("graph", (Serializable)((Object)"default"));
            if (includeStatementsInEvents) {
                CustomRelationActions.putStatements(options, stmt);
            }
            this.notifyEvent("beforeRelationRemoval", source, options, null);
            ArrayList<Statement> stmts = new ArrayList<Statement>();
            stmts.add(stmt);
            this.relationManager.remove("default", stmts);
            this.notifyEvent("afterRelationRemoval", source, options, null);
            this.resetStatements();
            this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("label.relation.deleted"), new Object[0]);
        }
        return "document_relations";
    }

    public String deleteStatement(StatementInfo stmtInfo) throws ClientException {
        return this.deleteStatement(stmtInfo, this.getCurrentDocument());
    }

    public String getSearchKeywords() {
        return this.searchKeywords;
    }

    public void setSearchKeywords(String searchKeywords) {
        this.searchKeywords = searchKeywords;
    }

    public String searchDocuments() throws ClientException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Making call to get documents list for keywords: " + this.searchKeywords));
        }
        this.resultDocuments = null;
        ArrayList<String> constraints = new ArrayList<String>();
        if (this.searchKeywords != null) {
            this.searchKeywords = this.searchKeywords.trim();
            if (this.searchKeywords.length() > 0 && !this.searchKeywords.equals("*")) {
                constraints.add(String.format("ecm:fulltext LIKE '%s'", this.searchKeywords));
            }
        }
        constraints.add("ecm:mixinType != 'Folderish'");
        constraints.add("ecm:mixinType != 'HiddenInNavigation'");
        constraints.add("ecm:isCheckedInVersion = 0");
        DocumentModel currentDocument = this.getCurrentDocument();
        if (currentDocument != null) {
            constraints.add(String.format("ecm:uuid != '%s'", currentDocument.getId()));
        }
        String query = String.format("SELECT * FROM Document WHERE %s", StringUtils.join((Object[])constraints.toArray(), (String)" AND "));
        if (log.isDebugEnabled()) {
            log.debug((Object)("query: " + query));
        }
        this.resultDocuments = this.documentManager.query(query, 100);
        boolean bl = this.hasSearchResults = !this.resultDocuments.isEmpty();
        if (log.isDebugEnabled()) {
            log.debug((Object)("query result contains: " + this.resultDocuments.size() + " docs."));
        }
        return "create_relation_search_document";
    }

    public List<DocumentModel> getSearchDocumentResults() {
        return this.resultDocuments;
    }

    public boolean getHasSearchResults() {
        return this.hasSearchResults;
    }

    public Boolean getShowCreateForm() {
        return this.showCreateForm;
    }

    public void initialize() {
        log.debug((Object)"Initializing...");
    }

    @Destroy
    @Remove
    public void destroy() {
        log.debug((Object)"Removing Seam action listener...");
    }

    @PrePassivate
    public void saveState() {
        log.debug((Object)"PrePassivate");
    }

    @PostActivate
    public void readState() {
        log.debug((Object)"PostActivate");
    }

    protected void resetBeanCache(DocumentModel newCurrentDocumentModel) {
        this.resetStatements();
    }
}

