/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.esupecm.webapp.action;

import java.io.Serializable;
import java.security.Principal;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="userRpn")
public class UserRPNActions {
    public static final String RPN_PATH_KEY = "rpn.path";
    @In
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient FacesMessages facesMessages;
    @In
    protected transient Principal currentUser;
    @In
    protected transient UserManager userManager;
    @In(required=false)
    protected transient NavigationContext navigationContext;
    protected boolean checked = false;

    @Observer(value={"navigateToDocument"})
    public void createUserRpn() throws ClientException {
        NuxeoPrincipal nxp;
        String userDocName;
        String userDocPath;
        final String rpnPath = Framework.getProperty((String)RPN_PATH_KEY, (String)"/default-domain/workspaces/Ressources p\u00e9dagogique n");
        if (this.checked || this.navigationContext == null || "system".equals(this.currentUser.getName()) || StringUtils.isBlank((String)rpnPath)) {
            return;
        }
        this.checked = true;
        if (this.documentManager.exists((DocumentRef)new PathRef(rpnPath)) && !this.documentManager.exists((DocumentRef)new PathRef(userDocPath = String.format("%s/%s", rpnPath, userDocName = String.format("%s", (nxp = (NuxeoPrincipal)this.currentUser).getName()))))) {
            new UnrestrictedSessionRunner(this.documentManager){

                public void run() throws ClientException {
                    DocumentModel folder = this.session.createDocumentModel(rpnPath, userDocName, "Folder");
                    String dcTitle = nxp.getName();
                    if (!StringUtils.isBlank((String)(nxp.getFirstName() + nxp.getLastName()))) {
                        dcTitle = String.format("%s_%s", nxp.getFirstName(), nxp.getLastName());
                    }
                    folder.setPropertyValue("dc:title", (Serializable)((Object)dcTitle));
                    folder = this.session.createDocument(folder);
                    ACP acp = this.session.getACP(folder.getRef());
                    ACL local = acp.getOrCreateACL("local");
                    local.add((Object)new ACE(nxp.getName(), "ReadWrite", true));
                    local.add((Object)new ACE("Everyone", "Everything", false));
                    this.session.setACP(folder.getRef(), acp, true);
                }
            }.runUnrestricted();
        }
    }
}

