/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef.msg;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.freeutils.tnef.Attachment;
import net.freeutils.tnef.Attr;
import net.freeutils.tnef.GUID;
import net.freeutils.tnef.MAPIProp;
import net.freeutils.tnef.MAPIPropName;
import net.freeutils.tnef.MAPIProps;
import net.freeutils.tnef.MAPIValue;
import net.freeutils.tnef.Message;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEF;
import net.freeutils.tnef.TNEFUtils;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class Msg {
    static final GUID PS_PUBLIC_STRINGS = new GUID("00020329-0000-0000-c000-000000000046");

    public static void printDirectory(DirectoryEntry dir, String linePrefix) throws IOException {
        Iterator iter = dir.getEntries();
        while (iter.hasNext()) {
            Entry entry = (Entry)iter.next();
            String name = entry.getName();
            if (entry instanceof DirectoryEntry) {
                DirectoryEntry de = (DirectoryEntry)entry;
                System.out.println(linePrefix + name + "/");
                Msg.printDirectory(de, linePrefix + "  ");
                continue;
            }
            if (entry instanceof DocumentEntry) {
                System.out.println(linePrefix + name + "  " + Msg.toRawInputStream((DocumentEntry)entry));
                continue;
            }
            System.out.println(linePrefix + name + " (UNKNOWN entry type)");
        }
    }

    public static Message processMessage(DirectoryEntry dir) throws IOException {
        return Msg.processMessage(dir, null);
    }

    protected static Message processMessage(DirectoryEntry dir, Map names) throws IOException {
        Properties properties = Msg.processProperties(dir, names);
        if (properties.isRootMessage) {
            names = Msg.processNameIDs(dir);
            Msg.translateNames(properties.props, names);
        }
        Message message = new Message();
        MAPIProps mapiProps = new MAPIProps(properties.props.toArray(new MAPIProp[properties.props.size()]));
        message.addAttribute(new Attr(1, 6, 36867, mapiProps));
        MAPIProps[] recipients = Msg.processRecipients(dir, properties.recipientCount, names);
        message.addAttribute(new Attr(1, 6, 36868, recipients));
        List attachments = Msg.processAttachments(dir, properties.attachmentCount, names);
        message.setAttachments(attachments);
        return message;
    }

    protected static void translateNames(List props, Map names) {
        if (names != null) {
            Iterator it = props.iterator();
            while (it.hasNext()) {
                MAPIProp prop = (MAPIProp)it.next();
                MAPIPropName name = (MAPIPropName)names.get(new Integer(prop.getID()));
                if (name == null) continue;
                prop.setName(name);
            }
        }
    }

    protected static MAPIProps[] processRecipients(DirectoryEntry dir, int recipientCount, Map names) throws IOException {
        MAPIProps[] recipients = new MAPIProps[recipientCount];
        for (int i = 0; i < recipientCount; ++i) {
            String entryName = "__recip_version1.0_#" + Msg.toHexString(i);
            Entry entry = dir.getEntry(entryName);
            Properties properties = Msg.processProperties((DirectoryEntry)entry, names);
            MAPIProp[] props = properties.props.toArray(new MAPIProp[properties.props.size()]);
            recipients[i] = new MAPIProps(props);
        }
        return recipients;
    }

    protected static List processAttachments(DirectoryEntry dir, int attachmentCount, Map names) throws IOException {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        for (int i = 0; i < attachmentCount; ++i) {
            String entryName = "__attach_version1.0_#" + Msg.toHexString(i);
            Entry entry = dir.getEntry(entryName);
            Attachment attachment = Msg.processAttachment((DirectoryEntry)entry, names);
            attachments.add(attachment);
        }
        return attachments;
    }

    protected static Attachment processAttachment(DirectoryEntry dir, Map names) throws IOException {
        Properties properties = Msg.processProperties(dir, names);
        MAPIProp[] props = properties.props.toArray(new MAPIProp[properties.props.size()]);
        Attachment att = new Attachment();
        att.setMAPIProps(new MAPIProps(props));
        try {
            Entry entry = dir.getEntry("__substg1.0_3701000D");
            att.setNestedMessage(Msg.processMessage((DirectoryEntry)entry, names));
        }
        catch (FileNotFoundException fnfe) {
            // empty catch block
        }
        return att;
    }

    protected static Properties processProperties(DirectoryEntry dir, Map names) throws IOException {
        Properties properties = new Properties();
        Entry entry = dir.getEntry("__properties_version1.0");
        RawInputStream data = Msg.toRawInputStream((DocumentEntry)entry);
        int headerSize = 0;
        RawInputStream header = (RawInputStream)data.newStream(0L, 32L);
        while (header.available() >= 4 && (header.readU32() >> 16 & 0xFFFFL) == 0L) {
            headerSize += 4;
        }
        header.close();
        if (headerSize < 8) {
            throw new IOException("Unknown header format " + data.newStream(0L, headerSize));
        }
        if (data.readU32() != 0L || data.readU32() != 0L) {
            throw new IOException("Unknown header format " + data.newStream(0L, headerSize));
        }
        if (headerSize > 8) {
            if (headerSize < 24) {
                throw new IOException("Unknown header format " + data.newStream(0L, headerSize));
            }
            properties.recipientCount = (int)data.readU32();
            properties.attachmentCount = (int)data.readU32();
            if (data.readU32() != (long)properties.recipientCount || data.readU32() != (long)properties.attachmentCount) {
                throw new IOException("Unknown header format " + data.newStream(0L, headerSize));
            }
        }
        if (headerSize > 24) {
            if (headerSize < 32) {
                throw new IOException("Unknown header format " + data.newStream(0L, headerSize));
            }
            if (data.readU32() != 0L || data.readU32() != 0L) {
                throw new IOException("Unknown header format " + data.newStream(0L, headerSize));
            }
            properties.isRootMessage = true;
        }
        if (headerSize > 32) {
            throw new IOException("Unknown header format " + data.newStream(0L, headerSize));
        }
        properties.props = Msg.processPropertyList(data);
        data.close();
        properties.props.addAll(Msg.processPropEntries(dir));
        Msg.translateNames(properties.props, names);
        return properties;
    }

    protected static List processPropertyList(RawInputStream data) throws IOException {
        ArrayList<MAPIProp> props = new ArrayList<MAPIProp>();
        while (data.available() > 0) {
            int typeAndId = (int)data.readU32();
            int type = typeAndId & 0xFFFF;
            int id = typeAndId >> 16 & 0xFFFF;
            data.readU32();
            MAPIValue val = null;
            int vlen = 0;
            switch (type) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 10: 
                case 11: {
                    val = new MAPIValue(type, data, 4);
                    data.readU32();
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 20: 
                case 64: {
                    val = new MAPIValue(type, data, 8);
                    break;
                }
                case 13: 
                case 30: 
                case 31: 
                case 72: 
                case 258: {
                    vlen = (int)data.readU32();
                    data.readU32();
                    break;
                }
                default: {
                    throw new IOException("Unknown MAPI type: 0x" + Integer.toHexString(type));
                }
            }
            if (val == null) continue;
            props.add(new MAPIProp(type, id, new MAPIValue[]{val}));
        }
        return props;
    }

    protected static Map processNameIDs(DirectoryEntry dir) throws IOException {
        DirectoryEntry entry = (DirectoryEntry)dir.getEntry("__nameid_version1.0");
        HashMap<Integer, MAPIPropName> names = new HashMap<Integer, MAPIPropName>();
        MAPIProp guidsProp = Msg.processProperty((DocumentEntry)entry.getEntry("__substg1.0_00020102"));
        RawInputStream guidsData = (RawInputStream)guidsProp.getValue();
        ArrayList<GUID> guids = new ArrayList<GUID>();
        guids.add(PS_PUBLIC_STRINGS);
        guids.add(PS_PUBLIC_STRINGS);
        guids.add(PS_PUBLIC_STRINGS);
        while (guidsData.available() > 0) {
            guids.add(new GUID(guidsData.readBytes(16)));
        }
        MAPIProp namesProp = Msg.processProperty((DocumentEntry)entry.getEntry("__substg1.0_00040102"));
        byte[] namesData = ((RawInputStream)namesProp.getValue()).toByteArray();
        MAPIProp propsProp = Msg.processProperty((DocumentEntry)entry.getEntry("__substg1.0_00030102"));
        RawInputStream propsData = (RawInputStream)propsProp.getValue();
        while (propsData.available() > 0) {
            MAPIPropName propName;
            byte[] b = propsData.readBytes(8);
            int flags = TNEFUtils.getU16(b, 4);
            int num = TNEFUtils.getU16(b, 6);
            int tempid = 32768 + num;
            GUID guid = (GUID)guids.get(flags >> 1);
            if ((flags & 1) != 0) {
                int offset = (int)TNEFUtils.getU32(b, 0);
                int len = (int)TNEFUtils.getU32(namesData, offset);
                String nameStr = TNEFUtils.createStringUnicode(namesData, offset + 4, len);
                propName = new MAPIPropName(guid, nameStr);
            } else {
                int id = TNEFUtils.getU16(b, 0);
                propName = new MAPIPropName(guid, id);
            }
            names.put(new Integer(tempid), propName);
        }
        return names;
    }

    protected static List processPropEntries(DirectoryEntry dir) throws IOException {
        ArrayList<MAPIProp> props = new ArrayList<MAPIProp>();
        Iterator iter = dir.getEntries();
        while (iter.hasNext()) {
            Entry entry = (Entry)iter.next();
            if (!(entry instanceof DocumentEntry) || !entry.getName().startsWith("__substg1.0_")) continue;
            props.add(Msg.processProperty((DocumentEntry)entry));
        }
        return props;
    }

    protected static MAPIProp processProperty(DocumentEntry entry) throws IOException {
        String name = entry.getName();
        int id = Integer.parseInt(name.substring(12, 16), 16);
        int type = Integer.parseInt(name.substring(16, 20), 16);
        RawInputStream data = Msg.toRawInputStream(entry);
        MAPIValue val = new MAPIValue(type, data, (int)data.getLength());
        MAPIProp prop = new MAPIProp(type, id, new MAPIValue[]{val});
        data.close();
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static RawInputStream toRawInputStream(DocumentEntry entry) throws IOException {
        DocumentInputStream dis = new DocumentInputStream(entry);
        ByteArrayOutputStream bais = new ByteArrayOutputStream(dis.available());
        try {
            int count;
            byte[] bytes = new byte[4096];
            while ((count = dis.read(bytes)) > -1) {
                bais.write(bytes, 0, count);
            }
        }
        finally {
            dis.close();
        }
        return new RawInputStream(bais.toByteArray());
    }

    protected static String toHexString(int i) {
        String s = Integer.toHexString(i).toUpperCase();
        while (s.length() < 8) {
            s = "0" + s;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String filename = args[0];
        String outputdir = args[1];
        FileInputStream in = null;
        try {
            in = new FileInputStream(filename);
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)in);
            DirectoryEntry root = fs.getRoot();
            Message message = Msg.processMessage(root);
            TNEF.extractContent(message, outputdir);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    protected static class Properties {
        List props;
        int recipientCount;
        int attachmentCount;
        boolean isRootMessage;

        protected Properties() {
        }
    }
}

