/*
 * Decompiled with CFR 0.152.
 */
package com.sword.plugin.converter;

import com.auxilii.msgparser.Message;
import com.auxilii.msgparser.MsgParser;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;

public class ConverterMsg2Text
implements Converter {
    private static final Log log = LogFactory.getLog(ConverterMsg2Text.class);

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        try {
            String USER_TEMP = System.getProperty("java.io.tmpdir");
            Message msg = null;
            try {
                blobHolder.getBlob().transferTo(new File(USER_TEMP + "\\converterMsg2Txt.conv"));
                MsgParser msgp = new MsgParser();
                msg = msgp.parseMsg(USER_TEMP + "\\converterMsg2Txt.conv");
            }
            catch (IOException e1) {
                log.error((Object)e1.toString());
            }
            String text = msg.toString() + msg.getBodyText();
            return new SimpleCachableBlobHolder((Blob)new StringBlob(text, "text/plain"));
        }
        catch (Exception e) {
            log.error((Object)"Error during Msg2Txt conversion", (Throwable)e);
            throw new ConversionException("Error during XML2Text conversion", e);
        }
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

