/*
 * Decompiled with CFR 0.152.
 */
package com.sword.plugin.restAPI;

import com.sword.plugin.filemanager.MailImporter;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseNuxeoRestlet;
import org.nuxeo.ecm.platform.ui.web.tag.fn.LiveEditConstants;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.restlet.data.Request;
import org.restlet.data.Response;

@Name(value="uploadAttachedRestlet")
@Scope(value=ScopeType.EVENT)
public class UploadAttachedRestlet
extends BaseNuxeoRestlet
implements LiveEditConstants,
Serializable {
    static Logger logger = Logger.getLogger(MailImporter.class);
    private static final long serialVersionUID = -1040032183387976635L;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    protected CoreSession documentManager;

    public void handle(Request req, Response res) {
        String repo = (String)req.getAttributes().get("repo");
        String docid = (String)req.getAttributes().get("docid");
        String filename = (String)req.getAttributes().get("filename");
        try {
            filename = URLDecoder.decode(filename, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            UploadAttachedRestlet.handleError((Response)res, (Exception)e);
            return;
        }
        if (repo == null || repo.equals("*")) {
            UploadAttachedRestlet.handleError((Response)res, (String)"you must specify a repository");
            return;
        }
        DocumentModel dm = null;
        try {
            this.navigationContext.setCurrentServerLocation(new RepositoryLocation(repo));
            this.documentManager = this.navigationContext.getOrCreateDocumentManager();
            if (docid != null) {
                dm = this.documentManager.getDocument((DocumentRef)new IdRef(docid));
            }
        }
        catch (ClientException e) {
            UploadAttachedRestlet.handleError((Response)res, (Exception)((Object)e));
            return;
        }
        try {
            Blob blob = StreamingBlob.createFromStream((InputStream)req.getEntity().getStream()).persist();
            blob.setFilename(filename);
            ArrayList files = (ArrayList)dm.getProperty("files", "files");
            if (files == null) {
                files = new ArrayList(1);
            }
            HashMap<String, String> f = new HashMap<String, String>();
            f.put("filename", filename);
            f.put("file", (String)blob);
            files.add(f);
            dm.setProperty("files", "files", files);
            this.documentManager.saveDocument(dm);
            this.documentManager.save();
        }
        catch (Exception e) {
            UploadAttachedRestlet.handleError((Response)res, (Exception)e);
        }
    }
}

