/*
 * Decompiled with CFR 0.152.
 */
package com.sword.plugin.filemanager;

import com.auxilii.msgparser.Message;
import com.auxilii.msgparser.MsgParser;
import com.auxilii.msgparser.RecipientEntry;
import com.auxilii.msgparser.attachment.Attachment;
import com.auxilii.msgparser.attachment.FileAttachment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.api.localconfiguration.LocalConfigurationService;
import org.nuxeo.ecm.platform.filemanager.service.FileManagerService;
import org.nuxeo.ecm.platform.filemanager.service.extension.DefaultFileImporter;
import org.nuxeo.ecm.platform.filemanager.utils.FileManagerUtils;
import org.nuxeo.ecm.platform.mimetype.MimetypeDetectionException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.types.localconfiguration.UITypesConfiguration;
import org.nuxeo.runtime.api.Framework;

public class MailImporter
extends DefaultFileImporter {
    private static final Logger logger = Logger.getLogger(MailImporter.class);
    public static final String TYPE_NAME = "MailMessage";
    private static final String TITLE_FIELD = "title";
    private static final String DESCRIPTION_FIELD = "text";
    private static final String DUBLINCORE_SCHEMA = "dublincore";
    private static final String MAIL_SCHEMA = "mail";
    private static final String MAIL_TYPE = "MailMessage";
    private static final String SUBJECT_FIELD = "messageId";
    private static final String FROM_FIELD = "sender";
    private static final String TO_FIELD = "recipients";
    private static final String CC_FIELD = "cc_recipients";
    private static final String DATE_FIELD = "sending_date";
    protected FileManagerService fileManagerService;

    public DocumentModel create(CoreSession documentManager, Blob content, String path, boolean overwrite, String fullname, TypeManager typeService) throws ClientException, IOException {
        path = this.getNearestContainerPath(documentManager, path);
        String filename = FileManagerUtils.fetchFileName((String)fullname);
        String title = FileManagerUtils.fetchTitle((String)filename).substring(0, filename.length() - 4);
        content.getFilename();
        String USER_TEMP = System.getProperty("java.io.tmpdir");
        logger.warn((Object)USER_TEMP);
        content.transferTo(new File(USER_TEMP + "\\" + filename));
        MsgParser msgp = new MsgParser();
        Message msg = msgp.parseMsg(USER_TEMP + "\\" + filename);
        String fromName = msg.getFromName();
        String subject = msg.getSubject();
        ArrayList<String> recipients = new ArrayList<String>();
        for (int i = 0; i < msg.getRecipients().size(); ++i) {
            recipients.add(((RecipientEntry)msg.getRecipients().get(i)).getToName());
        }
        ArrayList<String> recipientsCC = new ArrayList<String>();
        if (msg.getDisplayCc() != null) {
            recipientsCC.add(msg.getDisplayCc());
        }
        Date date = msg.getDate();
        String body = msg.getBodyText();
        int iMaxSize = body.length() < 65000 ? body.length() - 1 : 1000;
        String description = body.substring(0, iMaxSize);
        String docId = IdUtils.generateStringId();
        DocumentModel docModel = documentManager.createDocumentModel(path, docId, "MailMessage");
        docModel.setProperty(DUBLINCORE_SCHEMA, TITLE_FIELD, (Object)title);
        docModel.setProperty(MAIL_SCHEMA, SUBJECT_FIELD, (Object)subject);
        docModel.setProperty(MAIL_SCHEMA, FROM_FIELD, (Object)fromName);
        docModel.setProperty(MAIL_SCHEMA, TO_FIELD, recipients);
        docModel.setProperty(MAIL_SCHEMA, CC_FIELD, recipientsCC);
        docModel.setProperty(MAIL_SCHEMA, DATE_FIELD, (Object)date);
        docModel.setProperty(MAIL_SCHEMA, DESCRIPTION_FIELD, (Object)description);
        docModel.setProperty(MAIL_SCHEMA, "htmlText", (Object)description);
        docModel = documentManager.createDocument(docModel);
        documentManager.save();
        FileAttachment file = null;
        Blob blob = null;
        List atts = msg.getAttachments();
        ArrayList files = new ArrayList(atts.size() + 1);
        HashMap<String, String> f = new HashMap<String, String>();
        f.put("filename", filename);
        f.put("file", (String)content);
        files.add(f);
        docModel.setProperty("files", "files", files);
        if (atts.size() > 0) {
            f = null;
            for (Attachment att : atts) {
                if (!(att instanceof FileAttachment)) continue;
                file = (FileAttachment)att;
                String attachFileName = file.getFilename();
                logger.info((Object)("Attachment : " + attachFileName));
                byte[] data = file.getData();
                blob = StreamingBlob.createFromByteArray((byte[])data, (String)this.getMimeType(attachFileName)).persist();
                blob.setFilename(filename);
                f = new HashMap();
                f.put("filename", attachFileName);
                f.put("file", (String)blob);
                files.add(f);
                docModel.setProperty("files", "files", files);
                logger.info((Object)("Creation of attached file " + attachFileName + " OK!"));
            }
        }
        documentManager.saveDocument(docModel);
        documentManager.save();
        return docModel;
    }

    public String getMimeType(String fileName) {
        String mimeType = fileName.endsWith(".pdf") ? "application/pdf" : (fileName.endsWith(".doc") ? "application/msword" : (fileName.endsWith(".ppt") ? "application/vnd.ms-powerpoint" : (fileName.endsWith(".xls") ? "application/vnd.ms-excel" : (fileName.endsWith(".xml") ? "text/xml" : (fileName.endsWith(".jpg") || fileName.endsWith(".jpeg") || fileName.endsWith(".jpe") ? "image/jpeg" : (fileName.endsWith(".png") ? "image/png" : (fileName.endsWith(".gif") ? "image/gif" : "text/plain")))))));
        return mimeType;
    }

    protected static UITypesConfiguration getConfiguration(DocumentModel currentDoc) {
        UITypesConfiguration configuration = null;
        try {
            LocalConfigurationService localConfigurationService = (LocalConfigurationService)Framework.getService(LocalConfigurationService.class);
            configuration = (UITypesConfiguration)localConfigurationService.getConfiguration(UITypesConfiguration.class, "UITypesLocalConfiguration", currentDoc);
        }
        catch (Exception e) {
            logger.error((Object)"Get configuration error", (Throwable)e);
        }
        return configuration;
    }

    protected Blob updateMimeType(Blob input, String filename) {
        MimetypeRegistry mtr = null;
        try {
            mtr = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
            input = mtr.updateMimetype(input, filename);
        }
        catch (MimetypeDetectionException e1) {
            logger.error((Object)"Can't update the Mimetype", (Throwable)e1);
        }
        catch (Exception e2) {
            logger.error((Object)"An exception occured during the recuperation of the MimeType Service", (Throwable)e2);
        }
        return input;
    }
}

