/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.photoroom.client.api;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import okhttp3.Call;
import org.nuxeo.labs.photoroom.client.ApiCallback;
import org.nuxeo.labs.photoroom.client.ApiClient;
import org.nuxeo.labs.photoroom.client.ApiException;
import org.nuxeo.labs.photoroom.client.ApiResponse;
import org.nuxeo.labs.photoroom.client.Configuration;
import org.nuxeo.labs.photoroom.client.Pair;
import org.nuxeo.labs.photoroom.model.AccountDetails200Response;
import org.nuxeo.labs.photoroom.model.V2EditGetBackgroundExpandPromptParameter;
import org.nuxeo.labs.photoroom.model.V2EditGetMarginBottomParameter;
import org.nuxeo.labs.photoroom.model.V2EditGetMarginParameter;
import org.nuxeo.labs.photoroom.model.V2EditPostRequestMargin;
import org.nuxeo.labs.photoroom.model.V2EditPostRequestMarginBottom;
import org.nuxeo.labs.photoroom.model.V2EditPostRequestMarginLeft;
import org.nuxeo.labs.photoroom.model.V2EditPostRequestMarginRight;
import org.nuxeo.labs.photoroom.model.V2EditPostRequestMarginTop;
import org.nuxeo.labs.photoroom.model.V2EditPostRequestPadding;
import org.nuxeo.labs.photoroom.model.V2EditPostRequestPaddingBottom;
import org.nuxeo.labs.photoroom.model.V2EditPostRequestPaddingLeft;
import org.nuxeo.labs.photoroom.model.V2EditPostRequestPaddingRight;
import org.nuxeo.labs.photoroom.model.V2EditPostRequestPaddingTop;

public class DefaultApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DefaultApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DefaultApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call accountDetailsCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{"https://image-api.photoroom.com"};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/account";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"x-api-key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call accountDetailsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.accountDetailsCall(_callback);
    }

    public AccountDetails200Response accountDetails() throws ApiException {
        ApiResponse<AccountDetails200Response> localVarResp = this.accountDetailsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<AccountDetails200Response> accountDetailsWithHttpInfo() throws ApiException {
        Call localVarCall = this.accountDetailsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<AccountDetails200Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call accountDetailsAsync(ApiCallback<AccountDetails200Response> _callback) throws ApiException {
        Call localVarCall = this.accountDetailsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<AccountDetails200Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call editImageGetCall(String templateId, String apiKey, URI imageUrl, URI conceptUrl, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{"https://image-api.photoroom.com"};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/render";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (apiKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("apiKey", apiKey));
        }
        if (templateId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("templateId", templateId));
        }
        if (imageUrl != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("imageUrl", imageUrl));
        }
        if (conceptUrl != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("conceptUrl", conceptUrl));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"image/png", "application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"x-api-key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call editImageGetValidateBeforeCall(String templateId, String apiKey, URI imageUrl, URI conceptUrl, ApiCallback _callback) throws ApiException {
        if (templateId == null) {
            throw new ApiException("Missing the required parameter 'templateId' when calling editImageGet(Async)");
        }
        return this.editImageGetCall(templateId, apiKey, imageUrl, conceptUrl, _callback);
    }

    public File editImageGet(String templateId, String apiKey, URI imageUrl, URI conceptUrl) throws ApiException {
        ApiResponse<File> localVarResp = this.editImageGetWithHttpInfo(templateId, apiKey, imageUrl, conceptUrl);
        return localVarResp.getData();
    }

    public ApiResponse<File> editImageGetWithHttpInfo(String templateId, String apiKey, URI imageUrl, URI conceptUrl) throws ApiException {
        Call localVarCall = this.editImageGetValidateBeforeCall(templateId, apiKey, imageUrl, conceptUrl, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call editImageGetAsync(String templateId, String apiKey, URI imageUrl, URI conceptUrl, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.editImageGetValidateBeforeCall(templateId, apiKey, imageUrl, conceptUrl, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call editImagePostCall(String templateId, File imageFile, URI imageUrl, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{"https://image-api.photoroom.com"};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/render";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (templateId != null) {
            localVarFormParams.put("templateId", templateId);
        }
        if (imageFile != null) {
            localVarFormParams.put("imageFile", imageFile);
        }
        if (imageUrl != null) {
            localVarFormParams.put("imageUrl", imageUrl);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"image/png", "application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"x-api-key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call editImagePostValidateBeforeCall(String templateId, File imageFile, URI imageUrl, ApiCallback _callback) throws ApiException {
        if (templateId == null) {
            throw new ApiException("Missing the required parameter 'templateId' when calling editImagePost(Async)");
        }
        return this.editImagePostCall(templateId, imageFile, imageUrl, _callback);
    }

    public File editImagePost(String templateId, File imageFile, URI imageUrl) throws ApiException {
        ApiResponse<File> localVarResp = this.editImagePostWithHttpInfo(templateId, imageFile, imageUrl);
        return localVarResp.getData();
    }

    public ApiResponse<File> editImagePostWithHttpInfo(String templateId, File imageFile, URI imageUrl) throws ApiException {
        Call localVarCall = this.editImagePostValidateBeforeCall(templateId, imageFile, imageUrl, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call editImagePostAsync(String templateId, File imageFile, URI imageUrl, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.editImagePostValidateBeforeCall(templateId, imageFile, imageUrl, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call removeBackgroundCall(File imageFile, String format, String channels, String bgColor, String size, String crop, String despill, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{"https://sdk.photoroom.com"};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/segment";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (imageFile != null) {
            localVarFormParams.put("image_file", imageFile);
        }
        if (format != null) {
            localVarFormParams.put("format", format);
        }
        if (channels != null) {
            localVarFormParams.put("channels", channels);
        }
        if (bgColor != null) {
            localVarFormParams.put("bg_color", bgColor);
        }
        if (size != null) {
            localVarFormParams.put("size", size);
        }
        if (crop != null) {
            localVarFormParams.put("crop", crop);
        }
        if (despill != null) {
            localVarFormParams.put("despill", despill);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"image/png", "application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"x-api-key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call removeBackgroundValidateBeforeCall(File imageFile, String format, String channels, String bgColor, String size, String crop, String despill, ApiCallback _callback) throws ApiException {
        return this.removeBackgroundCall(imageFile, format, channels, bgColor, size, crop, despill, _callback);
    }

    public File removeBackground(File imageFile, String format, String channels, String bgColor, String size, String crop, String despill) throws ApiException {
        ApiResponse<File> localVarResp = this.removeBackgroundWithHttpInfo(imageFile, format, channels, bgColor, size, crop, despill);
        return localVarResp.getData();
    }

    public ApiResponse<File> removeBackgroundWithHttpInfo(File imageFile, String format, String channels, String bgColor, String size, String crop, String despill) throws ApiException {
        Call localVarCall = this.removeBackgroundValidateBeforeCall(imageFile, format, channels, bgColor, size, crop, despill, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call removeBackgroundAsync(File imageFile, String format, String channels, String bgColor, String size, String crop, String despill, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.removeBackgroundValidateBeforeCall(imageFile, format, channels, bgColor, size, crop, despill, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call v2EditGetCall(String backgroundColor, V2EditGetBackgroundExpandPromptParameter backgroundExpandPrompt, File backgroundGuidanceImageFile, String backgroundGuidanceImageUrl, BigDecimal backgroundGuidanceScale, String backgroundImageUrl, String backgroundNegativePrompt, String backgroundPrompt, String backgroundScaling, BigDecimal backgroundSeed, String expandMode, BigDecimal expandSeed, String exportFormat, String horizontalAlignment, Boolean ignorePaddingAndSnapOnCroppedSides, String imageUrl, String lightingMode, V2EditGetMarginParameter margin, V2EditGetMarginBottomParameter marginBottom, V2EditGetMarginBottomParameter marginLeft, V2EditGetMarginBottomParameter marginRight, V2EditGetMarginBottomParameter marginTop, BigDecimal maxHeight, BigDecimal maxWidth, String outputSize, V2EditGetMarginParameter padding, V2EditGetMarginBottomParameter paddingBottom, V2EditGetMarginBottomParameter paddingLeft, V2EditGetMarginBottomParameter paddingRight, V2EditGetMarginBottomParameter paddingTop, String referenceBox, Boolean removeBackground, String scaling, String shadowMode, UUID templateId, String textRemovalMode, String upscaleMode, String verticalAlignment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{"https://image-api.photoroom.com"};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/edit";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (backgroundColor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("background.color", backgroundColor));
        }
        if (backgroundExpandPrompt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("background.expandPrompt", backgroundExpandPrompt));
        }
        if (backgroundGuidanceImageFile != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("background.guidance.imageFile", backgroundGuidanceImageFile));
        }
        if (backgroundGuidanceImageUrl != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("background.guidance.imageUrl", backgroundGuidanceImageUrl));
        }
        if (backgroundGuidanceScale != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("background.guidance.scale", backgroundGuidanceScale));
        }
        if (backgroundImageUrl != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("background.imageUrl", backgroundImageUrl));
        }
        if (backgroundNegativePrompt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("background.negativePrompt", backgroundNegativePrompt));
        }
        if (backgroundPrompt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("background.prompt", backgroundPrompt));
        }
        if (backgroundScaling != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("background.scaling", backgroundScaling));
        }
        if (backgroundSeed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("background.seed", backgroundSeed));
        }
        if (expandMode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand.mode", expandMode));
        }
        if (expandSeed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand.seed", expandSeed));
        }
        if (exportFormat != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("export.format", exportFormat));
        }
        if (horizontalAlignment != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("horizontalAlignment", horizontalAlignment));
        }
        if (ignorePaddingAndSnapOnCroppedSides != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignorePaddingAndSnapOnCroppedSides", ignorePaddingAndSnapOnCroppedSides));
        }
        if (imageUrl != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("imageUrl", imageUrl));
        }
        if (lightingMode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("lighting.mode", lightingMode));
        }
        if (margin != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("margin", margin));
        }
        if (marginBottom != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("marginBottom", marginBottom));
        }
        if (marginLeft != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("marginLeft", marginLeft));
        }
        if (marginRight != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("marginRight", marginRight));
        }
        if (marginTop != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("marginTop", marginTop));
        }
        if (maxHeight != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxHeight", maxHeight));
        }
        if (maxWidth != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxWidth", maxWidth));
        }
        if (outputSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("outputSize", outputSize));
        }
        if (padding != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("padding", padding));
        }
        if (paddingBottom != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("paddingBottom", paddingBottom));
        }
        if (paddingLeft != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("paddingLeft", paddingLeft));
        }
        if (paddingRight != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("paddingRight", paddingRight));
        }
        if (paddingTop != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("paddingTop", paddingTop));
        }
        if (referenceBox != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("referenceBox", referenceBox));
        }
        if (removeBackground != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("removeBackground", removeBackground));
        }
        if (scaling != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("scaling", scaling));
        }
        if (shadowMode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shadow.mode", shadowMode));
        }
        if (templateId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("templateId", templateId));
        }
        if (textRemovalMode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("textRemoval.mode", textRemovalMode));
        }
        if (upscaleMode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("upscale.mode", upscaleMode));
        }
        if (verticalAlignment != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("verticalAlignment", verticalAlignment));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"image/png", "application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"x-api-key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call v2EditGetValidateBeforeCall(String backgroundColor, V2EditGetBackgroundExpandPromptParameter backgroundExpandPrompt, File backgroundGuidanceImageFile, String backgroundGuidanceImageUrl, BigDecimal backgroundGuidanceScale, String backgroundImageUrl, String backgroundNegativePrompt, String backgroundPrompt, String backgroundScaling, BigDecimal backgroundSeed, String expandMode, BigDecimal expandSeed, String exportFormat, String horizontalAlignment, Boolean ignorePaddingAndSnapOnCroppedSides, String imageUrl, String lightingMode, V2EditGetMarginParameter margin, V2EditGetMarginBottomParameter marginBottom, V2EditGetMarginBottomParameter marginLeft, V2EditGetMarginBottomParameter marginRight, V2EditGetMarginBottomParameter marginTop, BigDecimal maxHeight, BigDecimal maxWidth, String outputSize, V2EditGetMarginParameter padding, V2EditGetMarginBottomParameter paddingBottom, V2EditGetMarginBottomParameter paddingLeft, V2EditGetMarginBottomParameter paddingRight, V2EditGetMarginBottomParameter paddingTop, String referenceBox, Boolean removeBackground, String scaling, String shadowMode, UUID templateId, String textRemovalMode, String upscaleMode, String verticalAlignment, ApiCallback _callback) throws ApiException {
        return this.v2EditGetCall(backgroundColor, backgroundExpandPrompt, backgroundGuidanceImageFile, backgroundGuidanceImageUrl, backgroundGuidanceScale, backgroundImageUrl, backgroundNegativePrompt, backgroundPrompt, backgroundScaling, backgroundSeed, expandMode, expandSeed, exportFormat, horizontalAlignment, ignorePaddingAndSnapOnCroppedSides, imageUrl, lightingMode, margin, marginBottom, marginLeft, marginRight, marginTop, maxHeight, maxWidth, outputSize, padding, paddingBottom, paddingLeft, paddingRight, paddingTop, referenceBox, removeBackground, scaling, shadowMode, templateId, textRemovalMode, upscaleMode, verticalAlignment, _callback);
    }

    public File v2EditGet(String backgroundColor, V2EditGetBackgroundExpandPromptParameter backgroundExpandPrompt, File backgroundGuidanceImageFile, String backgroundGuidanceImageUrl, BigDecimal backgroundGuidanceScale, String backgroundImageUrl, String backgroundNegativePrompt, String backgroundPrompt, String backgroundScaling, BigDecimal backgroundSeed, String expandMode, BigDecimal expandSeed, String exportFormat, String horizontalAlignment, Boolean ignorePaddingAndSnapOnCroppedSides, String imageUrl, String lightingMode, V2EditGetMarginParameter margin, V2EditGetMarginBottomParameter marginBottom, V2EditGetMarginBottomParameter marginLeft, V2EditGetMarginBottomParameter marginRight, V2EditGetMarginBottomParameter marginTop, BigDecimal maxHeight, BigDecimal maxWidth, String outputSize, V2EditGetMarginParameter padding, V2EditGetMarginBottomParameter paddingBottom, V2EditGetMarginBottomParameter paddingLeft, V2EditGetMarginBottomParameter paddingRight, V2EditGetMarginBottomParameter paddingTop, String referenceBox, Boolean removeBackground, String scaling, String shadowMode, UUID templateId, String textRemovalMode, String upscaleMode, String verticalAlignment) throws ApiException {
        ApiResponse<File> localVarResp = this.v2EditGetWithHttpInfo(backgroundColor, backgroundExpandPrompt, backgroundGuidanceImageFile, backgroundGuidanceImageUrl, backgroundGuidanceScale, backgroundImageUrl, backgroundNegativePrompt, backgroundPrompt, backgroundScaling, backgroundSeed, expandMode, expandSeed, exportFormat, horizontalAlignment, ignorePaddingAndSnapOnCroppedSides, imageUrl, lightingMode, margin, marginBottom, marginLeft, marginRight, marginTop, maxHeight, maxWidth, outputSize, padding, paddingBottom, paddingLeft, paddingRight, paddingTop, referenceBox, removeBackground, scaling, shadowMode, templateId, textRemovalMode, upscaleMode, verticalAlignment);
        return localVarResp.getData();
    }

    public ApiResponse<File> v2EditGetWithHttpInfo(String backgroundColor, V2EditGetBackgroundExpandPromptParameter backgroundExpandPrompt, File backgroundGuidanceImageFile, String backgroundGuidanceImageUrl, BigDecimal backgroundGuidanceScale, String backgroundImageUrl, String backgroundNegativePrompt, String backgroundPrompt, String backgroundScaling, BigDecimal backgroundSeed, String expandMode, BigDecimal expandSeed, String exportFormat, String horizontalAlignment, Boolean ignorePaddingAndSnapOnCroppedSides, String imageUrl, String lightingMode, V2EditGetMarginParameter margin, V2EditGetMarginBottomParameter marginBottom, V2EditGetMarginBottomParameter marginLeft, V2EditGetMarginBottomParameter marginRight, V2EditGetMarginBottomParameter marginTop, BigDecimal maxHeight, BigDecimal maxWidth, String outputSize, V2EditGetMarginParameter padding, V2EditGetMarginBottomParameter paddingBottom, V2EditGetMarginBottomParameter paddingLeft, V2EditGetMarginBottomParameter paddingRight, V2EditGetMarginBottomParameter paddingTop, String referenceBox, Boolean removeBackground, String scaling, String shadowMode, UUID templateId, String textRemovalMode, String upscaleMode, String verticalAlignment) throws ApiException {
        Call localVarCall = this.v2EditGetValidateBeforeCall(backgroundColor, backgroundExpandPrompt, backgroundGuidanceImageFile, backgroundGuidanceImageUrl, backgroundGuidanceScale, backgroundImageUrl, backgroundNegativePrompt, backgroundPrompt, backgroundScaling, backgroundSeed, expandMode, expandSeed, exportFormat, horizontalAlignment, ignorePaddingAndSnapOnCroppedSides, imageUrl, lightingMode, margin, marginBottom, marginLeft, marginRight, marginTop, maxHeight, maxWidth, outputSize, padding, paddingBottom, paddingLeft, paddingRight, paddingTop, referenceBox, removeBackground, scaling, shadowMode, templateId, textRemovalMode, upscaleMode, verticalAlignment, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call v2EditGetAsync(String backgroundColor, V2EditGetBackgroundExpandPromptParameter backgroundExpandPrompt, File backgroundGuidanceImageFile, String backgroundGuidanceImageUrl, BigDecimal backgroundGuidanceScale, String backgroundImageUrl, String backgroundNegativePrompt, String backgroundPrompt, String backgroundScaling, BigDecimal backgroundSeed, String expandMode, BigDecimal expandSeed, String exportFormat, String horizontalAlignment, Boolean ignorePaddingAndSnapOnCroppedSides, String imageUrl, String lightingMode, V2EditGetMarginParameter margin, V2EditGetMarginBottomParameter marginBottom, V2EditGetMarginBottomParameter marginLeft, V2EditGetMarginBottomParameter marginRight, V2EditGetMarginBottomParameter marginTop, BigDecimal maxHeight, BigDecimal maxWidth, String outputSize, V2EditGetMarginParameter padding, V2EditGetMarginBottomParameter paddingBottom, V2EditGetMarginBottomParameter paddingLeft, V2EditGetMarginBottomParameter paddingRight, V2EditGetMarginBottomParameter paddingTop, String referenceBox, Boolean removeBackground, String scaling, String shadowMode, UUID templateId, String textRemovalMode, String upscaleMode, String verticalAlignment, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.v2EditGetValidateBeforeCall(backgroundColor, backgroundExpandPrompt, backgroundGuidanceImageFile, backgroundGuidanceImageUrl, backgroundGuidanceScale, backgroundImageUrl, backgroundNegativePrompt, backgroundPrompt, backgroundScaling, backgroundSeed, expandMode, expandSeed, exportFormat, horizontalAlignment, ignorePaddingAndSnapOnCroppedSides, imageUrl, lightingMode, margin, marginBottom, marginLeft, marginRight, marginTop, maxHeight, maxWidth, outputSize, padding, paddingBottom, paddingLeft, paddingRight, paddingTop, referenceBox, removeBackground, scaling, shadowMode, templateId, textRemovalMode, upscaleMode, verticalAlignment, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call v2EditPostCall(String backgroundColor, Object backgroundExpandPrompt, File backgroundGuidanceImageFile, BigDecimal backgroundGuidanceScale, File backgroundImageFile, String backgroundNegativePrompt, String backgroundPrompt, String backgroundScaling, BigDecimal backgroundSeed, String expandMode, BigDecimal expandSeed, String exportFormat, String horizontalAlignment, Boolean ignorePaddingAndSnapOnCroppedSides, File imageFile, String lightingMode, V2EditPostRequestMargin margin, V2EditPostRequestMarginBottom marginBottom, V2EditPostRequestMarginLeft marginLeft, V2EditPostRequestMarginRight marginRight, V2EditPostRequestMarginTop marginTop, BigDecimal maxHeight, BigDecimal maxWidth, String outputSize, V2EditPostRequestPadding padding, V2EditPostRequestPaddingBottom paddingBottom, V2EditPostRequestPaddingLeft paddingLeft, V2EditPostRequestPaddingRight paddingRight, V2EditPostRequestPaddingTop paddingTop, String referenceBox, Boolean removeBackground, String scaling, String shadowMode, UUID templateId, String textRemovalMode, String upscaleMode, String verticalAlignment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{"https://image-api.photoroom.com"};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/edit";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (backgroundColor != null) {
            localVarFormParams.put("background.color", backgroundColor);
        }
        if (backgroundExpandPrompt != null) {
            localVarFormParams.put("background.expandPrompt", backgroundExpandPrompt);
        }
        if (backgroundGuidanceImageFile != null) {
            localVarFormParams.put("background.guidance.imageFile", backgroundGuidanceImageFile);
        }
        if (backgroundGuidanceScale != null) {
            localVarFormParams.put("background.guidance.scale", backgroundGuidanceScale);
        }
        if (backgroundImageFile != null) {
            localVarFormParams.put("background.imageFile", backgroundImageFile);
        }
        if (backgroundNegativePrompt != null) {
            localVarFormParams.put("background.negativePrompt", backgroundNegativePrompt);
        }
        if (backgroundPrompt != null) {
            localVarFormParams.put("background.prompt", backgroundPrompt);
        }
        if (backgroundScaling != null) {
            localVarFormParams.put("background.scaling", backgroundScaling);
        }
        if (backgroundSeed != null) {
            localVarFormParams.put("background.seed", backgroundSeed);
        }
        if (expandMode != null) {
            localVarFormParams.put("expand.mode", expandMode);
        }
        if (expandSeed != null) {
            localVarFormParams.put("expand.seed", expandSeed);
        }
        if (exportFormat != null) {
            localVarFormParams.put("export.format", exportFormat);
        }
        if (horizontalAlignment != null) {
            localVarFormParams.put("horizontalAlignment", horizontalAlignment);
        }
        if (ignorePaddingAndSnapOnCroppedSides != null) {
            localVarFormParams.put("ignorePaddingAndSnapOnCroppedSides", ignorePaddingAndSnapOnCroppedSides);
        }
        if (imageFile != null) {
            localVarFormParams.put("imageFile", imageFile);
        }
        if (lightingMode != null) {
            localVarFormParams.put("lighting.mode", lightingMode);
        }
        if (margin != null) {
            localVarFormParams.put("margin", margin);
        }
        if (marginBottom != null) {
            localVarFormParams.put("marginBottom", marginBottom);
        }
        if (marginLeft != null) {
            localVarFormParams.put("marginLeft", marginLeft);
        }
        if (marginRight != null) {
            localVarFormParams.put("marginRight", marginRight);
        }
        if (marginTop != null) {
            localVarFormParams.put("marginTop", marginTop);
        }
        if (maxHeight != null) {
            localVarFormParams.put("maxHeight", maxHeight);
        }
        if (maxWidth != null) {
            localVarFormParams.put("maxWidth", maxWidth);
        }
        if (outputSize != null) {
            localVarFormParams.put("outputSize", outputSize);
        }
        if (padding != null) {
            localVarFormParams.put("padding", padding);
        }
        if (paddingBottom != null) {
            localVarFormParams.put("paddingBottom", paddingBottom);
        }
        if (paddingLeft != null) {
            localVarFormParams.put("paddingLeft", paddingLeft);
        }
        if (paddingRight != null) {
            localVarFormParams.put("paddingRight", paddingRight);
        }
        if (paddingTop != null) {
            localVarFormParams.put("paddingTop", paddingTop);
        }
        if (referenceBox != null) {
            localVarFormParams.put("referenceBox", referenceBox);
        }
        if (removeBackground != null) {
            localVarFormParams.put("removeBackground", removeBackground);
        }
        if (scaling != null) {
            localVarFormParams.put("scaling", scaling);
        }
        if (shadowMode != null) {
            localVarFormParams.put("shadow.mode", shadowMode);
        }
        if (templateId != null) {
            localVarFormParams.put("templateId", templateId);
        }
        if (textRemovalMode != null) {
            localVarFormParams.put("textRemoval.mode", textRemovalMode);
        }
        if (upscaleMode != null) {
            localVarFormParams.put("upscale.mode", upscaleMode);
        }
        if (verticalAlignment != null) {
            localVarFormParams.put("verticalAlignment", verticalAlignment);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"image/png", "application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"x-api-key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call v2EditPostValidateBeforeCall(String backgroundColor, Object backgroundExpandPrompt, File backgroundGuidanceImageFile, BigDecimal backgroundGuidanceScale, File backgroundImageFile, String backgroundNegativePrompt, String backgroundPrompt, String backgroundScaling, BigDecimal backgroundSeed, String expandMode, BigDecimal expandSeed, String exportFormat, String horizontalAlignment, Boolean ignorePaddingAndSnapOnCroppedSides, File imageFile, String lightingMode, V2EditPostRequestMargin margin, V2EditPostRequestMarginBottom marginBottom, V2EditPostRequestMarginLeft marginLeft, V2EditPostRequestMarginRight marginRight, V2EditPostRequestMarginTop marginTop, BigDecimal maxHeight, BigDecimal maxWidth, String outputSize, V2EditPostRequestPadding padding, V2EditPostRequestPaddingBottom paddingBottom, V2EditPostRequestPaddingLeft paddingLeft, V2EditPostRequestPaddingRight paddingRight, V2EditPostRequestPaddingTop paddingTop, String referenceBox, Boolean removeBackground, String scaling, String shadowMode, UUID templateId, String textRemovalMode, String upscaleMode, String verticalAlignment, ApiCallback _callback) throws ApiException {
        return this.v2EditPostCall(backgroundColor, backgroundExpandPrompt, backgroundGuidanceImageFile, backgroundGuidanceScale, backgroundImageFile, backgroundNegativePrompt, backgroundPrompt, backgroundScaling, backgroundSeed, expandMode, expandSeed, exportFormat, horizontalAlignment, ignorePaddingAndSnapOnCroppedSides, imageFile, lightingMode, margin, marginBottom, marginLeft, marginRight, marginTop, maxHeight, maxWidth, outputSize, padding, paddingBottom, paddingLeft, paddingRight, paddingTop, referenceBox, removeBackground, scaling, shadowMode, templateId, textRemovalMode, upscaleMode, verticalAlignment, _callback);
    }

    public File v2EditPost(String backgroundColor, Object backgroundExpandPrompt, File backgroundGuidanceImageFile, BigDecimal backgroundGuidanceScale, File backgroundImageFile, String backgroundNegativePrompt, String backgroundPrompt, String backgroundScaling, BigDecimal backgroundSeed, String expandMode, BigDecimal expandSeed, String exportFormat, String horizontalAlignment, Boolean ignorePaddingAndSnapOnCroppedSides, File imageFile, String lightingMode, V2EditPostRequestMargin margin, V2EditPostRequestMarginBottom marginBottom, V2EditPostRequestMarginLeft marginLeft, V2EditPostRequestMarginRight marginRight, V2EditPostRequestMarginTop marginTop, BigDecimal maxHeight, BigDecimal maxWidth, String outputSize, V2EditPostRequestPadding padding, V2EditPostRequestPaddingBottom paddingBottom, V2EditPostRequestPaddingLeft paddingLeft, V2EditPostRequestPaddingRight paddingRight, V2EditPostRequestPaddingTop paddingTop, String referenceBox, Boolean removeBackground, String scaling, String shadowMode, UUID templateId, String textRemovalMode, String upscaleMode, String verticalAlignment) throws ApiException {
        ApiResponse<File> localVarResp = this.v2EditPostWithHttpInfo(backgroundColor, backgroundExpandPrompt, backgroundGuidanceImageFile, backgroundGuidanceScale, backgroundImageFile, backgroundNegativePrompt, backgroundPrompt, backgroundScaling, backgroundSeed, expandMode, expandSeed, exportFormat, horizontalAlignment, ignorePaddingAndSnapOnCroppedSides, imageFile, lightingMode, margin, marginBottom, marginLeft, marginRight, marginTop, maxHeight, maxWidth, outputSize, padding, paddingBottom, paddingLeft, paddingRight, paddingTop, referenceBox, removeBackground, scaling, shadowMode, templateId, textRemovalMode, upscaleMode, verticalAlignment);
        return localVarResp.getData();
    }

    public ApiResponse<File> v2EditPostWithHttpInfo(String backgroundColor, Object backgroundExpandPrompt, File backgroundGuidanceImageFile, BigDecimal backgroundGuidanceScale, File backgroundImageFile, String backgroundNegativePrompt, String backgroundPrompt, String backgroundScaling, BigDecimal backgroundSeed, String expandMode, BigDecimal expandSeed, String exportFormat, String horizontalAlignment, Boolean ignorePaddingAndSnapOnCroppedSides, File imageFile, String lightingMode, V2EditPostRequestMargin margin, V2EditPostRequestMarginBottom marginBottom, V2EditPostRequestMarginLeft marginLeft, V2EditPostRequestMarginRight marginRight, V2EditPostRequestMarginTop marginTop, BigDecimal maxHeight, BigDecimal maxWidth, String outputSize, V2EditPostRequestPadding padding, V2EditPostRequestPaddingBottom paddingBottom, V2EditPostRequestPaddingLeft paddingLeft, V2EditPostRequestPaddingRight paddingRight, V2EditPostRequestPaddingTop paddingTop, String referenceBox, Boolean removeBackground, String scaling, String shadowMode, UUID templateId, String textRemovalMode, String upscaleMode, String verticalAlignment) throws ApiException {
        Call localVarCall = this.v2EditPostValidateBeforeCall(backgroundColor, backgroundExpandPrompt, backgroundGuidanceImageFile, backgroundGuidanceScale, backgroundImageFile, backgroundNegativePrompt, backgroundPrompt, backgroundScaling, backgroundSeed, expandMode, expandSeed, exportFormat, horizontalAlignment, ignorePaddingAndSnapOnCroppedSides, imageFile, lightingMode, margin, marginBottom, marginLeft, marginRight, marginTop, maxHeight, maxWidth, outputSize, padding, paddingBottom, paddingLeft, paddingRight, paddingTop, referenceBox, removeBackground, scaling, shadowMode, templateId, textRemovalMode, upscaleMode, verticalAlignment, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call v2EditPostAsync(String backgroundColor, Object backgroundExpandPrompt, File backgroundGuidanceImageFile, BigDecimal backgroundGuidanceScale, File backgroundImageFile, String backgroundNegativePrompt, String backgroundPrompt, String backgroundScaling, BigDecimal backgroundSeed, String expandMode, BigDecimal expandSeed, String exportFormat, String horizontalAlignment, Boolean ignorePaddingAndSnapOnCroppedSides, File imageFile, String lightingMode, V2EditPostRequestMargin margin, V2EditPostRequestMarginBottom marginBottom, V2EditPostRequestMarginLeft marginLeft, V2EditPostRequestMarginRight marginRight, V2EditPostRequestMarginTop marginTop, BigDecimal maxHeight, BigDecimal maxWidth, String outputSize, V2EditPostRequestPadding padding, V2EditPostRequestPaddingBottom paddingBottom, V2EditPostRequestPaddingLeft paddingLeft, V2EditPostRequestPaddingRight paddingRight, V2EditPostRequestPaddingTop paddingTop, String referenceBox, Boolean removeBackground, String scaling, String shadowMode, UUID templateId, String textRemovalMode, String upscaleMode, String verticalAlignment, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.v2EditPostValidateBeforeCall(backgroundColor, backgroundExpandPrompt, backgroundGuidanceImageFile, backgroundGuidanceScale, backgroundImageFile, backgroundNegativePrompt, backgroundPrompt, backgroundScaling, backgroundSeed, expandMode, expandSeed, exportFormat, horizontalAlignment, ignorePaddingAndSnapOnCroppedSides, imageFile, lightingMode, margin, marginBottom, marginLeft, marginRight, marginTop, maxHeight, maxWidth, outputSize, padding, paddingBottom, paddingLeft, paddingRight, paddingTop, referenceBox, removeBackground, scaling, shadowMode, templateId, textRemovalMode, upscaleMode, verticalAlignment, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

