/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.photoroom.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.nuxeo.labs.photoroom.client.JSON;
import org.nuxeo.labs.photoroom.model.AbstractOpenApiSchema;

public class V2EditPostRequestMarginBottom
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(V2EditPostRequestMarginBottom.class.getName());
    public static final Map<String, Class<?>> schemas = new HashMap();

    public V2EditPostRequestMarginBottom() {
        super("anyOf", Boolean.FALSE);
    }

    public V2EditPostRequestMarginBottom(Object o) {
        super("anyOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof String) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof BigDecimal) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be BigDecimal, String");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public String getString() throws ClassCastException {
        return (String)super.getActualInstance();
    }

    public BigDecimal getBigDecimal() throws ClassCastException {
        return (BigDecimal)super.getActualInstance();
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            if (!jsonElement.getAsJsonPrimitive().isString()) {
                throw new IllegalArgumentException(String.format("Expected json element to be of type String in the JSON string but got `%s`", jsonElement.toString()));
            }
            return;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for String failed with `%s`.", e.getMessage()));
            try {
                if (!jsonElement.getAsJsonPrimitive().isNumber()) {
                    throw new IllegalArgumentException(String.format("Expected json element to be of type Number in the JSON string but got `%s`", jsonElement.toString()));
                }
                return;
            }
            catch (Exception e2) {
                errorMessages.add(String.format("Deserialization for BigDecimal failed with `%s`.", e2.getMessage()));
                throw new IOException(String.format("The JSON string is invalid for V2EditPostRequestMarginBottom with anyOf schemas: BigDecimal, String. no class match the result, expected at least 1. Detailed failure message for anyOf schemas: %s. JSON: %s", errorMessages, jsonElement.toString()));
            }
        }
    }

    public static V2EditPostRequestMarginBottom fromJson(String jsonString) throws IOException {
        return (V2EditPostRequestMarginBottom)JSON.getGson().fromJson(jsonString, V2EditPostRequestMarginBottom.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        schemas.put("String", String.class);
        schemas.put("BigDecimal", BigDecimal.class);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V2EditPostRequestMarginBottom.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter adapterString = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(String.class));
            final TypeAdapter adapterBigDecimal = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BigDecimal.class));
            return new TypeAdapter<V2EditPostRequestMarginBottom>(){

                public void write(JsonWriter out, V2EditPostRequestMarginBottom value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }
                    if (value.getActualInstance() instanceof String) {
                        JsonPrimitive primitive = adapterString.toJsonTree((Object)((String)value.getActualInstance())).getAsJsonPrimitive();
                        elementAdapter.write(out, (Object)primitive);
                        return;
                    }
                    if (value.getActualInstance() instanceof BigDecimal) {
                        JsonElement element = adapterBigDecimal.toJsonTree((Object)((BigDecimal)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match anyOf schemas: BigDecimal, String");
                }

                public V2EditPostRequestMarginBottom read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    TypeAdapter actualAdapter = elementAdapter;
                    try {
                        if (!jsonElement.getAsJsonPrimitive().isString()) {
                            throw new IllegalArgumentException(String.format("Expected json element to be of type String in the JSON string but got `%s`", jsonElement.toString()));
                        }
                        actualAdapter = adapterString;
                        V2EditPostRequestMarginBottom ret = new V2EditPostRequestMarginBottom();
                        ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                        return ret;
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for String failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'String'", e);
                        try {
                            if (!jsonElement.getAsJsonPrimitive().isNumber()) {
                                throw new IllegalArgumentException(String.format("Expected json element to be of type Number in the JSON string but got `%s`", jsonElement.toString()));
                            }
                            actualAdapter = adapterBigDecimal;
                            V2EditPostRequestMarginBottom ret = new V2EditPostRequestMarginBottom();
                            ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                            return ret;
                        }
                        catch (Exception e2) {
                            errorMessages.add(String.format("Deserialization for BigDecimal failed with `%s`.", e2.getMessage()));
                            log.log(Level.FINER, "Input data does not match schema 'BigDecimal'", e2);
                            throw new IOException(String.format("Failed deserialization for V2EditPostRequestMarginBottom: no class matches result, expected at least 1. Detailed failure message for anyOf schemas: %s. JSON: %s", errorMessages, jsonElement.toString()));
                        }
                    }
                }
            }.nullSafe();
        }
    }
}

