/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.photoroom.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Base64;
import java.util.Optional;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.ByteArrayBlob;
import org.nuxeo.labs.photoroom.client.ApiException;
import org.nuxeo.labs.photoroom.client.ServerConfiguration;
import org.nuxeo.labs.photoroom.client.api.DefaultApi;
import org.nuxeo.labs.photoroom.client.auth.ApiKeyAuth;
import org.nuxeo.labs.photoroom.service.PhotoroomService;
import org.nuxeo.labs.photoroom.service.model.ResultImage;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class PhotoroomServiceImpl
extends DefaultComponent
implements PhotoroomService {
    public static final String API_KEY_PROPERTY = "photoroom.apikey";
    public static final String API_KEY_HEADER = "x-api-key";
    public static final String TEST_SERVER_CONFIG = "test";
    protected static final ObjectMapper objectMapper = new ObjectMapper();
    protected volatile DefaultApi client;

    @Override
    public Blob removeImageBackground(Blob source) {
        DefaultApi client = this.getClient();
        try {
            File response = client.removeBackground(source.getCloseableFile().file, "png", "rgba", null, "full", "false", "false");
            ResultImage resultObj = (ResultImage)objectMapper.readValue(response, ResultImage.class);
            byte[] bytes = Base64.getDecoder().decode(resultObj.getResult_b64());
            ByteArrayBlob noBgBlob = new ByteArrayBlob(bytes, "image/png");
            noBgBlob.setFilename(source.getFilename());
            return noBgBlob;
        }
        catch (IOException | ApiException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getApiKey() {
        return Framework.getProperty((String)API_KEY_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefaultApi getClient() {
        DefaultApi result = this.client;
        if (result == null) {
            PhotoroomServiceImpl photoroomServiceImpl = this;
            synchronized (photoroomServiceImpl) {
                result = this.client;
                if (result == null) {
                    result = this.client = new DefaultApi();
                    ((ApiKeyAuth)this.client.getApiClient().getAuthentication(API_KEY_HEADER)).setApiKey(this.getApiKey());
                    Optional<ServerConfiguration> testServer = this.client.getApiClient().getServers().stream().filter(server -> TEST_SERVER_CONFIG.equals(server.description)).findFirst();
                    testServer.ifPresent(serverConfiguration -> this.client.setCustomBaseUrl(serverConfiguration.URL));
                }
            }
        }
        return result;
    }
}

