# Description
A plugin that provides an integration between [photoroom.com](https://www.photoroom.com/) and the Nuxeo Platform.

# How to build
```bash
git clone https://github.com/nuxeo-sandbox/nuxeo-photoroom-connector
cd nuxeo-photoroom-connector
mvn clean install
```

# How to test
This repository contains a sample docker image a docker-compose resources. Assuming you have built the project (including the docker image) and have
an api key from photoroom.com and a Nuxeo CLID:

```bash
echo "photoroom.apikey=<MY_KEY>" > ./conf.d/photoroom.conf
echo "NUXEO_CLID=<MY_CLID>" > .env
docker compose up -d
```

The test configuration contains a UI action for the Picture type document. 

# Configuration
## nuxeo.conf

| Property name    | description                            |
|------------------|:---------------------------------------|
| photoroom.apikey | A string property to store the api key |

# Plugin Features

## A Java client for the photoroom REST API
This projects contains a [Java client](https://github.com/nuxeo-sandbox/nuxeo-photoroom-connector/tree/master/photoroom-java-client) for the [Photoroom REST API](https://docs.photoroom.com/) which is autogenerated using the [OpenAPI Generator Maven Plugin](https://github.com/OpenAPITools/openapi-generator/tree/master/modules/openapi-generator-maven-plugin) 

## Service
The [PhotoroomService](https://github.com/nuxeo-sandbox/nuxeo-photoroom-connector/blob/master/nuxeo-photoroom-connector/src/main/resources/OSGI-INF/photoroom-service-contrib.xml) provides the glue between the Java Client and the Nuxeo Java APIs

## Automation API

### Remove Picture Background

This operation takes an image blob, calls the photoroom.com API to remove the background and return the result image

```js
function run(input, params) {
  var blob = Picture.GetView(input, {
    'viewName': 'FullHD'
  });

  var result = Photoroom.RemoveBackgroundOp(blob, {});

  input = Document.SetBlob(input, {file:result});

  input = Document.Save(input, {});

  return input;
}
```

# Support

**These features are not part of the Nuxeo Production platform.**

These solutions are provided for inspiration and we encourage customers to use them as code samples and learning resources.

This is a moving project (no API maintenance, no deprecation process, etc.) If any of these solutions are found to be useful for the Nuxeo Platform in general, they will be integrated directly into platform, not maintained here.

# Nuxeo Marketplace
This plugin is published on the [marketplace](https://connect.nuxeo.com/nuxeo/site/marketplace/package/nuxeo-photoroom-connector)

# License

[Apache License, Version 2.0](http://www.apache.org/licenses/LICENSE-2.0.html)

# About Nuxeo

Nuxeo Platform is an open source Content Services platform, written in Java. Data can be stored in both SQL & NoSQL databases.

The development of the Nuxeo Platform is mostly done by Nuxeo employees with an open development model.

The source code, documentation, roadmap, issue tracker, testing, benchmarks are all public.

Typically, Nuxeo users build different types of information management solutions for [document management](https://www.nuxeo.com/solutions/document-management/), [case management](https://www.nuxeo.com/solutions/case-management/), and [digital asset management](https://www.nuxeo.com/solutions/dam-digital-asset-management/), use cases. It uses schema-flexible metadata & content models that allows content to be repurposed to fulfill future use cases.

More information is available at [www.nuxeo.com](https://www.nuxeo.com).
