/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.threed.convert;

import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.runtime.api.Framework;

public class DockerHelper {
    public static final String CREATE_CONTAINER_COMMAND = "create_container";
    public static final String REMOVE_CONTAINER_COMMAND = "remove_container";
    public static final String COPY_CONTAINER_COMMAND = "copy_container";
    public static final String NAME_PARAM = "name";
    public static final String IMAGE_PARAM = "image";
    public static final String SOURCE_PARAM = "source";
    public static final String DEST_PARAM = "destination";

    public static ExecResult CreateContainer(String name, String image) {
        CmdParameters params = new CmdParameters();
        params.addNamedParameter(NAME_PARAM, name);
        params.addNamedParameter(IMAGE_PARAM, image);
        return DockerHelper.executeCommand(CREATE_CONTAINER_COMMAND, params);
    }

    public static ExecResult RemoveContainer(String name) {
        CmdParameters params = new CmdParameters();
        params.addNamedParameter(NAME_PARAM, name);
        return DockerHelper.executeCommand(REMOVE_CONTAINER_COMMAND, params);
    }

    public static ExecResult CopyData(String source, String destination) {
        CmdParameters params = new CmdParameters();
        params.addNamedParameter(SOURCE_PARAM, source);
        params.addNamedParameter(DEST_PARAM, destination);
        return DockerHelper.executeCommand(COPY_CONTAINER_COMMAND, params);
    }

    private static ExecResult executeCommand(String command, CmdParameters params) {
        ExecResult result = null;
        try {
            result = ((CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class)).execCommand(command, params);
        }
        catch (CommandNotAvailable commandNotAvailable) {
            return null;
        }
        return result;
    }
}

