/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.threed.listener;

import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.threed.service.ThreeDBatchUpdateWork;
import org.nuxeo.runtime.api.Framework;

public class ThreeDBatchGenerationListener
implements EventListener {
    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        Boolean generate = (Boolean)event.getContext().getProperty("generateBatchData");
        if (!Boolean.TRUE.equals(generate)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        if (doc.hasFacet("ThreeD") && !doc.isProxy()) {
            ThreeDBatchUpdateWork work = new ThreeDBatchUpdateWork(doc.getRepositoryName(), doc.getId());
            WorkManager manager = (WorkManager)Framework.getLocalService(WorkManager.class);
            ThreeDBatchUpdateWork running = (ThreeDBatchUpdateWork)manager.find(work.getId(), Work.State.RUNNING);
            ThreeDBatchUpdateWork scheduled = (ThreeDBatchUpdateWork)manager.find(work.getId(), Work.State.SCHEDULED);
            if (running != null) {
                running.suspended();
                running.setStatus("Suspended");
            } else if (scheduled != null) {
                scheduled.suspended();
                scheduled.setStatus("Suspended");
            }
            manager.schedule((Work)work, WorkManager.Scheduling.ENQUEUE, true);
        }
    }
}

