/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.threed.convert;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolderWithProperties;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.convert.plugins.CommandLineBasedConverter;
import org.nuxeo.ecm.platform.threed.ThreeDConstants;
import org.nuxeo.ecm.platform.threed.convert.DockerHelper;
import org.nuxeo.runtime.api.Framework;

public abstract class BaseBlenderConverter
extends CommandLineBasedConverter {
    public static final String MIMETYPE_ZIP = "application/zip";

    protected Path tempDirectory(Map<String, Serializable> parameters, String sufix) throws ConversionException {
        Path directory = new Path(this.getTmpDirectory(parameters)).append("blender_" + UUID.randomUUID() + sufix);
        boolean dirCreated = new File(directory.toString()).mkdirs();
        if (!dirCreated) {
            throw new ConversionException("Unable to create tmp dir: " + directory);
        }
        return directory;
    }

    protected boolean isThreeDFile(File file) {
        return ThreeDConstants.SUPPORTED_EXTENSIONS.contains(FilenameUtils.getExtension((String)file.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> unpackZipFile(File file, File directory) throws IOException {
        ArrayList<String> expandedFiles = new ArrayList<String>();
        try (ZipInputStream zipInputStream = null;){
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(new FileInputStream(file));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                File destFile = new File(directory, zipEntry.getName());
                if (!zipEntry.isDirectory()) {
                    try (FileOutputStream destOutputStream = new FileOutputStream(destFile);){
                        IOUtils.copy((InputStream)zipInputStream, (OutputStream)destOutputStream);
                    }
                    zipInputStream.closeEntry();
                    if (this.isThreeDFile(destFile)) {
                        expandedFiles.add(0, destFile.getAbsolutePath());
                        continue;
                    }
                    expandedFiles.add(destFile.getAbsolutePath());
                    continue;
                }
                destFile.mkdirs();
            }
        }
        return expandedFiles;
    }

    protected List<String> blobsToTempDir(BlobHolder blobHolder, Path directory) throws IOException {
        List blobs = blobHolder.getBlobs();
        ArrayList<String> filesCreated = new ArrayList<String>();
        if (blobs.isEmpty()) {
            return filesCreated;
        }
        if (MIMETYPE_ZIP.equals(((Blob)blobs.get(0)).getMimeType())) {
            filesCreated.addAll(this.unpackZipFile(((Blob)blobs.get(0)).getFile(), new File(directory.toString())));
            blobs = blobs.subList(1, blobs.size());
        }
        filesCreated.addAll(blobs.stream().map(blob -> {
            File file = new File(directory.append(blob.getFilename()).toString());
            try {
                blob.transferTo(file);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return file.getAbsolutePath();
        }).collect(Collectors.toList()));
        filesCreated.add(directory.toString());
        return filesCreated;
    }

    private void createPath(Path path) throws ConversionException {
        boolean dirCreated;
        File pathFile = new File(path.toString());
        if (!pathFile.exists() && !(dirCreated = pathFile.mkdir())) {
            throw new ConversionException("Unable to create tmp dir for scripts output: " + path);
        }
    }

    private Path copyScript(Path pathDst, Path source) throws IOException {
        String sourceFile = source.lastSegment();
        File script = new File(pathDst.append(sourceFile).toString());
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/" + source.toString());
        FileUtils.copyInputStreamToFile((InputStream)is, (File)script);
        return new Path(script.getAbsolutePath());
    }

    protected Path getScriptWith(List<String> operators) throws IOException {
        Path dataPath = new Path(Environment.getDefault().getData().getAbsolutePath());
        String sourceDir = (String)this.initParameters.get("scriptsDir");
        String sourceFile = (String)this.initParameters.get("scriptFile");
        Path scriptsPath = dataPath.append("scripts");
        this.createPath(scriptsPath);
        this.copyScript(scriptsPath, new Path(sourceDir).append(sourceFile));
        if (operators.isEmpty()) {
            return scriptsPath;
        }
        Path pipelinePath = scriptsPath.append("pipeline");
        this.createPath(pipelinePath);
        Path pipelineSourcePath = new Path(sourceDir).append("pipeline");
        operators.forEach(operator -> {
            try {
                this.copyScript(pipelinePath, pipelineSourcePath.append(operator + ".py"));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return scriptsPath;
    }

    private List<String> getParams(Map<String, Serializable> inParams, Map<String, String> initParams, String key) {
        String values = "";
        if (inParams.containsKey(key)) {
            values = (String)((Object)inParams.get(key));
        } else if (initParams.containsKey(key)) {
            values = initParams.get(key);
        }
        return Arrays.asList(values.split(" "));
    }

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        String dataContainer = "data" + String.valueOf(Calendar.getInstance().getTime().getTime());
        String convertContainer = "convert" + String.valueOf(Calendar.getInstance().getTime().getTime());
        String commandName = this.getCommandName(blobHolder, parameters);
        if (commandName == null) {
            throw new ConversionException("Unable to determine target CommandLine name");
        }
        ArrayList<CloseableFile> toClose = new ArrayList<CloseableFile>();
        Path inDirectory = this.tempDirectory(null, "_in");
        try {
            Map strParams;
            CmdParameters params = new CmdParameters();
            List<String> operatorsList = this.getParams(parameters, this.initParameters, "operators");
            params.addNamedParameter("operators", operatorsList);
            operatorsList = operatorsList.stream().distinct().collect(Collectors.toList());
            Path mainScriptDir = this.getScriptWith(operatorsList);
            params.addNamedParameter("scriptFile", (String)this.initParameters.get("scriptFile"));
            params.addNamedParameter("renderIds", this.getParams(parameters, this.initParameters, "renderIds"));
            params.addNamedParameter("lodIds", this.getParams(parameters, this.initParameters, "lodIds"));
            params.addNamedParameter("percPoly", this.getParams(parameters, this.initParameters, "percPoly"));
            params.addNamedParameter("maxPoly", this.getParams(parameters, this.initParameters, "maxPoly"));
            params.addNamedParameter("coords", this.getParams(parameters, this.initParameters, "coords"));
            params.addNamedParameter("dimensions", this.getParams(parameters, this.initParameters, "dimensions"));
            List<String> inputFiles = this.blobsToTempDir(blobHolder, inDirectory);
            Path mainFile = new Path(inputFiles.get(0));
            params.addNamedParameter("inFile", mainFile.lastSegment());
            Map blobParams = this.getCmdBlobParameters(blobHolder, parameters);
            ExecResult createRes = DockerHelper.CreateContainer(dataContainer, "nuxeo/blender");
            if (createRes == null || !createRes.isSuccessful()) {
                throw new ConversionException("Unable to create data volume : " + dataContainer, (Throwable)(createRes != null ? createRes.getError() : null));
            }
            ExecResult copyRes = DockerHelper.CopyData(mainFile.removeLastSegments(1).toString() + File.separatorChar + ".", dataContainer + ":/in/");
            if (copyRes == null || !copyRes.isSuccessful()) {
                throw new ConversionException("Unable to copy content to data volume : " + dataContainer, (Throwable)(copyRes != null ? copyRes.getError() : null));
            }
            copyRes = DockerHelper.CopyData(mainScriptDir.toString() + File.separatorChar + ".", dataContainer + ":/scripts/");
            if (copyRes == null || !copyRes.isSuccessful()) {
                throw new ConversionException("Unable to copy to scripts data volume : " + dataContainer, (Throwable)(copyRes != null ? copyRes.getError() : null));
            }
            params.addNamedParameter("name", convertContainer);
            params.addNamedParameter("data", dataContainer);
            if (blobParams != null) {
                for (Object blobParamName : blobParams.keySet()) {
                    Blob blob = (Blob)blobParams.get(blobParamName);
                    CloseableFile closeable = blob.getCloseableFile("." + FilenameUtils.getExtension((String)blob.getFilename()));
                    params.addNamedParameter((String)blobParamName, closeable.getFile());
                    toClose.add(closeable);
                }
            }
            if ((strParams = this.getCmdStringParameters(blobHolder, parameters)) != null) {
                for (String paramName : strParams.keySet()) {
                    if ("renderIds".equals(paramName) || "lodIds".equals(paramName) || "percPoly".equals(paramName) || "maxPoly".equals(paramName) || "coords".equals(paramName) || "dimensions".equals(paramName)) {
                        if (strParams.get(paramName) == null) continue;
                        params.addNamedParameter(paramName, Arrays.asList(((String)strParams.get(paramName)).split(" ")));
                        continue;
                    }
                    params.addNamedParameter(paramName, (String)strParams.get(paramName));
                }
            }
            Path outDir = this.tempDirectory(null, "_out");
            params.addNamedParameter("outDir", outDir.toString());
            ExecResult result = ((CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class)).execCommand(commandName, params);
            if (!result.isSuccessful()) {
                throw result.getError();
            }
            copyRes = DockerHelper.CopyData(dataContainer + ":/out/.", outDir.toString());
            if (copyRes == null || !copyRes.isSuccessful()) {
                throw new ConversionException("Unable to copy from data volume : " + dataContainer, (Throwable)(copyRes != null ? copyRes.getError() : null));
            }
            BlobHolder blobHolder2 = this.buildResult(result.getOutput(), params);
            return blobHolder2;
        }
        catch (CommandNotAvailable e) {
            throw new ConversionException("Unable to find targetCommand", (Throwable)e);
        }
        catch (IOException | CommandException e) {
            throw new ConversionException("Error while converting via CommandLineService", e);
        }
        finally {
            FileUtils.deleteQuietly((File)new File(inDirectory.toString()));
            for (Closeable closeable : toClose) {
                IOUtils.closeQuietly((Closeable)closeable);
            }
            DockerHelper.RemoveContainer(dataContainer);
            DockerHelper.RemoveContainer(convertContainer);
        }
    }

    public List<String> getConversionLOD(String outDir) {
        File directory = new File(outDir);
        String[] files = directory.list((dir, name) -> true);
        return files == null ? Collections.emptyList() : Arrays.asList(files);
    }

    public List<String> getRenders(String outDir) {
        File directory = new File(outDir);
        String[] files = directory.list((dir, name) -> name.startsWith("render") && name.endsWith(".png"));
        return files == null ? Collections.emptyList() : Arrays.asList(files);
    }

    public List<String> getInfos(String outDir) {
        File directory = new File(outDir);
        String[] files = directory.list((dir, name) -> name.endsWith(".info"));
        return files == null ? Collections.emptyList() : Arrays.asList(files);
    }

    protected BlobHolder buildResult(List<String> cmdOutput, CmdParameters cmdParams) throws ConversionException {
        String outDir = cmdParams.getParameter("outDir");
        HashMap lodBlobIndexes = new HashMap();
        ArrayList resourceIndexes = new ArrayList();
        HashMap infoIndexes = new HashMap();
        ArrayList blobs = new ArrayList();
        String lodDir = outDir + File.separatorChar + "convert";
        List<String> conversions = this.getConversionLOD(lodDir);
        conversions.forEach(filename -> {
            File file = new File(lodDir + File.separatorChar + filename);
            FileBlob blob = new FileBlob(file);
            blob.setFilename(file.getName());
            if (FilenameUtils.getExtension((String)filename).toLowerCase().equals("dae")) {
                String[] filenameArray = filename.split("-");
                if (filenameArray.length != 4) {
                    throw new ConversionException(filenameArray + " incompatible with conversion file name schema.");
                }
                lodBlobIndexes.put(filenameArray[1], blobs.size());
            } else {
                resourceIndexes.add(blobs.size());
            }
            blobs.add(blob);
        });
        String infoDir = outDir + File.separatorChar + "info";
        List<String> infos = this.getInfos(infoDir);
        infos.forEach(filename -> {
            File file = new File(infoDir + File.separatorChar + filename);
            FileBlob blob = new FileBlob(file);
            blob.setFilename(file.getName());
            if (FilenameUtils.getExtension((String)filename).toLowerCase().equals("info")) {
                String lodId = FilenameUtils.getBaseName((String)filename);
                infoIndexes.put(lodId, blobs.size());
                blobs.add(blob);
            }
        });
        String renderDir = outDir + File.separatorChar + "render";
        List<String> renders = this.getRenders(renderDir);
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("cmdOutput", (Serializable)((Object)cmdOutput));
        properties.put("resourceIndexes", resourceIndexes);
        properties.put("infoIndexes", infoIndexes);
        properties.put("lodIdIndexes", lodBlobIndexes);
        properties.put("renderStartIndex", Integer.valueOf(blobs.size()));
        blobs.addAll(renders.stream().map(result -> {
            File file = new File(renderDir + File.separatorChar + result);
            FileBlob blob = new FileBlob(file);
            blob.setFilename(file.getName());
            return blob;
        }).collect(Collectors.toList()));
        return new SimpleBlobHolderWithProperties(blobs, properties);
    }
}

