/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.threed.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.threed.ThreeD;
import org.nuxeo.ecm.platform.threed.ThreeDBatchProgress;
import org.nuxeo.ecm.platform.threed.TransmissionThreeD;
import org.nuxeo.ecm.platform.threed.service.AutomaticLOD;
import org.nuxeo.ecm.platform.threed.service.AutomaticLODContributionHandler;
import org.nuxeo.ecm.platform.threed.service.AutomaticRenderView;
import org.nuxeo.ecm.platform.threed.service.AutomaticRenderViewContributionHandler;
import org.nuxeo.ecm.platform.threed.service.RenderView;
import org.nuxeo.ecm.platform.threed.service.RenderViewContributionHandler;
import org.nuxeo.ecm.platform.threed.service.ThreeDBatchUpdateWork;
import org.nuxeo.ecm.platform.threed.service.ThreeDService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ThreeDServiceImpl
extends DefaultComponent
implements ThreeDService {
    protected static final Log log = LogFactory.getLog(ThreeDServiceImpl.class);
    public static final String RENDER_VIEWS_EP = "renderViews";
    public static final String DEFAULT_RENDER_VIEWS_EP = "automaticRenderViews";
    public static final String DEFAULT_LODS_EP = "automaticLOD";
    protected AutomaticLODContributionHandler automaticLODs;
    protected AutomaticRenderViewContributionHandler automaticRenderViews;
    protected RenderViewContributionHandler renderViews;

    public void activate(ComponentContext context) {
        this.automaticLODs = new AutomaticLODContributionHandler();
        this.automaticRenderViews = new AutomaticRenderViewContributionHandler();
        this.renderViews = new RenderViewContributionHandler();
    }

    public void deactivate(ComponentContext context) {
        WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        if (workManager != null && workManager.isStarted()) {
            try {
                workManager.shutdownQueue(workManager.getCategoryQueueId("threeDConversion"), 10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        this.automaticLODs = null;
        this.automaticRenderViews = null;
        this.renderViews = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        switch (extensionPoint) {
            case "renderViews": {
                this.renderViews.addContribution((RenderView)contribution);
                break;
            }
            case "automaticRenderViews": {
                this.automaticRenderViews.addContribution((AutomaticRenderView)contribution);
                break;
            }
            case "automaticLOD": {
                this.automaticLODs.addContribution((AutomaticLOD)contribution);
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        switch (extensionPoint) {
            case "renderViews": {
                this.renderViews.removeContribution((RenderView)contribution);
                break;
            }
            case "automaticRenderViews": {
                this.automaticRenderViews.removeContribution((AutomaticRenderView)contribution);
                break;
            }
            case "automaticLOD": {
                this.automaticLODs.removeContribution((AutomaticLOD)contribution);
            }
        }
    }

    public void cleanBatchData(DocumentModel doc) {
        ArrayList emptyList = new ArrayList();
        doc.setPropertyValue("threed:transmissionFormats", (Serializable)emptyList);
        doc.setPropertyValue("threed:renderViews", (Serializable)emptyList);
    }

    public void launchBatchConversion(DocumentModel doc) {
        this.cleanBatchData(doc);
        ThreeDBatchUpdateWork work = new ThreeDBatchUpdateWork(doc.getRepositoryName(), doc.getId());
        WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        workManager.schedule((Work)work, WorkManager.Scheduling.IF_NOT_SCHEDULED, true);
    }

    public BlobHolder batchConvert(ThreeD originalThreed) {
        ConversionService cs = (ConversionService)Framework.getService(ConversionService.class);
        ArrayList<Blob> in = new ArrayList<Blob>();
        in.add(originalThreed.getBlob());
        if (originalThreed.getResources() != null) {
            in.addAll(originalThreed.getResources());
        }
        List renderViews = (List)this.getAutomaticRenderViews();
        List lods = (List)this.getAutomaticLODs();
        HashMap<String, String> params = new HashMap<String, String>();
        String operators = "import info";
        operators = operators + new String(new char[renderViews.size()]).replace("\u0000", " render");
        operators = operators + new String(new char[lods.size()]).replace("\u0000", " lod info convert");
        params.put("operators", operators);
        params.put("renderIds", renderViews.stream().map(RenderView::getId).collect(Collectors.joining(" ")));
        params.put("lodIds", lods.stream().map(AutomaticLOD::getId).collect(Collectors.joining(" ")));
        params.put("percPoly", lods.stream().map(AutomaticLOD::getPercPoly).map(String::valueOf).collect(Collectors.joining(" ")));
        params.put("maxPoly", lods.stream().map(AutomaticLOD::getMaxPoly).map(String::valueOf).collect(Collectors.joining(" ")));
        params.put("coords", renderViews.stream().map(renderView -> renderView.getAzimuth() + "," + renderView.getZenith()).collect(Collectors.joining(" ")));
        params.put("dimensions", renderViews.stream().map(renderView -> renderView.getWidth() + "x" + renderView.getHeight()).collect(Collectors.joining(" ")));
        return cs.convert("batchConversion", (BlobHolder)new SimpleBlobHolder(in), params);
    }

    public Collection<RenderView> getAvailableRenderViews() {
        return this.renderViews.registry.values();
    }

    public Collection<RenderView> getAutomaticRenderViews() {
        return this.automaticRenderViews.registry.values().stream().filter(AutomaticRenderView::isEnabled).sorted((o1, o2) -> o1.getOrder() - o2.getOrder()).map(AutomaticRenderView::getId).map(this::getRenderView).filter(RenderView::isEnabled).collect(Collectors.toList());
    }

    public Collection<AutomaticLOD> getAvailableLODs() {
        return this.automaticLODs.registry.values();
    }

    public Collection<AutomaticLOD> getAutomaticLODs() {
        return this.automaticLODs.registry.values().stream().filter(AutomaticLOD::isEnabled).sorted((o1, o2) -> o1.getOrder() - o2.getOrder()).collect(Collectors.toList());
    }

    public AutomaticLOD getAutomaticLOD(String automaticLODId) {
        return this.automaticLODs.registry.get(automaticLODId);
    }

    public RenderView getRenderView(String renderViewId) {
        return this.renderViews.registry.get(renderViewId);
    }

    public RenderView getRenderView(Integer azimuth, Integer zenith) {
        return this.renderViews.registry.values().stream().filter(renderView -> renderView.getAzimuth().equals(azimuth) && renderView.getZenith().equals(zenith)).findFirst().orElse(null);
    }

    public TransmissionThreeD convertColladaToglTF(TransmissionThreeD colladaThreeD) {
        ConversionService cs = (ConversionService)Framework.getService(ConversionService.class);
        HashMap parameters = new HashMap();
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        blobs.add(colladaThreeD.getBlob());
        if (colladaThreeD.getResources() != null) {
            blobs.addAll(colladaThreeD.getResources());
        }
        BlobHolder result = cs.convert("dae2gltf", (BlobHolder)new SimpleBlobHolder(blobs), parameters);
        return new TransmissionThreeD((Blob)result.getBlobs().get(0), null, colladaThreeD.getInfo(), colladaThreeD.getPercPoly(), colladaThreeD.getMaxPoly(), colladaThreeD.getPercTex(), colladaThreeD.getMaxTex(), colladaThreeD.getName());
    }

    public ThreeDBatchProgress getBatchProgress(String repositoryName, String docId) {
        ThreeDBatchUpdateWork work;
        WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        Work workRunning = workManager.find((work = new ThreeDBatchUpdateWork(repositoryName, docId)).getId(), Work.State.RUNNING);
        if (workRunning != null) {
            return new ThreeDBatchProgress("status.threed.conversionRunning", workRunning.getStatus());
        }
        Work workScheduled = workManager.find(work.getId(), Work.State.SCHEDULED);
        if (workScheduled != null) {
            return new ThreeDBatchProgress("status.threed.conversionQueued", "");
        }
        return new ThreeDBatchProgress("status.threed.conversionUnknown", "");
    }
}

