/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.http;

import com.noelios.restlet.ClientHelper;
import com.noelios.restlet.http.HttpClientCall;
import com.noelios.restlet.http.HttpClientConverter;
import java.util.logging.Level;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public abstract class HttpClientHelper
extends ClientHelper {
    private HttpClientConverter converter = null;

    public HttpClientHelper(Client client) {
        super(client);
    }

    public abstract HttpClientCall create(Request var1);

    public void handle(Request request, Response response) {
        try {
            HttpClientCall httpCall = this.getConverter().toSpecific(this, request);
            this.getConverter().commit(httpCall, request, response);
        }
        catch (Exception e) {
            this.getLogger().log(Level.INFO, "Error while handling an HTTP client call", e);
            response.setStatus(Status.CONNECTOR_ERROR_INTERNAL, e.getMessage());
        }
    }

    public HttpClientConverter getConverter() throws Exception {
        if (this.converter == null) {
            String converterClass = this.getParameters().getFirstValue("converter", "com.noelios.restlet.http.HttpClientConverter");
            this.converter = (HttpClientConverter)Class.forName(converterClass).getConstructor(Context.class).newInstance(this.getContext());
        }
        return this.converter;
    }

    public void setConverter(HttpClientConverter converter) {
        this.converter = converter;
    }
}

